/*                                                                
**  Copyright (C) 1996,2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* punlearn.c

   Implimentaton:

   Add a ";" delimiter to split PFILES into FRONT and BACK sections

             <---FRONT------------>  <---BACK--------------->
     PFILES="uparm pfiles job1 job2; paramdefault irafdefault"

   Add a flag to paramopen to control the search for a pfile.

   A call with the reference flag set forces an open of paramfile from
   the BACK portion of PFILES.

   Force write to always happen to a file in the FRONT part of PFILES


   With the above rules a normal paramopen looks through FRONT and BACK
   to find a paramfile.  A paramopen with "R" mode set looks through 
   BACK only to find the "reference" copy of the file.  Both modes
   write out only to a copy of the paramfile in the FRONT part of
   PFILES.
*/

#include <unistd.h>
#include <stdlib.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

int
main(int argc, char *argv[])
{
  paramfile pfile;

  if ( argc == 1 ) {
    fprintf(stderr, "plist: no paramfiles to unlearn\n");
    exit(1);
  }

  for ( argv++; argc-- >= 2; argv++ ) {
    if ( (pfile = paramopen(*argv, NULL, 0, "rwR")) == NULL ) {
      fprintf(stderr, "punlearn: can't open parameter file: %s\n", *argv);
      exit(1);
    }
    /* fclose (and write)
     */
    paramclose(pfile);		/* writes always happen to a
				 * file in FRONT */
  }

  return 0;
}



