# Generated by default/object.tt
package Paws::LexModelsV2::MultipleValuesSetting;
  use Moose;
  has AllowMultipleValues => (is => 'ro', isa => 'Bool', request_name => 'allowMultipleValues', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::MultipleValuesSetting

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::MultipleValuesSetting object:

  $service_obj->Method(Att1 => { AllowMultipleValues => $value, ..., AllowMultipleValues => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::MultipleValuesSetting object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowMultipleValues

=head1 DESCRIPTION

Indicates whether a slot can return multiple values.

=head1 ATTRIBUTES


=head2 AllowMultipleValues => Bool

Indicates whether a slot can return multiple values. When C<true>, the
slot may return more than one value in a response. When C<false>, the
slot returns only a single value.

Multi-value slots are only available in the en-US locale. If you set
this value to C<true> in any other locale, Amazon Lex throws a
C<ValidationException>.

If the C<allowMutlipleValues> is not set, the default value is
C<false>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

