package Proc::tored::Pool::Worker;
# ABSTRACT: executes a single code block
$Proc::tored::Pool::Worker::VERSION = '0.01';
use strict;
use warnings;
use Moo;
use Try::Tiny;

with 'Proc::tored::Role::Running';


sub work {
  my ($class, $code) = @_;
  my $self = $class->new;
  $self->start;
  return unless $self->is_running;
  try { [1, $code->(@_)] }
  catch { [0, $_] };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Proc::tored::Pool::Worker - executes a single code block

=head1 VERSION

version 0.01

=head1 METHODS

=head2 work

A class method that executes a supplied C<CODE> ref. Returns an
C<ARRAY> ref of two values.

If the code executes successfully, an C<ARRAY> ref is returned containing a
true value followed by any values returned by the code ref. Note that the
supplied C<CODE> ref is evaluated in list context.

If the code dies when called, an C<ARRAY> ref is returned containing a false
value followed by the error thrown.

=head1 AUTHOR

Jeff Ober <jeffober@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Jeff Ober.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
