// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ClangPragmaHandler_h__
#define __ClangPragmaHandler_h__

#include "Phase1.h"
#include "Plan.h"

#include "clang/Lex/Pragma.h"

// Define a pragma handler for #pragma example_pragma
class ClangPragmaHandler : public clang::PragmaHandler {
  Phase1 &p1_;
  DepRules &deps_;
public:
  ClangPragmaHandler(Phase1 &p1, DepRules &deps) : clang::PragmaHandler("acxx"),
    p1_(p1), deps_(deps) { }
  void HandlePragma(clang::Preprocessor &PP, clang::PragmaIntroducer Introducer,
                    clang::Token &PragmaTok);
  string to_regex_syntax(const string &in, char prefix, char suffix);
};

#endif // __ClangPragmaHandler_h__
