/*
 * Copyright 2014 - Present Rafael Winterhalter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.bytebuddy.benchmark.specimen;

/**
 * An example class with several methods which is used as a specimen in benchmarks.
 */
public class ExampleClass {

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public boolean method(boolean arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public byte method(byte arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public short method(short arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public int method(int arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public char method(char arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public long method(long arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public float method(float arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public double method(double arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg An argument.
     * @return The input argument.
     */
    public Object method(Object arg) {
        return arg;
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public boolean[] method(boolean arg1, boolean arg2, boolean arg3) {
        return new boolean[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public byte[] method(byte arg1, byte arg2, byte arg3) {
        return new byte[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public short[] method(short arg1, short arg2, short arg3) {
        return new short[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public int[] method(int arg1, int arg2, int arg3) {
        return new int[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public char[] method(char arg1, char arg2, char arg3) {
        return new char[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public long[] method(long arg1, long arg2, long arg3) {
        return new long[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public float[] method(float arg1, float arg2, float arg3) {
        return new float[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public double[] method(double arg1, double arg2, double arg3) {
        return new double[]{arg1, arg2, arg3};
    }

    /**
     * An example method.
     *
     * @param arg1 An argument.
     * @param arg2 An argument.
     * @param arg3 An argument.
     * @return All arguments stored in an array.
     */
    public Object[] method(Object arg1, Object arg2, Object arg3) {
        return new Object[]{arg1, arg2, arg3};
    }
}
