This release closes 14 issues.

Highlights
==========

`CMD` and `ENTRYPOINT` support
------------------------------

Charliecloud now supports the `CMD` and `ENTRYPOINT` Dockerfile instructions
(#780). Unlike other container implementations, use of these stored user
command and/or arguments must be specifically requested, though that’s simple
— just give the user command of a single hyphen (“`-`”). Note also that our
implementation matches Docker’s *as implemented*, not as documented.

Set explicit signal mask, making newer Slurms happier
-----------------------------------------------------

`ch-run` now unblocks the signals it uses (#2081). The most common symptom of
this bug might be failures with newer Slurm, which blocks `SIGCHLD`.

Environment variables set correctly under `--join` (really this time)
---------------------------------------------------------------------

A previous merge request (!1974) incorrectly fixed environment variable
handling under `ch-run --join`, which is used to run multiple user commands in
the same container, by causing all joined processes to have the *same*
environment (#2069). This broke many use cases, e.g. PMI communicates MPI rank
numbers to processes using environment variables. `ch-run` now does
environment variable manipulation (`--set-env`, CDI, etc.) independently in
each `--join` process, correctly passing through and differences in their
starting environments.


Other changes by component
==========================

`ch-run`
--------

* Seccomp root emulation no longer errors on s390x (#2073).

`ch-image`
----------

—

Build/install
-------------

* Build failure on i386 fixed (#2070).
* CI testing of nVidia GPUs disabled while we debug it (#2075).
* Fix permissions on GitLab releases page (#2078).
* `configure --with-gc-include` now works (#2084).

Documentation/logging
---------------------

* Fix external link in documentation (#1978).
* Cray `libfabric` CDI example now includes needed `ldconfig(8)` hook (#2087).

Test/examples/CI
----------------

* Update some examples (#2040).
* Attempt `sudo(8)` less enthusiastically, making sysadmins happier (#2085).
* Issues both introduced and fixed in the 0.43 cycle (#2074, #2080).

Miscellaneous
-------------

—