/******************************************************************************/
/*  This plugin implements the 3D 27-point finite-difference stencil with     */
/*  optimized weights for the discretization of the Helmholtz equation from   */
/*                                                                            */
/*  Operto, S., Virieux, J., Amestoy, P., L’Excellent, J. Y., Giraud, L.,     */
/*  & Ali, H. B. H. (2007). 3D finite-difference frequency-domain modeling of */
/*  visco-acoustic wave propagation using a massively parallel direct solver: */
/*  A feasibility study. Geophysics, 72(5), SM195-SM211.                      */
/******************************************************************************/

#include "ff++.hpp"

double wtab[2752] = {
3.00,  0.697262824,  0.007167050,  0.015915025,  0.008594321,  0.307393283,  0.627489984,  0.065116704,
3.05,  0.628711581,  0.019996662,  0.020661540,  0.000421245,  0.196920782,  0.647126138,  0.155953109,
3.10,  0.702129424,  0.007504661,  0.015171047,  0.008848755,  0.301299810,  0.633790970,  0.064909220,
3.15,  0.597348213,  0.041101128,  0.008118212,  0.007328309,  0.093332671,  0.824724078,  0.081943274,
3.20,  0.661647201,  0.027431741,  0.006051943,  0.012642380,  0.182384640,  0.794680238,  0.022935152,
3.25,  0.590004981,  0.035895996,  0.015874669,  0.000515377,  0.099336565,  0.759529948,  0.141133487,
3.30,  0.684338808,  0.015859213,  0.012579773,  0.008693581,  0.233117074,  0.703543723,  0.063339174,
3.35,  0.669184208,  0.011757366,  0.020814210,  0.001312636,  0.247642487,  0.613769174,  0.138588309,
3.40,  0.605685830,  0.037952259,  0.010843948,  0.004559156,  0.106312215,  0.794963479,  0.098724306,
3.45,  0.577374458,  0.051351979,  0.004654191,  0.007332921,  0.049069352,  0.873899043,  0.077031612,
3.50,  0.730903447,  0.008098722,  0.009822279,  0.012829609,  0.288530648,  0.673810482,  0.037658870,
3.55,  0.732483745,  0.009664774,  0.008094728,  0.014048859,  0.271239400,  0.705184042,  0.023576558,
3.60,  0.549728930,  0.054577745,  0.009134758,  0.001648435,  0.037431475,  0.838261247,  0.124307275,
3.65,  0.588351130,  0.043233294,  0.011057518,  0.002444860,  0.092888221,  0.790881932,  0.116229832,
3.70,  0.593093634,  0.045007516,  0.008323755,  0.004622025,  0.089279830,  0.814085007,  0.096635163,
3.75,  0.705916226,  0.023702361,  0.001588978,  0.016600234,  0.207035929,  0.783495188,  0.009468913,
3.80,  0.644065440,  0.033188105,  0.007746205,  0.007981434,  0.152613044,  0.772635043,  0.074751914,
3.85,  0.686284721,  0.022006951,  0.008582693,  0.009835158,  0.199806958,  0.739966452,  0.060226619,
3.90,  0.723992169,  0.011347204,  0.009974223,  0.011029242,  0.241037920,  0.706667662,  0.052294433,
3.95,  0.740161359,  0.010516703,  0.006949648,  0.014167830,  0.250821084,  0.716488242,  0.032690644,
4.00,  0.642623544,  0.039591655,  0.002390578,  0.011392448,  0.130669326,  0.820143163,  0.049187481,
4.05,  0.751542628,  0.013616130,  0.001332268,  0.018846672,  0.239774108,  0.758091807,  0.002134085,
4.10,  0.661690295,  0.024728056,  0.012804141,  0.004536461,  0.177133024,  0.727850020,  0.095016956,
4.15,  0.705562830,  0.019282497,  0.007421181,  0.011211002,  0.205830038,  0.740188360,  0.053981602,
4.20,  0.705840707,  0.019233696,  0.007550273,  0.011019230,  0.204900950,  0.739971042,  0.055127978,
4.25,  0.739306688,  0.015376367,  0.003157761,  0.016317748,  0.224924207,  0.749649525,  0.025426269,
4.30,  0.739022791,  0.014730528,  0.004004352,  0.015567727,  0.226050586,  0.742380440,  0.031568944,
4.35,  0.709601521,  0.021181472,  0.005025975,  0.012874743,  0.197820157,  0.756129682,  0.046050131,
4.40,  0.669521511,  0.030052802,  0.006280851,  0.009348935,  0.167438671,  0.764807403,  0.067753911,
4.45,  0.728317499,  0.012321327,  0.009424124,  0.010583131,  0.221986711,  0.716708302,  0.061304986,
4.50,  0.672598481,  0.025759801,  0.010038640,  0.006547378,  0.177590564,  0.739277303,  0.083132148,
4.55,  0.637889147,  0.032052111,  0.012512553,  0.002455944,  0.157799035,  0.735930085,  0.106270909,
4.60,  0.679027796,  0.019366715,  0.015022421,  0.003062855,  0.189626575,  0.710654736,  0.099718690,
4.65,  0.755430341,  0.002795290,  0.012594124,  0.009583555,  0.242896020,  0.689434111,  0.067669868,
4.70,  0.735527098,  0.009054719,  0.011400590,  0.009167189,  0.223600373,  0.706640780,  0.069758832,
4.75,  0.685611308,  0.024061970,  0.008955622,  0.007818676,  0.184873581,  0.736821055,  0.078305364,
4.80,  0.661247611,  0.027647898,  0.011559054,  0.004269544,  0.168490216,  0.738675535,  0.092834234,
4.85,  0.649699926,  0.038785405,  0.003384510,  0.009621690,  0.145459771,  0.786229610,  0.068310618,
4.90,  0.600613177,  0.043000001,  0.011522740,  0.000389241,  0.128073946,  0.761512101,  0.110413969,
4.95,  0.731156349,  0.010320447,  0.011637069,  0.008409517,  0.216091290,  0.708488405,  0.075420320,
5.00,  0.643246651,  0.035132140,  0.008888522,  0.004912280,  0.153290153,  0.756346762,  0.090363085,
5.05,  0.718462586,  0.023937641,  0.001353388,  0.015208865,  0.189178646,  0.763775110,  0.047046244,
5.10,  0.728470743,  0.006253866,  0.016604763,  0.004343614,  0.218121752,  0.690121174,  0.091757059,
5.15,  0.677486539,  0.027201064,  0.008469470,  0.007209180,  0.175213560,  0.743366539,  0.081419885,
5.20,  0.736674428,  0.007843078,  0.013100819,  0.007382160,  0.216894522,  0.702840269,  0.080265224,
5.25,  0.730766773,  0.001002725,  0.021477260,  0.000686221,  0.225052625,  0.668507040,  0.106440365,
5.30,  0.686039031,  0.024262933,  0.009459300,  0.006858972,  0.181184858,  0.735759377,  0.083055735,
5.35,  0.720685959,  0.006757588,  0.018372390,  0.002287479,  0.213174522,  0.687094331,  0.099731147,
5.40,  0.643997490,  0.035632249,  0.008720243,  0.004695763,  0.155371577,  0.753929377,  0.090699077,
5.45,  0.593268335,  0.055888854,  0.001214772,  0.007102661,  0.115290038,  0.804074764,  0.080635190,
5.50,  0.716838837,  0.005793421,  0.020465158,  0.000352343,  0.212645128,  0.680675685,  0.106679201,
5.55,  0.697915971,  0.022620669,  0.008426502,  0.008155249,  0.181773081,  0.741187036,  0.077039897,
5.60,  0.592262268,  0.050731108,  0.006785112,  0.002741219,  0.126978710,  0.776069999,  0.096951306,
5.65,  0.734041989,  0.003035368,  0.019082792,  0.002344036,  0.215238228,  0.687019885,  0.097741902,
5.70,  0.556647241,  0.063052624,  0.003463144,  0.002934910,  0.107175194,  0.796392262,  0.096432567,
5.75,  0.710051417,  0.016367614,  0.011842607,  0.006203953,  0.193122923,  0.721730053,  0.085147023,
5.80,  0.706029475,  0.012037156,  0.017226923,  0.001878064,  0.196718752,  0.704768419,  0.098512828,
5.85,  0.654612601,  0.036256686,  0.005908306,  0.007118452,  0.158143133,  0.759888172,  0.081968665,
5.90,  0.638387680,  0.045784108,  0.000482990,  0.010138975,  0.145752400,  0.780688822,  0.073558748,
5.95,  0.765625477,  0.009006737,  0.005495900,  0.014297913,  0.209866196,  0.729331076,  0.060802758,
6.00,  0.644492924,  0.038544871,  0.006277613,  0.006113311,  0.156966522,  0.756561697,  0.086471796,
6.05,  0.699514270,  0.014493953,  0.016615160,  0.001767512,  0.191459492,  0.710442722,  0.098097801,
6.10,  0.735310376,  0.000916126,  0.021286702,  0.000469059,  0.213263273,  0.684441924,  0.102294803,
6.15,  0.737085044,  0.019869011,  0.001928771,  0.015069457,  0.193129137,  0.745510876,  0.061360002,
6.20,  0.635766864,  0.033920370,  0.013246342,  0.000219352,  0.160126776,  0.737914145,  0.101959050,
6.25,  0.694312274,  0.017446823,  0.015117271,  0.002449943,  0.185918257,  0.718855798,  0.095225930,
6.30,  0.716026843,  0.015522248,  0.011648934,  0.006381558,  0.190181285,  0.725651085,  0.084167659,
6.35,  0.725953043,  0.008335987,  0.016386669,  0.003423875,  0.200004071,  0.707276762,  0.092719138,
6.40,  0.671939135,  0.030642044,  0.007625898,  0.006587229,  0.170570269,  0.744471550,  0.084958196,
6.45,  0.731507123,  0.006026622,  0.017375994,  0.002977652,  0.205093756,  0.699757218,  0.095149040,
6.50,  0.775374591,  0.009834517,  0.002630318,  0.016756810,  0.205848545,  0.734423161,  0.059728265,
6.55,  0.737466514,  0.001978302,  0.020002356,  0.001329426,  0.208096489,  0.693314075,  0.098589420,
6.60,  0.724905312,  0.007886129,  0.017260177,  0.002581974,  0.201022938,  0.703096569,  0.095880508,
6.65,  0.642845452,  0.031919204,  0.013781587,  0.000032535,  0.163961738,  0.736084521,  0.099953711,
6.70,  0.627521098,  0.039608911,  0.009952100,  0.001925030,  0.155569673,  0.748877347,  0.095552981,
6.75,  0.727513790,  0.021901295,  0.002691241,  0.013597943,  0.186210811,  0.745026588,  0.068762600,
6.80,  0.736520290,  0.021667169,  0.000693249,  0.015644714,  0.189341038,  0.745036721,  0.065622211,
6.85,  0.703413725,  0.026231050,  0.004436190,  0.010745712,  0.180602312,  0.742578208,  0.076819479,
6.90,  0.707485795,  0.029000759,  0.000674026,  0.013802667,  0.176528722,  0.754408419,  0.069062889,
6.95,  0.683170557,  0.019828230,  0.015959816,  0.000792783,  0.180165887,  0.722622693,  0.097211421,
7.00,  0.741733968,  0.000309452,  0.020857314,  0.000765193,  0.205371931,  0.696482182,  0.098145902,
7.05,  0.733277380,  0.018847374,  0.004457326,  0.012518808,  0.189332068,  0.737355947,  0.073311985,
7.10,  0.686947584,  0.020329216,  0.014589685,  0.002000112,  0.181159586,  0.723943591,  0.094896793,
7.15,  0.763238966,  0.008346494,  0.007512387,  0.012066679,  0.201269120,  0.723774552,  0.074956298,
7.20,  0.755818844,  0.016949568,  0.000800188,  0.016610187,  0.190597326,  0.745290041,  0.064112663,
7.25,  0.684460104,  0.033079147,  0.002528107,  0.010840966,  0.172526523,  0.749671519,  0.077801943,
7.30,  0.780553758,  0.005270217,  0.006330614,  0.013982195,  0.201851696,  0.728019595,  0.070128679,
7.35,  0.720273495,  0.017769041,  0.008928446,  0.008246363,  0.190375119,  0.725288272,  0.084336638,
7.40,  0.691181540,  0.033674657,  0.000313735,  0.012875712,  0.170473114,  0.756505847,  0.073021054,
7.45,  0.724639952,  0.017434690,  0.008219006,  0.009015479,  0.185226962,  0.734799385,  0.079973638,
7.50,  0.650077581,  0.035191968,  0.009118620,  0.003668396,  0.170341194,  0.736124039,  0.093534768,
7.55,  0.698249280,  0.018233035,  0.014053045,  0.002964497,  0.182294697,  0.725737393,  0.091967881,
7.60,  0.732726693,  0.003651323,  0.020039063,  0.000612076,  0.198038265,  0.704833031,  0.097128689,
7.65,  0.785859823,  0.010407180,  0.000015683,  0.018938612,  0.203314006,  0.730436444,  0.066249549,
7.70,  0.592862785,  0.049690478,  0.009004613,  0.000117376,  0.144601583,  0.761113882,  0.094284534,
7.75,  0.605973721,  0.051153421,  0.004281623,  0.004465784,  0.155343205,  0.752932906,  0.091723919,
7.80,  0.789317489,  0.002593447,  0.007029239,  0.013846369,  0.205384582,  0.720143259,  0.074472129,
7.85,  0.706174791,  0.016937090,  0.013491407,  0.003788223,  0.182299182,  0.728245080,  0.089455724,
7.90,  0.666150868,  0.038350385,  0.002098883,  0.009820030,  0.162583888,  0.759026945,  0.078389168,
7.95,  0.799540281,  0.003311466,  0.003811127,  0.016857177,  0.200973064,  0.731083333,  0.067943633,
8.00,  0.680162311,  0.022954039,  0.014026556,  0.001724347,  0.172286659,  0.736675143,  0.091038227,
8.05,  0.759831607,  0.004041791,  0.013042748,  0.007425584,  0.194693774,  0.722206652,  0.083099544,
8.10,  0.718426704,  0.026699424,  0.000747219,  0.014051266,  0.178020686,  0.748722494,  0.073256791,
8.15,  0.651540279,  0.037407469,  0.006764994,  0.005354373,  0.165006176,  0.747445941,  0.087547898,
8.20,  0.614697039,  0.043270975,  0.010134578,  0.000507772,  0.162323758,  0.740480542,  0.097195685,
8.25,  0.625735939,  0.049280617,  0.001384329,  0.007746050,  0.159123883,  0.755485237,  0.085390866,
8.30,  0.725445449,  0.019521395,  0.006236922,  0.010322889,  0.184575632,  0.734737873,  0.080686510,
8.35,  0.653648674,  0.039499819,  0.004212866,  0.007349753,  0.161582902,  0.755483210,  0.082933903,
8.40,  0.697551310,  0.032635413,  0.000126698,  0.013139479,  0.174316034,  0.749188185,  0.076495767,
8.45,  0.756601036,  0.007870061,  0.010133540,  0.009322015,  0.195246026,  0.721213520,  0.083540440,
8.50,  0.686896741,  0.019905558,  0.015535688,  0.000905208,  0.182542026,  0.721521914,  0.095936060,
8.55,  0.692634821,  0.028701732,  0.005328579,  0.008901480,  0.168360725,  0.752613902,  0.079025388,
8.60,  0.709603131,  0.025053587,  0.004741546,  0.010397101,  0.176766813,  0.743414402,  0.079818785,
8.65,  0.562588334,  0.062730834,  0.003832389,  0.001879750,  0.144731358,  0.763089716,  0.092178941,
8.70,  0.709370255,  0.015403642,  0.014482113,  0.003052816,  0.176666811,  0.736030579,  0.087302625,
8.75,  0.567155123,  0.058938250,  0.006502643,  0.000147957,  0.153613403,  0.748631060,  0.097755551,
8.80,  0.757969081,  0.005018137,  0.012737557,  0.007383926,  0.196088552,  0.717094302,  0.086817145,
8.85,  0.637681782,  0.041443706,  0.006406926,  0.004596610,  0.167452842,  0.742133498,  0.090413690,
8.90,  0.696166277,  0.022483753,  0.010752261,  0.004988009,  0.171393678,  0.744028687,  0.084577620,
8.95,  0.641492724,  0.038330950,  0.008586541,  0.003185386,  0.164259881,  0.746261537,  0.089478552,
9.00,  0.744261920,  0.014480891,  0.006752837,  0.010977335,  0.185281217,  0.734718859,  0.079999924,
9.05,  0.604861915,  0.054672804,  0.001425516,  0.006249385,  0.154924199,  0.758761585,  0.086314201,
9.10,  0.734394789,  0.011045747,  0.012673132,  0.005906643,  0.182829916,  0.732042849,  0.085127234,
9.15,  0.627262056,  0.046458948,  0.004051410,  0.005670916,  0.164540574,  0.746340811,  0.089118600,
9.20,  0.644625247,  0.042768665,  0.003425462,  0.007207151,  0.162356779,  0.753559232,  0.084083974,
9.25,  0.674772859,  0.029341169,  0.009332273,  0.004649106,  0.165553004,  0.750079751,  0.084367275,
9.30,  0.655452967,  0.033674210,  0.009829640,  0.003068261,  0.180664375,  0.723415256,  0.095920384,
9.35,  0.611765504,  0.053841263,  0.000584934,  0.007270964,  0.162311241,  0.749586463,  0.088102281,
9.40,  0.606882989,  0.054846037,  0.000811920,  0.006787218,  0.162672743,  0.748103857,  0.089223385,
9.45,  0.632426262,  0.038748465,  0.010535475,  0.001082156,  0.171522275,  0.732932031,  0.095545709,
9.50,  0.729691505,  0.020070985,  0.004907718,  0.011373746,  0.187783867,  0.728058815,  0.084157348,
9.55,  0.670830190,  0.033085611,  0.006625537,  0.006393714,  0.175327137,  0.736235499,  0.088437378,
9.60,  0.687369466,  0.034159482,  0.001422087,  0.011326076,  0.172774851,  0.745992362,  0.081232786,
9.65,  0.731532156,  0.006324587,  0.018232957,  0.001465606,  0.182184324,  0.728429914,  0.089385748,
9.70,  0.647118330,  0.033703547,  0.011964437,  0.000885895,  0.167865753,  0.740575910,  0.091558337,
9.75,  0.720653296,  0.013443928,  0.013856275,  0.004050981,  0.176564664,  0.737988055,  0.085447252,
9.80,  0.733275950,  0.005911957,  0.018226840,  0.001566280,  0.203884900,  0.695576549,  0.100538552,
9.85,  0.560077786,  0.063379243,  0.004070256,  0.001350461,  0.144632742,  0.766947985,  0.088419259,
9.90,  0.762389541,  0.009851214,  0.007040165,  0.011752650,  0.180735469,  0.741924822,  0.077339709,
9.95,  0.724952698,  0.014183916,  0.012079667,  0.005623475,  0.172745883,  0.745286882,  0.081967235,
10.00,  0.798044562,  0.007615812,  0.000370339,  0.018977063,  0.180253074,  0.751583099,  0.068163812,
10.05,  0.707427442,  0.020877384,  0.009771857,  0.006255746,  0.173551977,  0.742345214,  0.084102809,
10.10,  0.714741707,  0.015042767,  0.013780370,  0.003704656,  0.178732216,  0.733217955,  0.088049829,
10.15,  0.796544731,  0.007786527,  0.000610150,  0.018676788,  0.189338237,  0.736833274,  0.073828518,
10.20,  0.752726078,  0.003241500,  0.016112743,  0.004309002,  0.186903670,  0.725375235,  0.087721109,
10.25,  0.600836337,  0.050188489,  0.007147860,  0.001532299,  0.166097417,  0.739989996,  0.093912601,
10.30,  0.624425650,  0.045098323,  0.006333862,  0.003622258,  0.155066222,  0.760279775,  0.084653974,
10.35,  0.622179627,  0.051377967,  0.000629879,  0.007749252,  0.176270604,  0.731271684,  0.092457712,
10.40,  0.687915444,  0.032495048,  0.003079327,  0.010020294,  0.189899549,  0.718322694,  0.091777742,
10.45,  0.510093689,  0.079129308,  0.000900544,  0.000540491,  0.157060981,  0.744453490,  0.098485529,
10.50,  0.775071323,  0.006995384,  0.006808441,  0.012656884,  0.198624194,  0.715105593,  0.086270213,
10.55,  0.759528875,  0.014222167,  0.003486849,  0.014161991,  0.191726848,  0.725146830,  0.083126307,
10.60,  0.671943724,  0.027052635,  0.012567002,  0.001867054,  0.156989917,  0.761320829,  0.081689239,
10.65,  0.735664845,  0.016404569,  0.007293276,  0.009798553,  0.177687928,  0.741255939,  0.081056118,
10.70,  0.687610447,  0.031170320,  0.004536416,  0.008866331,  0.163551867,  0.757252872,  0.079195261,
10.75,  0.674482584,  0.034131497,  0.004854865,  0.007808756,  0.160787880,  0.759333372,  0.079878747,
10.80,  0.713703215,  0.019295909,  0.009910833,  0.006448917,  0.187074989,  0.722675264,  0.090249717,
10.85,  0.666478634,  0.039197810,  0.001810361,  0.009576272,  0.193670183,  0.710409224,  0.095920622,
10.90,  0.538286209,  0.070543654,  0.002511822,  0.001038749,  0.170275599,  0.728904247,  0.100820184,
10.95,  0.722132862,  0.019914761,  0.007202789,  0.008993138,  0.179133967,  0.736895561,  0.083970487,
11.00,  0.775188446,  0.002110202,  0.011726528,  0.008928999,  0.179489613,  0.740018725,  0.080491662,
11.05,  0.660312831,  0.034631196,  0.007956591,  0.004552612,  0.164969057,  0.750347555,  0.084683359,
11.10,  0.570146918,  0.064826190,  0.000298418,  0.004664365,  0.154196918,  0.759139419,  0.086663663,
11.15,  0.763172686,  0.010062631,  0.006793454,  0.011866260,  0.185430080,  0.731678963,  0.082890987,
11.20,  0.714733124,  0.023543930,  0.005441414,  0.009838291,  0.169459432,  0.750653207,  0.079887331,
11.25,  0.604502499,  0.054907538,  0.001629133,  0.005812833,  0.176099509,  0.729095876,  0.094804585,
11.30,  0.641456842,  0.041145757,  0.006178096,  0.004691433,  0.161805794,  0.753731728,  0.084462464,
11.35,  0.728042305,  0.011284340,  0.014400549,  0.003930632,  0.206198439,  0.692909837,  0.100891709,
11.40,  0.771990716,  0.006124873,  0.008567598,  0.011056108,  0.211238742,  0.692720175,  0.096041083,
11.45,  0.741813183,  0.018255446,  0.003990404,  0.012596160,  0.170166343,  0.753319442,  0.076514184,
11.50,  0.653191566,  0.034932330,  0.009476501,  0.002937054,  0.183023959,  0.721411407,  0.095564663,
11.55,  0.664150715,  0.037255630,  0.004418969,  0.007410984,  0.183044419,  0.725021720,  0.091933846,
11.60,  0.758137107,  0.010300789,  0.007876605,  0.010692362,  0.161637321,  0.766097665,  0.072265029,
11.65,  0.697066844,  0.027567523,  0.005878599,  0.008373103,  0.193790779,  0.711349308,  0.094859898,
11.70,  0.664852500,  0.035381313,  0.006123699,  0.006171905,  0.167638406,  0.747312129,  0.085049450,
11.75,  0.730120420,  0.022711206,  0.002495445,  0.012958374,  0.180838555,  0.736388803,  0.082772613,
11.80,  0.706266522,  0.013552571,  0.017629609,  0.000107843,  0.182957873,  0.724156797,  0.092885315,
11.85,  0.675682306,  0.029335268,  0.009470142,  0.004333047,  0.186431378,  0.718340933,  0.095227659,
11.90,  0.604786634,  0.053452924,  0.003083225,  0.004687140,  0.164481729,  0.746950388,  0.088567853,
11.95,  0.692369878,  0.020273544,  0.014371768,  0.001690956,  0.161582887,  0.755657673,  0.082759440,
12.00,  0.694708109,  0.024061449,  0.010019578,  0.005086033,  0.196226329,  0.705950379,  0.097823262,
12.05,  0.732194602,  0.018152002,  0.006576806,  0.009996463,  0.162121847,  0.762985051,  0.074893117,
12.10,  0.704596221,  0.024311692,  0.007303685,  0.007736176,  0.176067069,  0.738277316,  0.085655630,
12.15,  0.656632245,  0.032063607,  0.011563718,  0.001527686,  0.182731122,  0.722112954,  0.095155895,
12.20,  0.657639384,  0.030910037,  0.012439933,  0.000952650,  0.170832738,  0.739240587,  0.089926660,
12.25,  0.660332799,  0.042318996,  0.000362214,  0.010175833,  0.201920643,  0.697218537,  0.100860834,
12.30,  0.651309133,  0.035345394,  0.009614673,  0.002655303,  0.154171154,  0.765324533,  0.080504298,
12.35,  0.725657940,  0.007373217,  0.019000620,  0.000261914,  0.150716364,  0.773906052,  0.075377584,
12.40,  0.568968117,  0.064499371,  0.001060508,  0.003913697,  0.176366925,  0.727344036,  0.096289039,
12.45,  0.744530499,  0.012033693,  0.009616859,  0.008483129,  0.191205174,  0.718115389,  0.090679467,
12.50,  0.741482973,  0.020216513,  0.002212025,  0.013834205,  0.212230474,  0.689047694,  0.098721862,
12.55,  0.614267528,  0.046104338,  0.008125730,  0.001449712,  0.135747001,  0.789840996,  0.074411988,
12.60,  0.567347109,  0.064327240,  0.001639552,  0.003376853,  0.132098824,  0.793565631,  0.074335575,
12.65,  0.673445702,  0.031689785,  0.007764861,  0.005404657,  0.184797153,  0.721658289,  0.093544543,
12.70,  0.652556658,  0.039481007,  0.005214557,  0.005997827,  0.140404761,  0.788059235,  0.071536005,
12.75,  0.725125432,  0.019086789,  0.007456597,  0.008859335,  0.192517981,  0.715334713,  0.092147291,
12.80,  0.661961317,  0.036234725,  0.006078526,  0.005961001,  0.193772078,  0.707414925,  0.098812997,
12.85,  0.642713308,  0.040332936,  0.006833710,  0.004160570,  0.175249681,  0.734277964,  0.090472341,
12.90,  0.738380969,  0.022402726,  0.000840865,  0.014639037,  0.181741714,  0.734712362,  0.083545923,
12.95,  0.704517722,  0.029127352,  0.002580315,  0.011219298,  0.192632750,  0.714637876,  0.092729390,
13.00,  0.630471587,  0.042491749,  0.007730529,  0.002726447,  0.201483369,  0.692733884,  0.105782747,
13.05,  0.710673630,  0.013418403,  0.016751640,  0.000974536,  0.182054922,  0.725996017,  0.091949046,
13.10,  0.614334285,  0.047275580,  0.006991714,  0.002263956,  0.135865241,  0.790625811,  0.073508978,
13.15,  0.721841455,  0.013219237,  0.014152825,  0.003626153,  0.209482580,  0.686300099,  0.104217350,
13.20,  0.691670477,  0.027179100,  0.007770687,  0.006500835,  0.196792960,  0.705630720,  0.097576320,
13.25,  0.687379479,  0.026573107,  0.009438056,  0.004990650,  0.184179202,  0.723533928,  0.092286885,
13.30,  0.585538507,  0.055487428,  0.006006163,  0.001182871,  0.170805782,  0.736575484,  0.092618704,
13.35,  0.557284057,  0.065956786,  0.002590083,  0.001986779,  0.115980469,  0.817647934,  0.066371620,
13.40,  0.629613340,  0.046451196,  0.004014723,  0.005437851,  0.216535300,  0.671440601,  0.112024069,
13.45,  0.694086432,  0.025263757,  0.009069107,  0.005687717,  0.177962780,  0.733235180,  0.088802040,
13.50,  0.699766278,  0.031556524,  0.001361847,  0.011819052,  0.183224946,  0.728090286,  0.088684797,
13.55,  0.786130905,  0.005859770,  0.005491737,  0.014101204,  0.181184083,  0.737541556,  0.081274390,
13.60,  0.652902365,  0.033395275,  0.011283882,  0.001414925,  0.180976197,  0.725486219,  0.093537569,
13.65,  0.766006589,  0.004718501,  0.011646405,  0.008240692,  0.178020373,  0.737867415,  0.084112227,
13.70,  0.638251364,  0.038967464,  0.009348910,  0.001969615,  0.176437631,  0.731100321,  0.092462063,
13.75,  0.772822976,  0.012917720,  0.001787543,  0.016027523,  0.160995126,  0.768132389,  0.070872486,
13.80,  0.795924425,  0.000001829,  0.008934669,  0.012106072,  0.190788224,  0.722572505,  0.086639285,
13.85,  0.712637007,  0.016933046,  0.012837119,  0.003964910,  0.147839814,  0.779684186,  0.072476029,
13.90,  0.760183096,  0.012833025,  0.005038776,  0.012794182,  0.207206726,  0.696023166,  0.096770108,
13.95,  0.762026608,  0.006793361,  0.010581672,  0.008779146,  0.176248670,  0.740152180,  0.083599150,
14.00,  0.622943103,  0.049167890,  0.002990570,  0.005770339,  0.192139506,  0.708034217,  0.099826276,
14.05,  0.655722380,  0.034870993,  0.009125449,  0.003193285,  0.160878703,  0.756313086,  0.082808197,
14.10,  0.749844611,  0.001728453,  0.018717691,  0.001896547,  0.207903415,  0.689705551,  0.102391064,
14.15,  0.661753058,  0.037709214,  0.004778191,  0.006831670,  0.127366021,  0.808602035,  0.064031959,
14.20,  0.739294708,  0.011356346,  0.011732958,  0.006471464,  0.234153181,  0.651235938,  0.114610910,
14.25,  0.634925187,  0.040906936,  0.008267399,  0.002553051,  0.216608196,  0.670806050,  0.112585783,
14.30,  0.701252997,  0.030390240,  0.002241876,  0.011187881,  0.131804764,  0.806049347,  0.062145889,
14.35,  0.693837583,  0.027424246,  0.007052854,  0.007122837,  0.187389433,  0.719810724,  0.092799842,
14.40,  0.740905762,  0.012758359,  0.009970337,  0.007862505,  0.139310777,  0.795475006,  0.065214217,
14.45,  0.557903051,  0.064275920,  0.004200913,  0.000753809,  0.118169531,  0.815466285,  0.066364169,
14.50,  0.731989861,  0.023698390,  0.001226645,  0.013887508,  0.204852939,  0.697666109,  0.097480953,
14.55,  0.691941023,  0.021373324,  0.013592146,  0.002089160,  0.192151889,  0.710774899,  0.097073197,
14.60,  0.715600729,  0.018532384,  0.010501079,  0.005899001,  0.238085568,  0.643515944,  0.118398488,
14.65,  0.665756524,  0.037001684,  0.004498050,  0.007282097,  0.221598089,  0.666820526,  0.111581385,
14.70,  0.813443482,  0.002553128,  0.002032824,  0.018355483,  0.107158706,  0.850097120,  0.042744160,
14.75,  0.654727817,  0.036766671,  0.007522210,  0.004300704,  0.131008983,  0.802157104,  0.066833913,
14.80,  0.712311208,  0.019010223,  0.010858625,  0.005415494,  0.237628162,  0.643984616,  0.118387222,
14.85,  0.631842852,  0.044723153,  0.005263939,  0.004581369,  0.176134318,  0.732930183,  0.090935469,
14.90,  0.788987398,  0.005129345,  0.005603261,  0.014124675,  0.113090716,  0.838817120,  0.048092186,
14.95,  0.731478393,  0.011042636,  0.014062844,  0.004188959,  0.204681426,  0.694767416,  0.100551188,
15.00,  0.610909045,  0.052865371,  0.002360716,  0.005446266,  0.269968808,  0.590892971,  0.139138222,
15.05,  0.681244493,  0.034889691,  0.002788819,  0.009493941,  0.122827619,  0.817575455,  0.059596896,
15.10,  0.657367587,  0.035538077,  0.008087836,  0.004043739,  0.211652040,  0.680156767,  0.108191192,
15.15,  0.705144286,  0.024954692,  0.006725430,  0.008052800,  0.230219781,  0.655712485,  0.114067733,
15.20,  0.585954130,  0.059651062,  0.001803875,  0.004311625,  0.230894089,  0.647958457,  0.121147454,
15.25,  0.734103143,  0.010396499,  0.014068563,  0.004336888,  0.096027374,  0.858532667,  0.045439959,
15.30,  0.762889147,  0.012897201,  0.004345894,  0.013447115,  0.238814890,  0.647345304,  0.113839805,
15.35,  0.785427213,  0.001071531,  0.010575417,  0.010154823,  0.105150782,  0.849067211,  0.045782030,
15.40,  0.599935174,  0.054319710,  0.003700614,  0.003717400,  0.192676768,  0.707337499,  0.099985719,
15.45,  0.702837944,  0.022892334,  0.009386800,  0.005895806,  0.138957024,  0.792599559,  0.068443418,
15.50,  0.717270851,  0.019445341,  0.009251539,  0.006879831,  0.105226934,  0.844815135,  0.049957931,
15.55,  0.643918097,  0.034871936,  0.012149259,  0.000132397,  0.169413224,  0.742629766,  0.087957025,
15.60,  0.657019794,  0.030519485,  0.013233595,  0.000132520,  0.206523865,  0.687374592,  0.106101513,
15.65,  0.820778728,  0.002432294,  0.000391729,  0.019990845,  0.214031368,  0.689449608,  0.096519053,
15.70,  0.712360203,  0.014742196,  0.015155707,  0.002164768,  0.086967207,  0.869690895,  0.043341875,
15.75,  0.758473217,  0.014070660,  0.004303962,  0.013181910,  0.117252827,  0.829569757,  0.053177416,
15.80,  0.797629535,  0.003610317,  0.005003586,  0.015083190,  0.085234165,  0.880431414,  0.034334421,
15.85,  0.606994927,  0.049409047,  0.006832600,  0.001819950,  0.259119332,  0.606001198,  0.134879470,
15.90,  0.728422642,  0.021804363,  0.004080050,  0.011473823,  0.167868003,  0.751412511,  0.080719471,
15.95,  0.660934091,  0.029669285,  0.013116829,  0.000456031,  0.101408489,  0.845859706,  0.052731812,
16.00,  0.583330154,  0.059098411,  0.003092103,  0.003121767,  0.065101810,  0.898198545,  0.036699653,
16.05,  0.729344666,  0.009877689,  0.015782207,  0.002750339,  0.097509377,  0.854663551,  0.047827065,
16.10,  0.664115787,  0.036239594,  0.005744293,  0.006189391,  0.253785998,  0.618475318,  0.127738714,
16.15,  0.665620923,  0.040300131,  0.001300715,  0.009621214,  0.122263148,  0.816855431,  0.060881436,
16.20,  0.635851383,  0.039581127,  0.009472668,  0.001623729,  0.186156929,  0.717675388,  0.096167684,
16.25,  0.685067058,  0.028111853,  0.008652397,  0.005304134,  0.254521728,  0.617781579,  0.127696693,
16.30,  0.671372652,  0.030012012,  0.010172911,  0.003310043,  0.114655226,  0.827525616,  0.057819128,
16.35,  0.726615489,  0.015679982,  0.010661013,  0.006421559,  0.284637600,  0.573571861,  0.141790569,
16.40,  0.721436799,  0.013165165,  0.014492884,  0.003207199,  0.074668199,  0.888910353,  0.036421478,
16.45,  0.730993748,  0.008924253,  0.016367376,  0.002381528,  0.100111321,  0.851383686,  0.048505008,
16.50,  0.744230330,  0.009316154,  0.012625471,  0.006045887,  0.228459418,  0.658753753,  0.112786829,
16.55,  0.656634033,  0.033359539,  0.010486320,  0.002171613,  0.192051321,  0.709297061,  0.098651648,
16.60,  0.586481631,  0.059042878,  0.002377570,  0.003841281,  0.132757336,  0.797203362,  0.070039332,
16.65,  0.556891322,  0.064664468,  0.004135080,  0.000687614,  0.133038789,  0.794020951,  0.072940290,
16.70,  0.609965086,  0.047400743,  0.008161463,  0.000961613,  0.113637187,  0.826101661,  0.060261130,
16.75,  0.703126192,  0.027283851,  0.004968520,  0.009193556,  0.314621598,  0.528775275,  0.156603158,
16.80,  0.707181990,  0.020819128,  0.010396242,  0.005393542,  0.158002302,  0.762849987,  0.079147696,
16.85,  0.586543202,  0.060893610,  0.000508472,  0.005249184,  0.242736101,  0.631703854,  0.125560045,
16.90,  0.671847463,  0.029319562,  0.010761410,  0.002887281,  0.266909748,  0.598013699,  0.135076582,
16.95,  0.677711248,  0.027613297,  0.010978378,  0.003108554,  0.200138867,  0.698033094,  0.101828039,
17.00,  0.614473045,  0.047937885,  0.006457590,  0.002551071,  0.224051937,  0.659330189,  0.116617858,
17.05,  0.657729983,  0.040971756,  0.002631158,  0.008108199,  0.178897902,  0.730648160,  0.090453923,
17.10,  0.645247698,  0.036719680,  0.010039009,  0.001745764,  0.128549740,  0.804984808,  0.066465437,
17.15,  0.692725956,  0.027247034,  0.007633924,  0.006523093,  0.073470548,  0.891232729,  0.035296738,
17.20,  0.797381878,  0.005097494,  0.003592685,  0.016115118,  0.094806060,  0.864059865,  0.041134059,
17.25,  0.660030425,  0.041451745,  0.001566984,  0.009056913,  0.159856588,  0.759766281,  0.080377162,
17.30,  0.656274498,  0.031263046,  0.012724653,  0.000431424,  0.148459122,  0.774573863,  0.076967001,
17.35,  0.591632664,  0.054071508,  0.006068319,  0.001389809,  0.287512511,  0.563623309,  0.148864150,
17.40,  0.645229876,  0.035259917,  0.011514872,  0.000629019,  0.124189734,  0.812191665,  0.063618600,
17.45,  0.767431259,  0.004138738,  0.012089640,  0.007832579,  0.207188711,  0.692833364,  0.099977911,
17.50,  0.552409530,  0.066802211,  0.003159411,  0.001108032,  0.103992119,  0.839100063,  0.056907833,
17.55,  0.707447410,  0.013888985,  0.017325327,  0.000164345,  0.027229413,  0.959326029,  0.013444543,
17.60,  0.680527985,  0.031931154,  0.006010443,  0.006969972,  0.270029068,  0.594751656,  0.135219276,
17.65,  0.593147099,  0.059047580,  0.000703789,  0.005515244,  0.249358714,  0.622303665,  0.128337622,
17.70,  0.791372776,  0.001141690,  0.009060048,  0.011632064,  0.309629112,  0.539429247,  0.150941670,
17.75,  0.636191726,  0.039019272,  0.009968549,  0.001258757,  0.284562230,  0.569141746,  0.146296024,
17.80,  0.634177327,  0.047534734,  0.001960412,  0.007136166,  0.189328521,  0.714039862,  0.096631587,
17.85,  0.751469970,  0.009154446,  0.011038139,  0.007643210,  0.026480488,  0.963086367,  0.010433137,
17.90,  0.740025282,  0.010362968,  0.012711003,  0.005658109,  0.316992164,  0.525839865,  0.157167971,
17.95,  0.757209301,  0.013814263,  0.004944399,  0.012571542,  0.330267519,  0.507805765,  0.161926687,
18.00,  0.734100580,  0.022811241,  0.001734763,  0.013526851,  0.121345371,  0.821706414,  0.056948185,
18.05,  0.671925068,  0.030377023,  0.009718709,  0.003648536,  0.308862180,  0.534928679,  0.156209111,
18.10,  0.697446406,  0.028571874,  0.005172521,  0.008631513,  0.261955917,  0.608244121,  0.129799962,
18.15,  0.594167173,  0.051826194,  0.007691681,  0.000321936,  0.266372532,  0.595948577,  0.137678862,
18.20,  0.716311574,  0.018721588,  0.010304630,  0.005962918,  0.055592142,  0.918762624,  0.025645256,
18.25,  0.627494872,  0.044425517,  0.006783403,  0.003068898,  0.021238402,  0.966043234,  0.012718379,
18.30,  0.741219163,  0.014386337,  0.008400612,  0.008956935,  0.316946596,  0.526587188,  0.156466186,
18.35,  0.619465053,  0.044087432,  0.009092562,  0.000862453,  0.297963977,  0.548621953,  0.153414071,
18.40,  0.668275893,  0.029096261,  0.011898503,  0.001795564,  0.152027801,  0.769684196,  0.078288019,
18.45,  0.607787192,  0.052782476,  0.003359668,  0.004400242,  0.324847609,  0.509087801,  0.166064620,
18.50,  0.681842446,  0.025724903,  0.011902027,  0.002622977,  0.146746725,  0.779259026,  0.073994219,
18.55,  0.602584243,  0.054031804,  0.003436208,  0.003998805,  0.227249205,  0.656445622,  0.116305172,
18.60,  0.725293398,  0.012602329,  0.014182538,  0.003612772,  0.243743211,  0.635292530,  0.120964289,
18.65,  0.744948864,  0.005532205,  0.016361281,  0.003190316,  0.185577959,  0.723366737,  0.091055274,
18.70,  0.635090709,  0.040398389,  0.008915991,  0.001940884,  0.363265663,  0.451420426,  0.185313940,
18.75,  0.606926322,  0.055156454,  0.001198828,  0.005968627,  0.228418574,  0.654630065,  0.116951346,
18.80,  0.763809443,  0.014296792,  0.002851591,  0.014523840,  0.280339569,  0.583333433,  0.136326969,
18.85,  0.681040287,  0.030004315,  0.007800214,  0.005666407,  0.395757854,  0.404505789,  0.199736357,
18.90,  0.763031721,  0.014851183,  0.002469085,  0.014779020,  0.108509533,  0.840742886,  0.050747573,
18.95,  0.759478509,  0.001530200,  0.016685277,  0.003889620,  0.100917980,  0.849950433,  0.049131572,
19.00,  0.639116704,  0.044296533,  0.004058942,  0.005799599,  0.130327120,  0.803912163,  0.065760732,
19.05,  0.578526258,  0.059787303,  0.003664106,  0.002347581,  0.376217663,  0.430850267,  0.192932069,
19.10,  0.591366351,  0.056888379,  0.003363959,  0.003366981,  0.066996813,  0.896167576,  0.036835611,
19.15,  0.723976731,  0.022388399,  0.004699200,  0.010662809,  0.322976857,  0.516833544,  0.160189629,
19.20,  0.629271090,  0.049999945,  0.000777811,  0.007674441,  0.212360352,  0.679592371,  0.108047247,
19.25,  0.616772532,  0.052926600,  0.001025140,  0.006670773,  0.305292100,  0.540844560,  0.153863311,
19.30,  0.616772532,  0.052926600,  0.001025140,  0.006670773,  0.305292100,  0.540844560,  0.153863311,
19.35,  0.585252821,  0.056075647,  0.005713806,  0.001215953,  0.122264110,  0.812377095,  0.065358818,
19.40,  0.692379653,  0.024560563,  0.010469109,  0.004328458,  0.101609349,  0.847952902,  0.050437748,
19.45,  0.735629797,  0.011300519,  0.012886256,  0.005241502,  0.371529579,  0.442429751,  0.186040670,
19.50,  0.692917943,  0.024151146,  0.010774881,  0.004109576,  0.123248830,  0.815623760,  0.061127424,
19.55,  0.633065999,  0.049031563,  0.000802159,  0.007889837,  0.149906129,  0.774167955,  0.075925887,
19.60,  0.574742436,  0.063080668,  0.001374975,  0.003784232,  0.148704216,  0.774831355,  0.076464415,
19.65,  0.516435742,  0.078251049,  0.000788152,  0.000575017,  0.325059086,  0.507439494,  0.167501450,
19.70,  0.533551931,  0.074311420,  0.000406727,  0.001962353,  0.342934698,  0.480547130,  0.176518142,
19.75,  0.693292737,  0.022411108,  0.012378633,  0.002962127,  0.155473262,  0.766110063,  0.078416705,
19.80,  0.619924605,  0.052569546,  0.000531286,  0.007285334,  0.148478061,  0.774832845,  0.076689124,
19.85,  0.691357553,  0.021407604,  0.013847128,  0.001753911,  0.179279834,  0.730047703,  0.090672493,
19.90,  0.663915038,  0.038511515,  0.003682941,  0.007602572,  0.239249468,  0.641971469,  0.118779063,
19.95,  0.520983577,  0.076073349,  0.001844108,  0.000055879,  0.317512095,  0.519014537,  0.163473368,
20.00,  0.628557563,  0.045759290,  0.005248681,  0.004237816,  0.184951141,  0.720882893,  0.094165981,
20.05,  0.793222070,  0.003329217,  0.006494150,  0.013609104,  0.359128177,  0.464643240,  0.176228583,
20.10,  0.545972228,  0.068722248,  0.002889521,  0.000877503,  0.009620428,  0.981576681,  0.008802891,
20.15 , 0.623136342 , 0.045090564 , 0.007242844 , 0.002425767 , 0.137593195 , 0.791602910 , 0.070803881
};

class HelmholtzFD_Op : public E_F0mps {
 public:
  Expression expTh;
  Expression expomega, expmu;
  static const int n_name_param = 2;
  static basicAC_F0::name_and_type name_param[];
  Expression nargs[n_name_param];
  HelmholtzFD_Op(const basicAC_F0 &args, Expression Th) : expTh(Th) {
    args.SetNameParam(n_name_param, name_param, nargs);
    expTh = to< const Mesh3 * >(args[0]);
    expomega = to< Complex >(args[1]);
    expmu = to< double >(args[2]);
  }

  long arg(int i, Stack stack, long a) const { return nargs[i] ? GetAny< long >((*nargs[i])(stack)) : a;}
  string* arg(int i, Stack stack, string* a) const { return nargs[i] ? GetAny< string* >((*nargs[i])(stack)) : a;}
  KN_<long>  arg(int i,Stack stack, KN_<long> a ) const { return nargs[i] ? GetAny<KN_<long> >((*nargs[i])(stack)): a;}

  AnyType operator( )(Stack stack) const;
};

basicAC_F0::name_and_type HelmholtzFD_Op::name_param[] = {
  {"npml", &typeid(KN_<long>)},
  {"pmlsides", &typeid(KN_<long>)}
};

class  HelmholtzFD : public OneOperator {
  public:
    HelmholtzFD() : OneOperator(atype< newpMatrice_Creuse< Complex > >( ), atype< const Mesh3 * >( ), atype< Complex >( ), atype< double >( )) {};
    E_F0 *code(const basicAC_F0 &args) const { return new HelmholtzFD_Op(args, t[0]->CastTo(args[0])); }
};

long kkindex(long i1, long i2, long i3, long n1, long n2, long n3) {
  return i2*n3*n1+i1*n3+i3;
}

void subdamp(long n,int npmll, int npmlu, int apml, double h, double omega, std::vector<std::complex<double>>& damp, std::vector<std::complex<double>>& dampb, int sides) {
  double half_pi = 1.570796327;
  std::complex<double> ci(0,1);
  
  for (int i=0; i<=n+1; i++) {
    damp[i] = 1.;
    dampb[i] = 1.;
  }

  double xpmll = npmll*h;
  double xpmlu = npmlu*h;
  double xmax = (n-1)*h;
  double x, xb, eps, epsb;

  if (sides & 1)
  for (int i=1; i<=npmll; i++) {
    x = (i-1)*h;
    xb = (i-1)*h+0.5*h;
    eps  = apml*(1.-cos((xpmll-x)*half_pi/xpmll));
    epsb = apml*(1.-cos((xpmll-xb)*half_pi/xpmll));
    damp[i] = 1./(1.+ci*eps/omega);
    dampb[i] = 1./(1.+ci*epsb/omega);
  }

  if (sides & 2)
  for (int i=1; i<=npmlu; i++) {
    x = (i-1)*h;
    xb = (i-1)*h+0.5*h;
    eps  = apml*(1.-cos((xpmlu-x)*half_pi/xpmlu));
    epsb = apml*(1.-cos((xpmlu-xb)*half_pi/xpmlu));
    damp[n-i+1] = 1./(1.+ci*eps/omega);
  }

  damp[0] = damp[1];
  damp[n+1] = damp[n];

  if (sides & 2)
  for (int i=1; i<=npmlu+1; i++) {
    xb = xmax+0.5*h-(i-1)*h;
    epsb = apml*(1.-cos((xb-(xmax-xpmlu))*half_pi/xpmlu));
    dampb[n-i+1] = 1./(1.+ci*epsb/omega);
  }

  dampb[0] = dampb[1];
  dampb[n+1] = dampb[n];
}

template<class FESpaceT>
MatriceMorse<double> *  buildInterpolationMatrixT1(const FESpaceT & Uh,const KN_<double> & xx,const KN_<double> & yy ,const KN_<double> & zz)
{
  typedef typename FESpaceT::Mesh MeshT;
  typedef typename FESpaceT::FElement FElementT;
  typedef typename MeshT::Element ElementT;
  typedef typename FESpaceT::Rd RdT;
  typedef typename ElementT::RdHat RdHatT;

  int op=op_id; //  value of the function
  int icomp=0;
  bool inside=false;

  int n=Uh.NbOfDF;
  int mm=xx.N();
  int nbxx= mm;
  const MeshT & ThU = Uh.Th; // line
  FElementT Uh0 = Uh[0];
  int nbdfUK= Uh0.NbDoF();
  int NUh= Uh0.N;

  const int sfb1=Uh0.N*last_operatortype*Uh0.NbDoF();
  KN<double> kv(sfb1);
  R * v = kv;
  const R eps = 1e-10;

  What_d whatd= 1 << op;
  MatriceMorse<double> * m = new MatriceMorse<double>(n,mm,0,0);
  RdHatT Phat;
  bool outside;

  for(int ii=0;ii<nbxx;ii++){
    if(verbosity>9) cout << " Find ThU " <<ii << ":" <<  RdT(xx[ii],yy[ii],zz[ii]) << endl;
    const ElementT *ts=ThU.Find(RdT(xx[ii],yy[ii],zz[ii]),Phat,outside);
    if(outside && !inside) continue;
    int it = ThU(ts);
    FElementT KU(Uh[it]);
    KNMK_<double> fb(v,nbdfUK,NUh,last_operatortype);
    Uh0.tfe->FB(whatd,ThU,ThU[it],Phat,fb);
    KN_<double> Fwi(fb('.',icomp,op));
    for (int idfu=0;idfu<nbdfUK;idfu++){
      int  j = ii;
      int  i = KU(idfu);
      R c = Fwi(idfu);
      if(Abs(c)>eps)
        (*m)(i,j) += c;
    }
  }
  return m;
}

template<class T> bool cmp(const std::pair<unsigned int, T>& lhs, const std::pair<unsigned int, T>& rhs) { return lhs.first < rhs.first; }

AnyType HelmholtzFD_Op::operator( )(Stack stack) const {

  typedef typename Mesh3::Element Element;
  typedef typename Mesh3::RdHat RdHat;
  static const int nvedgeTet[6][2] = {{0, 1}, {0, 2}, {0, 3}, {1, 2}, {1, 3}, {2, 3}};
  static const int nvedgeTria[3][2] = {{1, 2}, {2, 0}, {0, 1}};
  static const int nvedgeSeg[1][2] = {{0, 1}};

  const int d = RdHat::d;

  MatriceMorse< Complex > *amorse = 0;
  typedef const Mesh3 *pmesh3;
  const Mesh3 *pTh = GetAny< pmesh3 >((*expTh)(stack));
  ffassert(pTh);
  const Mesh3 &Th(*pTh);

  double lx = 1e+30, ly=1e+30, lz=1e+30, ux=-1e+30, uy=-1e+30, uz=-1e+30, h = 1e+30;

  for (int i=0; i<Th.nbe; i++) {
    for (int j=0; j<3; j++) {
      const R3& p = Th.be(i)[j];
      lx = min(p.x,lx); ly = min(p.y,ly); lz = min(p.z,lz);
      ux = max(p.x,ux); uy = max(p.y,uy); uz = max(p.z,uz);
    }
    R3 p1 = Th.be(i)[1] - Th.be(i)[0];
    R3 p2 = Th.be(i)[2] - Th.be(i)[0];
    h = min(h,min(p1.norme(),p2.norme()));
  }

  double dx = ux-lx, dy = uy-ly, dz = uz-lz;

  //if (mpirank == 0) std::cout << "h = " << h << std::endl;

  long n1 = dx/h + 1, n2 = dy/h + 1, n3 = dz/h + 1;

  std::complex<double> omega = GetAny<std::complex<double>>((*expomega)(stack));

  //if (mpirank == 0) cout << n1 << " " << n2 << " " << n3 << " " << Th.nv << endl;

  KN<double> mu(n1*n2*n3);
  KN<double> xx(n1*n2*n3), yy(n1*n2*n3), zz(n1*n2*n3);
  KN<long> boundarynodesFD(n1*n2*n3,0L);

  int cpt = 0;
  for (long i2 = 0; i2 < n2; i2++)
  for (long i1 = 0; i1 < n1; i1++)
  for (long i3 = 0; i3 < n3; i3++) {
    xx[cpt] = lx + i1*h; yy[cpt] = ly + i2*h; zz[cpt] = lz + i3*h;
    MeshPoint* mp(Fem2D::MeshPointStack(stack));
    mp->set(xx[cpt], yy[cpt], zz[cpt]);
    mu[cpt] = GetAny<double>( (*expmu)(stack) );
    if ((i1 == 0) || (i1 == n1-1) || (i2 == 0) || (i2 == n2-1) || (i3 == 0) || (i3 == n3-1))
      boundarynodesFD[kkindex(i1,i2,i3,n1,n2,n3)] = 1;
    cpt++;
  }

  {
    std::vector<std::vector<std::complex<double>>> dd(3), db(3);
    
    dd[0].resize(n1+2); dd[1].resize(n2+2); dd[2].resize(n3+2);
    db[0].resize(n1+2); db[1].resize(n2+2); db[2].resize(n3+2);

    KN<long> defnpml(6,8);
    KN<long> npml(arg(0,stack,defnpml));

    KN<long> defsides(6,1);
    KN<long> pmlsides(arg(1,stack,defsides));

    subdamp(n1,npml[0],npml[1],90,h,omega.real(),dd[0],db[0],pmlsides[0]+2*pmlsides[1]);
    subdamp(n2,npml[2],npml[3],90,h,omega.real(),dd[1],db[1],pmlsides[2]+2*pmlsides[3]);
    subdamp(n3,npml[4],npml[5],90,h,omega.real(),dd[2],db[2],pmlsides[4]+2*pmlsides[5]);

    MatriceMorse< Complex > *pAij = new MatriceMorse< Complex >(n1*n2*n3, n1*n2*n3, 0, 0), &Aij = *pAij;
    
    std::complex<double> omega2 = omega*omega;

    double c, d, e, f, w1 ,w2, w3; // weights of the mixed grid stencil
    double w2u, w3u;

    double h2 = 1./(h*h);

    long k, l, l1, l2, l3, ll[3], li, lj, lk, ii, ij, ik;
    long ind6[6][3] = {{1,0,0},{0,1,0},{0,0,1},
                      {-1,0,0},{0,-1,0},{0,0,-1}};
    long ind12[12][3] = {{1,1,0},{0,1,1},{1,0,1},
                        {-1,-1,0},{0,-1,-1},{-1,0,-1},
                        {-1,1,0},{1,-1,0},
                        {0,-1,1},{0,1,-1},
                        {1,0,-1},{-1,0,1}};
    long ik12[12] = {2,0,1,2,0,1,2,2,0,0,1,1};
    long ind8[8][3] = {{1,1,1},{-1,-1,-1},
                      {-1,1,1},{1,-1,-1},
                      {1,-1,1},{-1,1,-1},
                      {1,1,-1},{-1,-1,1}};

    double lambda, ppwl, pi = 3.14159265358979323846;
    for (long i3 = 0; i3 < n3; i3++)
    for (long i2 = 0; i2 < n2; i2++)
    for (long i1 = 0; i1 < n1; i1++) {
      l1 = i1;
      l2 = i2;
      l3 = i3;
      k = kkindex(i1,i2,i3,n1,n2,n3);

      lambda = 2 * pi / omega.real() * sqrt(mu[k]);
      ppwl = lambda/h;

      int ntab = max(0.,min(343.,(ppwl-3)/(20.15-3)*343 + 0.5));

      c=wtab[8*ntab+1];
      d=wtab[8*ntab+2];
      e=wtab[8*ntab+3];
      f=wtab[8*ntab+4];
      w1=wtab[8*ntab+5];
      w2=wtab[8*ntab+6];
      w3=wtab[8*ntab+7];

      w2u=w2/3.;
      w3u=w3/4.;

      /* Node 000 */
      l = k;

      Aij(k, l) = c*omega2/mu[k]
      -w1*h2*(                                         				
               dd[1][l2+1]*(db[1][l2+1]+db[1][l2])               				
              +dd[2][l3+1]*(db[2][l3+1]+db[2][l3])               			
              +dd[0][l1+1]*(db[0][l1+1]+db[0][l1]) // (6)
             )  //R1
      -w2u*h2*2*(
               dd[0][l1+1]*(db[0][l1+1]+db[0][l1])
              +dd[1][l2+1]*(db[1][l2+1]+db[1][l2])
              +dd[2][l3+1]*(db[2][l3+1]+db[2][l3]) // (0.75*8+6) 
                )//R2-R4
      -w3u*h2*0.5*4*(                                            				
               dd[1][l2+1]*(db[1][l2+1]+db[1][l2])               				
              +dd[2][l3+1]*(db[2][l3+1]+db[2][l3])               			
              +dd[0][l1+1]*(db[0][l1+1]+db[0][l1]) // (0.5*24) 
                    ); //B1-B4

      /* 6 nodes */
      for (int q=0; q < 6; q++) {
        l1 = i1+ind6[q][0];
        l2 = i2+ind6[q][1];
        l3 = i3+ind6[q][2];

        ii = q%3;
        ij = (ii+1)%3;
        ik = (ij+1)%3;

        ll[0] = i1; ll[1] = i2; ll[2] = i3;
        li = ll[ii]; lj = ll[ij]; lk = ll[ik];

        if (l1 >= 0 && l1 < n1 && l2 >= 0 && l2 < n2 && l3 >= 0 && l3 < n3) {
          l = kkindex(l1,l2,l3,n1,n2,n3);
          Aij(k, l) = d*omega2/mu[l]

          +w1*h2*dd[ii][li+1]*db[ii][li+1*(q<3)] //R1

          +w2u*0.25*h2*(
             dd[ii][li+1]*db[ii][li+1*(q<3)]*4.
            -dd[ij][lj+1]*(db[ij][lj+1]+db[ij][lj])
            -dd[ik][lk+1]*(db[ik][lk+1]+db[ik][lk])
          )
          +w2u*h2*dd[ii][li+1]*db[ii][li+1*(q<3)] //R2-R4

          +w3u*h2*0.5*4*dd[ii][li+1]*db[ii][li+1*(q<3)]; //B2-B4
        }
      }

      /* 12 nodes */
      for (int q=0; q < 12; q++) {
        l1 = i1+ind12[q][0];
        l2 = i2+ind12[q][1];
        l3 = i3+ind12[q][2];
        
        ik = ik12[q];
        ii = (ik+1)%3;
        ij = (ii+1)%3;
        
        ll[0] = i1; ll[1] = i2; ll[2] = i3;
        li = ll[ii]; lj = ll[ij]; lk = ll[ik];
        
        long si = ind12[q][ii] == 1;
        long sj = ind12[q][ij] == 1;
        
        if (l1 >= 0 && l1 < n1 && l2 >= 0 && l2 < n2 && l3 >= 0 && l3 < n3) {
          l = kkindex(l1,l2,l3,n1,n2,n3);
          Aij(k, l) = e*omega2/mu[l]
            +w2u*h2*0.25*(dd[ii][li+1]*db[ii][li+si]+dd[ij][lj+1]*db[ij][lj+sj]) //R2-R4 0.25*2
            -w3u*h2*0.5*dd[ik][lk+1]*(db[ik][lk]+db[ik][lk+1]); //B1-B4 0.5*2
        }
      }

      /* 8 nodes */
      for (int q=0; q < 8; q++) {
        l1 = i1+ind8[q][0];
        l2 = i2+ind8[q][1];
        l3 = i3+ind8[q][2];
        if (l1 >= 0 && l1 < n1 && l2 >= 0 && l2 < n2 && l3 >= 0 && l3 < n3) {
          l = kkindex(l1,l2,l3,n1,n2,n3);
          Aij(k, l) = f*omega2/mu[l]
          +w3u*h2*0.5*(dd[0][i1+1]*db[0][i1+(ind8[q][0] > 0)]
                      +dd[1][i2+1]*db[1][i2+(ind8[q][1] > 0)]
                      +dd[2][i3+1]*db[2][i3+(ind8[q][2] > 0)]); //B1-B4
        }
      }    
    }
    amorse = pAij;
  }

  FESpace3 Uh(Th);

  MatriceMorse<double>* R = buildInterpolationMatrixT1<FESpace3>(Uh, xx, yy, zz);

  //if (mpirank == 0) std::cout << n1*n2*n3 << " " << Th.nv << " " << R->n << " " << R->m << " " << R->nnz << " " << amorse->n << " " << amorse->m <<  endl;

  std::vector<char> boundarynodesTh(Th.nv,0);

  R->COO();
  amorse->CSR();
  unsigned int m = R->nnz;
  KN<int> lg(m+1,0);
  std::vector<signed int> tmpVec;
  tmpVec.resize(amorse->m);
  for(long i = 0; i < m; ++i)
    tmpVec[R->j[i]] = i + 1;

  std::vector<std::pair<int, std::complex<double>> > tmp;
  tmp.reserve(amorse->nnz);

  lg[0] = 0;
  for(long i = 0; i < m; ++i) {
    for(long j = amorse->p[R->j[i]]; j < amorse->p[R->j[i] + 1]; ++j) {
      long col = tmpVec[amorse->j[j]];
      if(col != 0)
        tmp.push_back(std::make_pair(col - 1, amorse->aij[j]));
    }
    std::sort(tmp.begin() + lg[i], tmp.end(),cmp<std::complex<double>>);
    lg[i + 1] = tmp.size();

    boundarynodesTh[i] = boundarynodesFD[R->j[i]];
  }

  delete R;

  amorse->clear();
  amorse->resize(m,m);
  MatriceMorse<std::complex<double>> &MA = *amorse;
  MA.half = 0;
  for(int i=0; i<m; ++i)
  for(int k= lg[i]; k < lg[i+1]; ++k) {
    int j= tmp[k].first;
    std::complex<double> aij = tmp[k].second;
    MA(i,j) = aij;
  }

  MA.SetBC(&boundarynodesTh[0], -1);

  return SetAny<newpMatrice_Creuse<std::complex<double>>>(newpMatrice_Creuse<std::complex<double>>(stack, &MA));
}

static void Load_Init( ) {
  Global.Add("HelmholtzFD", "(", new HelmholtzFD);
}

LOADFUNC(Load_Init)
