#!/bin/sh
#
# $Id: Compare.sh.in,v 1.2 2000/07/22 19:53:36 moniot Rel $
#
# Bourne shell script to compare File in directory ./Vary with
# original in directory ./Okay and print a message if they differ.
# If no differences it echoes a dot to show progress.
# If differences, touches file CHECK_FAILED
#
# Usage: Compare.sh Okay Vary File

OKAY=$1
VARY=$2
FILE=$3

	if [ ! -d ${OKAY} ]
	then
	    echo "Creating directory ${OKAY}"
	    mkdir ${OKAY};
	fi
	if [ ! -f ${OKAY}/${FILE} ]
	then
	    echo "${FILE} is new"
	    cp ${FILE} ${OKAY}/${FILE}
	fi
	if cmp ${OKAY}/${FILE} ${FILE} > /dev/null
	then
	    rm -f -f ${FILE}
	    echo '.' | gawk '{printf("%s",$1);}'
	else
	    touch CHECK_FAILED
	    echo ""
	    echo "--------------------------------------------------"
	    echo "====> Differences found in ${FILE} test <===="
	    echo "Master: ${OKAY}/${FILE}"
	    echo "Test:   ${VARY}/${FILE}"
	    if [ ! -d ${VARY} ]
	    then
		echo "Creating directory ${VARY}"
		mkdir ${VARY}
	    fi
	    mv ${FILE} ${VARY}/${FILE}
#  To show diffs uncomment next line
#	    diff ${OKAY}/${FILE} ${VARY}/${FILE}
	fi
	exit 0
