#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include <ghmm/randvar.h>
#include <ghmm/matrixop.h>

int main()
{
  int i, j, dim = 20;
  double erg, det;
  double *cov = malloc(dim*dim*sizeof(double));
  double *sigmainv = malloc(dim*dim*sizeof(double));
  double *sigmacd = malloc(dim*dim*sizeof(double));
  double *x   = malloc(dim*sizeof(double));
  double *xrand   = malloc(dim*sizeof(double));


  for (i=0; i<dim; ++i) {
    x[i] = 0.0;
    for (j=0; j<dim; ++j) {
      if (i==j)
        cov[i*dim+j] = 1.0 /*+ (0.2*(i%2)) + (0.1*(j%3))*/;
      else
        cov[i*dim+j] = 0.2 /*- (0.02*(i%2)) + (0.01*(j%7))*/;
    }
  }

  ighmm_invert_det(sigmainv, &det, dim, cov);

  for (i=0; i<100; ++i) {
    erg = ighmm_rand_multivariate_normal_density(dim, x, x, sigmainv, det);
  }
  printf("%6.20f\n", erg);

  /* test the generation of random multivariate vectors */

  if (!ighmm_cholesky_decomposition (sigmacd, dim, cov))
    printf("cholesky decomposition was successful\n");

  ighmm_rand_multivariate_normal (dim, xrand, x, sigmacd, 1);

  printf("RNG seed set\n");

  for (i=0; i<10; ++i) {
    ighmm_rand_multivariate_normal (dim, xrand, x, sigmacd, 0);
    for (j=0; j<dim; j++) {
      printf("%1.3f\t", xrand[j]);
    }
    printf("\n");
  }


  return 0;
}
