// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an asset model from specified property and hierarchy definitions. You
// create assets from asset models. With asset models, you can easily create assets
// of the same type that have standardized definitions. Each asset created from a
// model inherits the asset model's property and hierarchy definitions. For more
// information, see Defining asset models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html)
// in the IoT SiteWise User Guide. You can create two types of asset models,
// ASSET_MODEL or COMPONENT_MODEL .
//   - ASSET_MODEL – (default) An asset model that you can use to create assets.
//     Can't be included as a component in another asset model.
//   - COMPONENT_MODEL – A reusable component that you can include in the
//     composite models of other asset models. You can't create assets directly from
//     this type of asset model.
func (c *Client) CreateAssetModel(ctx context.Context, params *CreateAssetModelInput, optFns ...func(*Options)) (*CreateAssetModelOutput, error) {
	if params == nil {
		params = &CreateAssetModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAssetModel", params, optFns, c.addOperationCreateAssetModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAssetModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAssetModelInput struct {

	// A unique, friendly name for the asset model.
	//
	// This member is required.
	AssetModelName *string

	// The composite models that are part of this asset model. It groups properties
	// (such as attributes, measurements, transforms, and metrics) and child composite
	// models that model parts of your industrial equipment. Each composite model has a
	// type that defines the properties that the composite model supports. Use
	// composite models to define alarms on this asset model. When creating custom
	// composite models, you need to use CreateAssetModelCompositeModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html)
	// . For more information, see .
	AssetModelCompositeModels []types.AssetModelCompositeModelDefinition

	// A description for the asset model.
	AssetModelDescription *string

	// An external ID to assign to the asset model. The external ID must be unique
	// within your Amazon Web Services account. For more information, see Using
	// external IDs (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids)
	// in the IoT SiteWise User Guide.
	AssetModelExternalId *string

	// The hierarchy definitions of the asset model. Each hierarchy specifies an asset
	// model whose assets can be children of any other assets created from this asset
	// model. For more information, see Asset hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide. You can specify up to 10 hierarchies per asset
	// model. For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	AssetModelHierarchies []types.AssetModelHierarchyDefinition

	// The ID to assign to the asset model, if desired. IoT SiteWise automatically
	// generates a unique ID for you, so this parameter is never required. However, if
	// you prefer to supply your own ID instead, you can specify it here in UUID
	// format. If you specify your own ID, it must be globally unique.
	AssetModelId *string

	// The property definitions of the asset model. For more information, see Asset
	// properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the IoT SiteWise User Guide. You can specify up to 200 properties per asset
	// model. For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the IoT SiteWise User Guide.
	AssetModelProperties []types.AssetModelPropertyDefinition

	// The type of asset model.
	//   - ASSET_MODEL – (default) An asset model that you can use to create assets.
	//   Can't be included as a component in another asset model.
	//   - COMPONENT_MODEL – A reusable component that you can include in the
	//   composite models of other asset models. You can't create assets directly from
	//   this type of asset model.
	AssetModelType types.AssetModelType

	// A unique case-sensitive identifier that you can provide to ensure the
	// idempotency of the request. Don't reuse this client token if a new idempotent
	// request is required.
	ClientToken *string

	// A list of key-value pairs that contain metadata for the asset model. For more
	// information, see Tagging your IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the IoT SiteWise User Guide.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateAssetModelOutput struct {

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// This member is required.
	AssetModelArn *string

	// The ID of the asset model, in UUID format. You can use this ID when you call
	// other IoT SiteWise API operations.
	//
	// This member is required.
	AssetModelId *string

	// The status of the asset model, which contains a state ( CREATING after
	// successfully calling this operation) and any error message.
	//
	// This member is required.
	AssetModelStatus *types.AssetModelStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAssetModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAssetModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAssetModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAssetModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateAssetModelMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAssetModelMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAssetModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAssetModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateAssetModelMiddleware struct {
}

func (*endpointPrefix_opCreateAssetModelMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateAssetModelMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateAssetModelMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateAssetModelMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpCreateAssetModel struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAssetModel) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAssetModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAssetModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAssetModelInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAssetModelMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAssetModel{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAssetModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAssetModel",
	}
}
