/**
 * JNA-InChI - Library for calling InChI from Java
 * Copyright © 2018 Daniel Lowe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.github.dan2097.jnainchi.inchi;
import java.nio.ByteBuffer;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
/**
 * JNA Wrapper for library <b>inchi</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class InchiLibrary implements Library {
  public static final String JNA_LIBRARY_NAME = "jnainchi";
  public static final NativeLibrary JNA_NATIVE_LIB = NativeLibrary.getInstance(InchiLibrary.JNA_LIBRARY_NAME);
  static {
    Native.register(InchiLibrary.class, InchiLibrary.JNA_NATIVE_LIB);
  }
  /** enum values */
  public static interface tagINCHIRadical {
    public static final int INCHI_RADICAL_NONE = 0;
    public static final int INCHI_RADICAL_SINGLET = 1;
    public static final int INCHI_RADICAL_DOUBLET = 2;
    public static final int INCHI_RADICAL_TRIPLET = 3;
  };
  /** enum values */
  public static interface tagINCHIBondType {
    public static final int INCHI_BOND_TYPE_NONE = 0;
    public static final int INCHI_BOND_TYPE_SINGLE = 1;
    public static final int INCHI_BOND_TYPE_DOUBLE = 2;
    public static final int INCHI_BOND_TYPE_TRIPLE = 3;
    /**
     * avoid by all means<br>
     */
    public static final int INCHI_BOND_TYPE_ALTERN = 4;
  };
  /** enum values */
  public static interface tagINCHIBondStereo2D {
    public static final int INCHI_BOND_STEREO_NONE = 0;
    public static final int INCHI_BOND_STEREO_SINGLE_1UP = 1;
    public static final int INCHI_BOND_STEREO_SINGLE_1EITHER = 4;
    public static final int INCHI_BOND_STEREO_SINGLE_1DOWN = 6;
    public static final int INCHI_BOND_STEREO_SINGLE_2UP = -1;
    public static final int INCHI_BOND_STEREO_SINGLE_2EITHER = -4;
    public static final int INCHI_BOND_STEREO_SINGLE_2DOWN = -6;
    /**
     * unknown stereobond geometry<br>
     */
    public static final int INCHI_BOND_STEREO_DOUBLE_EITHER = 3;
  };
  /** enum values */
  public static interface tagINCHIStereoType0D {
    public static final int INCHI_StereoType_None = 0;
    public static final int INCHI_StereoType_DoubleBond = 1;
    public static final int INCHI_StereoType_Tetrahedral = 2;
    public static final int INCHI_StereoType_Allene = 3;
  };
  /** enum values */
  public static interface tagINCHIStereoParity0D {
    public static final int INCHI_PARITY_NONE = 0;
    /**
     * 'o'<br>
     */
    public static final int INCHI_PARITY_ODD = 1;
    /**
     * 'e'<br>
     */
    public static final int INCHI_PARITY_EVEN = 2;
    /**
     * 'u'<br>
     */
    public static final int INCHI_PARITY_UNKNOWN = 3;
    /**
     * '?' -- should not be used; however, see Note above<br>
     */
    public static final int INCHI_PARITY_UNDEFINED = 4;
  };
  /** enum values */
  public static interface tagRetValGetINCHI {
    public static final int inchi_Ret_BREAK = -100;
    /**
     * not used in InChI library<br>
     */
    public static final int inchi_Ret_SKIP = -2;
    /**
     * no structural data has been provided<br>
     */
    public static final int inchi_Ret_EOF = -1;
    /**
     * Success; no errors or warnings<br>
     */
    public static final int inchi_Ret_OKAY = 0;
    /**
     * Success; warning(s) issued<br>
     */
    public static final int inchi_Ret_WARNING = 1;
    /**
     * Error: no InChI has been created<br>
     */
    public static final int inchi_Ret_ERROR = 2;
    /**
     * Severe error: no InChI has been created (typically, memory allocation failure)<br>
     */
    public static final int inchi_Ret_FATAL = 3;
    /**
     * Unknown program error<br>
     */
    public static final int inchi_Ret_UNKNOWN = 4;
    /**
     * Previuos call to InChI has not returned yet<br>
     */
    public static final int inchi_Ret_BUSY = 5;
  };
  /** enum values */
  public static interface tagRetValMOL2INCHI {
    /**
     * Success; no errors or warnings<br>
     */
    public static final int mol2inchi_Ret_OKAY = 0;
    /**
     * Success; warning(s) issued<br>
     */
    public static final int mol2inchi_Ret_WARNING = 1;
    /**
     * generic Error: no InChI has been created<br>
     */
    public static final int mol2inchi_Ret_EOF = -1;
    /**
     * generic Error: no InChI has been created<br>
     */
    public static final int mol2inchi_Ret_ERROR = 2;
    /**
     * get structure Error: no InChI has been created<br>
     */
    public static final int mol2inchi_Ret_ERROR_get = 4;
    /**
     * compute InChI Error: no InChI has been created<br>
     */
    public static final int mol2inchi_Ret_ERROR_comp = 5;
  };
  /** enum values */
  public static interface tagRetValCheckINCHI {
    public static final int INCHI_VALID_STANDARD = 0;
    public static final int INCHI_VALID_NON_STANDARD = 1;
    public static final int INCHI_VALID_BETA = 2;
    public static final int INCHI_INVALID_PREFIX = 3;
    public static final int INCHI_INVALID_VERSION = 4;
    public static final int INCHI_INVALID_LAYOUT = 5;
    public static final int INCHI_FAIL_I2I = 6;
  };
  /** enum values */
  public static interface tagRetValGetINCHIKey {
    public static final int INCHIKEY_VALID_STANDARD = 0;
    public static final int INCHIKEY_VALID_NON_STANDARD = -1;
    public static final int INCHIKEY_INVALID_LENGTH = 1;
    public static final int INCHIKEY_INVALID_LAYOUT = 2;
    public static final int INCHIKEY_INVALID_VERSION = 3;
  };
  public static final int FIND_RING_SYSTEMS = (int)1;
  public static final int FIND_RINS_SYSTEMS_DISTANCES = (int)0;
  public static final int FIX_DOCANON_RETCODE_RESET_BUG = (int)1;
  public static final int MAXVAL = (int)20;
  public static final int ATOM_EL_LEN = (int)6;
  public static final int NUM_H_ISOTOPES = (int)3;
  public static final int ISOTOPIC_SHIFT_FLAG = (int)10000;
  public static final int ISOTOPIC_SHIFT_MAX = (int)100;
  public static final int NO_ATOM = (int)(-1);
  public static final String INCHI_STRING_PREFIX = (String)"InChI=";
  public static final int LEN_INCHI_STRING_PREFIX = (int)6;
  public static final int STR_ERR_LEN = (int)256;
  public static final int INCHIKEY_OK = (int)0;
  public static final int INCHIKEY_UNKNOWN_ERROR = (int)1;
  public static final int INCHIKEY_EMPTY_INPUT = (int)2;
  public static final int INCHIKEY_INVALID_INCHI_PREFIX = (int)3;
  public static final int INCHIKEY_NOT_ENOUGH_MEMORY = (int)4;
  public static final int INCHIKEY_INVALID_INCHI = (int)20;
  public static final int INCHIKEY_INVALID_STD_INCHI = (int)21;
  public static final int MAX_NUM_STEREO_ATOM_NEIGH = (int)4;
  public static final int MAX_NUM_STEREO_BONDS = (int)3;
  public static final int INCHI_NUM = (int)2;
  /**
   * Original signature : <code>void FreeInChIExtInput(inchi_Input_Polymer*, inchi_Input_V3000*)</code><br>
   */
  //public static native void FreeInChIExtInput(inchi_Input_Polymer polymer, inchi_Input_V3000 v3000);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * GetINCHI / GetStdINCHI<br>
   * inchi_Input is created by the user; strings in inchi_Output are allocated and deallocated by InChI<br>
   * inchi_Output does not need to be initilized out to zeroes; see FreeNCHI()/FreeSTDINCHI() on how to deallocate it<br>
   * Valid options for GetINCHI:<br>
   * (use - instead of / for O.S. other than MS Windows)<br>
   * Structure perception (compatible with stdInChI)<br>
   * /NEWPSOFF   /DoNotAddH   /SNon<br>
   * Stereo interpretation (lead to generation of non-standard InChI)<br>
   * /SRel /SRac /SUCF /ChiralFlagON /ChiralFlagOFF<br>
   * InChI creation options (lead to generation of non-standard InChI)<br>
   * /SUU /SLUUD   /FixedH  /RecMet  /KET /15T<br>
   * GetINCHI produces standard InChI if no InChI creation/stereo modification options<br>
   * are specified. Inveresely, if any of SUU/SLUUD/RecMet/FixedH/Ket/15T/SRel/SRac/SUCF<br>
   * options are specified, generated InChI will be non-standard one.<br>
   * GetStdINCHI produces standard InChI only.<br>
   * The valid structure perception options are:<br>
   * /NEWPSOFF   /DoNotAddH   /SNon<br>
   * Other options are:<br>
   * /AuxNone    Omit auxiliary information (default: Include)<br>
   * /Wnumber    Set time-out per structure in seconds; W0 means unlimited<br>
   * In InChI library the default value is unlimited<br>
   * /WMnumber   Set time-out per structure in milliseconds; WM0 means unlimited<br>
   * In InChI library the default value is unlimited<br>
   * /OutputSDF  Output SDfile instead of InChI<br>
   * /WarnOnEmptyStructure<br>
   * Warn and produce empty InChI for empty structure<br>
   * /SaveOpt    Save custom InChI creation options (non-standard InChI)<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int GetINCHI(inchi_Input*, inchi_Output*)</code><br>
   * @param inp
   * @param out
   * @return
   */
  public static native int GetINCHI(tagINCHI_Input inp, tagINCHI_Output out);
  /**
   * Original signature : <code>int GetStdINCHI(inchi_Input*, inchi_Output*)</code><br>
   * @param inp
   * @param out
   * @return
   */
  public static native int GetStdINCHI(tagINCHI_Input inp, tagINCHI_Output out);
  /**
   * Extended version of GetINCHI supporting v. 1.05+ extensions: V3000; polymers<br>
   * Original signature : <code>int GetINCHIEx(inchi_InputEx*, inchi_Output*)</code><br>
   * @param inp
   * @param out
   * @return
   */
  public static native int GetINCHIEx(inchi_InputEx inp, tagINCHI_Output out);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * FreeINCHI / FreeStdINCHI<br>
   * should be called to deallocate char* pointers<br>
   * obtained from each GetINCHI /GetStdINCHI call<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>void FreeINCHI(inchi_Output*)</code><br>
   * @param out
   */
  public static native void FreeINCHI(tagINCHI_Output out);
  /**
   * Original signature : <code>void FreeStdINCHI(inchi_Output*)</code><br>
   * @param out
   */
  public static native void FreeStdINCHI(tagINCHI_Output out);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * GetStructFromINCHI / GetStructFromStdINCHI / GetStructFromINCHIEx<br>
   * inchi_Inputinchi_InputINCHI is created by the user; pointers in inchi_OutputStruct are allocated and deallocated by InChI<br>
   * inchi_OutputStruct does not need to be initialized out to zeroes; see FreeStructFromStdINCHI() on how to deallocate it<br>
   * Option /Inchi2Struct is not needed for GetStructFromINCHI()/GetStructFromStdINCHI()<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int GetStructFromINCHI(inchi_InputINCHI*, inchi_OutputStruct*)</code><br>
   * @param inpInChI
   * @param outStruct
   * @return
   */
  public static native int GetStructFromINCHI(tagINCHI_InputINCHI inpInChI, tagINCHI_OutputStruct outStruct);
  /**
   * Original signature : <code>int GetStructFromStdINCHI(inchi_InputINCHI*, inchi_OutputStruct*)</code><br>
   * @param inpInChI
   * @param outStruct
   * @return
   */
  public static native int GetStructFromStdINCHI(tagINCHI_InputINCHI inpInChI, tagINCHI_OutputStruct outStruct);
  /**
   * Original signature : <code>int GetStructFromINCHIEx(inchi_InputINCHI*, inchi_OutputStructEx*)</code><br>
   * @param inpInChI
   * @param outStruct
   * @return
   */
  public static native int GetStructFromINCHIEx(tagINCHI_InputINCHI inpInChI, tagINCHI_OutputStructEx outStruct);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * FreeStructFromINCHI / FreeStructFromStdINCHI / FreeStructFromINCHIEx<br>
   * should be called to deallocate pointers obtained from each<br>
   * GetStructFromStdINCHI / GetStructFromINCHI / GetStructFromINCHIEx<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>void FreeStructFromINCHI(inchi_OutputStruct*)</code><br>
   * @param out
   */
  public static native void FreeStructFromINCHI(tagINCHI_OutputStruct out);
  /**
   * Original signature : <code>void FreeStructFromStdINCHI(inchi_OutputStruct*)</code><br>
   * @param out
   */
  public static native void FreeStructFromStdINCHI(tagINCHI_OutputStruct out);
  /**
   * Original signature : <code>void FreeStructFromINCHIEx(inchi_OutputStructEx*)</code><br>
   * @param out
   */
  public static native void FreeStructFromINCHIEx(tagINCHI_OutputStructEx out);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * GetINCHIfromINCHI<br>
   * GetINCHIfromINCHI does same as -InChI2InChI option: converts InChI into InChI for validation purposes<br>
   * It may also be used to filter out specific layers. For instance, /Snon would remove stereochemical layer<br>
   * Omitting /FixedH and/or /RecMet would remove Fixed-H or Reconnected layers<br>
   * To keep all InChI layers use options string "/FixedH /RecMet"; option /InChI2InChI is not needed<br>
   * inchi_InputINCHI is created by the user; strings in inchi_Output are allocated and deallocated by InChI<br>
   * inchi_Output does not need to be initilized out to zeroes; see FreeINCHI() on how to deallocate it<br>
   * Note: there is no explicit tool to conversion from/to standard InChI<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int GetINCHIfromINCHI(inchi_InputINCHI*, inchi_Output*)</code><br>
   * @param inpInChI
   * @param out
   * @return
   */
  public static native int GetINCHIfromINCHI(tagINCHI_InputINCHI inpInChI, tagINCHI_Output out);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Get_inchi_Input_FromAuxInfo / Get_std_inchi_Input_FromAuxInfo<br>
   * Input:<br>
   * szInchiAuxInfo: contains ASCIIZ string of InChI output for a single<br>
   * structure or only the AuxInfo line<br>
   * bDoNotAddH:    if 0 then InChI will be allowed to add implicit H<br>
   * bDiffUnkUndfStereo<br>
   * if not 0, use different labels for unknown and undefined stereo<br>
   * pInchiInp:     should have a valid pointer pInchiInp-&gt;pInp to an empty<br>
   * (all members = 0) inchi_Input structure<br>
   * Output:<br>
   * pInchiInp:     The following members of pInp may be filled during the call:<br>
   * atom, num_atoms, stereo0D, num_stereo0D<br>
   * Return value:  see RetValGetINCHI<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int Get_inchi_Input_FromAuxInfo(char*, int, int, InchiInpData*)</code><br>
   * @param szInchiAuxInfo
   * @param bDoNotAddH
   * @param bDiffUnkUndfStereo
   * @param pInchiInp
   * @return
   */
  public static native int Get_inchi_Input_FromAuxInfo(String szInchiAuxInfo, boolean bDoNotAddH, boolean bDiffUnkUndfStereo, tagInchiInpData pInchiInp);
  /**
   * Original signature : <code>int Get_std_inchi_Input_FromAuxInfo(char*, int, InchiInpData*)</code><br>
   * @param szInchiAuxInfo
   * @param bDoNotAddH
   * @param pInchiInp
   * @return
   */
  public static native int Get_std_inchi_Input_FromAuxInfo(String szInchiAuxInfo, boolean bDoNotAddH, tagInchiInpData pInchiInp);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Free_inchi_Input / Free_std_inchi_Input<br>
   * To deallocate and write zeroes into the changed members of pInchiInp-&gt;pInp call<br>
   * Free_inchi_Input( inchi_Input *pInp )<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>void Free_inchi_Input(inchi_Input*)</code><br>
   * @param pInp
   */
  public static native void Free_inchi_Input(tagINCHI_Input pInp);
  /**
   * Original signature : <code>void Free_std_inchi_Input(inchi_Input*)</code><br>
   * @param pInp
   */
  public static native void Free_std_inchi_Input(tagINCHI_Input pInp);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * CheckINCHI<br>
   * Check if the string represents valid InChI/standard <br>
   * Input:<br>
   * szINCHI     source InChI<br>
   * strict      if 0, just briefly check for proper layout (prefix, version, etc.)<br>
   * The result may not be strict.<br>
   * If not 0, try to perform InChI2InChI conversion and<br>
   * returns success if a resulting InChI string exactly match source.<br>
   * The result may be 'false alarm' due to imperfectness of conversion.<br>
   * Returns:<br>
   * success/errors codes<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int CheckINCHI(const char*, const int)</code><br>
   * @param szINCHI
   * @param strict
   * @return
   */
  public static native int CheckINCHI(String szINCHI, boolean strict);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * GetINCHIKeyFromINCHI<br>
   * Calculate InChIKey by InChI string.<br>
   * Input:<br>
   * szINCHISource<br>
   * source InChI string<br>
   * xtra1<br>
   * =1 calculate hash extension (up to 256 bits; 1st block)<br>
   * xtra2<br>
   * =1 calculate hash extension (up to 256 bits; 2nd block)<br>
   * Output:<br>
   * szINCHIKey<br>
   * InChIKey string<br>
   * The user-supplied buffer szINCHIKey should be at least 28 bytes long.<br>
   * szXtra1<br>
   * hash extension (up to 256 bits; 1st block) string<br>
   * Caller should allocate space for 64 characters + trailing NULL<br>
   * szXtra2<br>
   * hash extension (up to 256 bits; 2nd block) string<br>
   * Caller should allocate space for 64 characters + trailing NULL<br>
   * Returns:<br>
   * success/errors codes<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int GetINCHIKeyFromINCHI(const char*, const int, const int, char*, char*, char*)</code><br>
   * @param szINCHISource
   * @param xtra1
   * @param xtra2
   * @param szINCHIKey
   * @param szXtra1
   * @param szXtra2
   * @return
   */
  public static native int GetINCHIKeyFromINCHI(String szINCHISource, int xtra1, int xtra2, byte[] szINCHIKey, byte[] szXtra1, byte[] szXtra2);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * GetStdINCHIKeyFromStdINCHI<br>
   * "Standard" counterpart<br>
   * For compatibility with v. 1.02std, no extra hash calculation is allowed.<br>
   * To calculate extra hash(es), use GetINCHIKeyFromINCHI with stdInChI as input.<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int GetStdINCHIKeyFromStdINCHI(const char*, char*)</code><br>
   * @param szINCHISource
   * @param szINCHIKey
   * @return
   */
  public static native int GetStdINCHIKeyFromStdINCHI(String szINCHISource, ByteBuffer szINCHIKey);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * CheckINCHIKey<br>
   * Check if the string represents valid InChIKey.<br>
   * Input:<br>
   * szINCHIKey<br>
   * source InChIKey string<br>
   * Returns:<br>
   * success/errors codes<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int CheckINCHIKey(const char*)</code><br>
   * @param szINCHIKey
   * @return
   */
  public static native int CheckINCHIKey(String szINCHIKey);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_Create / STDINCHIGEN_Create<br>
   * InChI Generator: create generator<br>
   * Returns handle of generator object or NULL on failure<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>INCHIGEN_HANDLE INCHIGEN_Create()</code><br>
   * @return
   */
  public static native Pointer INCHIGEN_Create();
  /**
   * Original signature : <code>INCHIGEN_HANDLE STDINCHIGEN_Create()</code><br>
   * @return
   */
  public static native Pointer STDINCHIGEN_Create();
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_Setup / STDINCHIGEN_Setup<br>
   * InChI Generator: setup<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int INCHIGEN_Setup(INCHIGEN_HANDLE, INCHIGEN_DATA*, inchi_Input*)</code><br>
   * @param HGen
   * @param pGenData
   * @param pInp
   * @return
   */
  public static native int INCHIGEN_Setup(Pointer HGen, tagINCHIGEN_DATA pGenData, tagINCHI_Input pInp);
  /**
   * Original signature : <code>int STDINCHIGEN_Setup(INCHIGEN_HANDLE, INCHIGEN_DATA*, inchi_Input*)</code><br>
   * @param HGen
   * @param pGenData
   * @param pInp
   * @return
   */
  public static native int STDINCHIGEN_Setup(Pointer HGen, tagINCHIGEN_DATA pGenData, tagINCHI_Input pInp);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_DoNormalization / STDINCHIGEN_DoNormalization<br>
   * InChI Generator: structure normalization stage<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int INCHIGEN_DoNormalization(INCHIGEN_HANDLE, INCHIGEN_DATA*)</code><br>
   * @param HGen
   * @param pGenData
   * @return
   */
  public static native int INCHIGEN_DoNormalization(Pointer HGen, tagINCHIGEN_DATA pGenData);
  /**
   * Original signature : <code>int STDINCHIGEN_DoNormalization(INCHIGEN_HANDLE, INCHIGEN_DATA*)</code><br>
   * @param HGen
   * @param pGenData
   * @return
   */
  public static native int STDINCHIGEN_DoNormalization(Pointer HGen, tagINCHIGEN_DATA pGenData);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_DoCanonicalization / STDINCHIGEN_DoCanonicalization<br>
   * InChI Generator: structure canonicalization stage<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int INCHIGEN_DoCanonicalization(INCHIGEN_HANDLE, INCHIGEN_DATA*)</code><br>
   * @param HGen
   * @param pGenData
   * @return
   */
  public static native int INCHIGEN_DoCanonicalization(Pointer HGen, tagINCHIGEN_DATA pGenData);
  /**
   * Original signature : <code>int STDINCHIGEN_DoCanonicalization(INCHIGEN_HANDLE, INCHIGEN_DATA*)</code><br>
   * @param HGen
   * @param pGenData
   * @return
   */
  public static native int STDINCHIGEN_DoCanonicalization(Pointer HGen, tagINCHIGEN_DATA pGenData);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_DoSerialization / STDINCHIGEN_DoSerialization<br>
   * InChI Generator: InChI serialization stage<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int INCHIGEN_DoSerialization(INCHIGEN_HANDLE, INCHIGEN_DATA*, inchi_Output*)</code><br>
   * @param HGen
   * @param pGenData
   * @param pResults
   * @return
   */
  public static native int INCHIGEN_DoSerialization(Pointer HGen, tagINCHIGEN_DATA pGenData, tagINCHI_Output pResults);
  /**
   * Original signature : <code>int STDINCHIGEN_DoSerialization(INCHIGEN_HANDLE, INCHIGEN_DATA*, inchi_Output*)</code><br>
   * @param HGen
   * @param pGenData
   * @param pResults
   * @return
   */
  public static native int STDINCHIGEN_DoSerialization(Pointer HGen, tagINCHIGEN_DATA pGenData, tagINCHI_Output pResults);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_Reset / STDINCHIGEN_Reset<br>
   * InChI Generator: reset stage (use before get next structure)<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>void INCHIGEN_Reset(INCHIGEN_HANDLE, INCHIGEN_DATA*, inchi_Output*)</code><br>
   * @param HGen
   * @param pGenData
   * @param pResults
   */
  public static native void INCHIGEN_Reset(Pointer HGen, tagINCHIGEN_DATA pGenData, tagINCHI_Output pResults);
  /**
   * Original signature : <code>void STDINCHIGEN_Reset(INCHIGEN_HANDLE, INCHIGEN_DATA*, inchi_Output*)</code><br>
   * @param HGen
   * @param pGenData
   * @param pResults
   */
  public static native void STDINCHIGEN_Reset(Pointer HGen, tagINCHIGEN_DATA pGenData, tagINCHI_Output pResults);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * INCHIGEN_Destroy / STDINCHIGEN_Destroy<br>
   * InChI Generator: destroy generator<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>void INCHIGEN_Destroy(INCHIGEN_HANDLE)</code><br>
   * @param HGen
   */
  public static native void INCHIGEN_Destroy(Pointer HGen);
  /**
   * Original signature : <code>void STDINCHIGEN_Destroy(INCHIGEN_HANDLE)</code><br>
   * @param HGen
   */
  public static native void STDINCHIGEN_Destroy(Pointer HGen);
  /**
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * MakeINCHIFromMolfileText<br>
   * Direct generation of InChI from Molfile supplied as text<br>
   * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^<br>
   * Original signature : <code>int MakeINCHIFromMolfileText(const char*, char*, inchi_Output*)</code><br>
   * @param moltext
   * @param options
   * @param result
   * @return
   */
  public static native int MakeINCHIFromMolfileText(String moltext, String options, tagINCHI_Output result);
  
  /** enum values */
  public static interface IXA_STATUS {
      public static final int IXA_STATUS_SUCCESS = 0;
      public static final int IXA_STATUS_WARNING = 1;
      public static final int IXA_STATUS_ERROR = 2;
  };
  /** enum values */
  public static interface IXA_ATOM_RADICAL {
      public static final int IXA_ATOM_RADICAL_NONE = 0;
      public static final int IXA_ATOM_RADICAL_SINGLET = 1;
      public static final int IXA_ATOM_RADICAL_DOUBLET = 2;
      public static final int IXA_ATOM_RADICAL_TRIPLET = 3;
  };
  /** enum values */
  public static interface IXA_BOND_TYPE {
      public static final int IXA_BOND_TYPE_SINGLE = 1;
      public static final int IXA_BOND_TYPE_DOUBLE = 2;
      public static final int IXA_BOND_TYPE_TRIPLE = 3;
      public static final int IXA_BOND_TYPE_AROMATIC = 4;
  };
  /** enum values */
  public static interface IXA_BOND_WEDGE {
      public static final int IXA_BOND_WEDGE_NONE = 0;
      public static final int IXA_BOND_WEDGE_UP = 1;
      public static final int IXA_BOND_WEDGE_DOWN = 2;
      public static final int IXA_BOND_WEDGE_EITHER = 3;
  };
  /** enum values */
  public static interface IXA_DBLBOND_CONFIG {
      public static final int IXA_DBLBOND_CONFIG_PERCEIVE = 0;
      public static final int IXA_DBLBOND_CONFIG_EITHER = 1;
  };
  /** enum values */
  public static interface IXA_STEREO_TOPOLOGY {
      public static final int IXA_STEREO_TOPOLOGY_INVALID = 0;
      public static final int IXA_STEREO_TOPOLOGY_TETRAHEDRON = 2;
      public static final int IXA_STEREO_TOPOLOGY_RECTANGLE = 3;
      public static final int IXA_STEREO_TOPOLOGY_ANTIRECTANGLE = 4;
  };
  /** enum values */
  public static interface IXA_STEREO_PARITY {
      public static final int IXA_STEREO_PARITY_NONE = 0;
      public static final int IXA_STEREO_PARITY_ODD = 1;
      public static final int IXA_STEREO_PARITY_EVEN = 2;
      public static final int IXA_STEREO_PARITY_UNKNOWN = 3;
  };
  /** enum values */
  public static interface IXA_INCHIBUILDER_OPTION {
      public static final int IXA_INCHIBUILDER_OPTION_NewPsOff = 0;
      public static final int IXA_INCHIBUILDER_OPTION_DoNotAddH = 1;
      public static final int IXA_INCHIBUILDER_OPTION_SUU = 2;
      public static final int IXA_INCHIBUILDER_OPTION_SLUUD = 3;
      public static final int IXA_INCHIBUILDER_OPTION_FixedH = 4;
      public static final int IXA_INCHIBUILDER_OPTION_RecMet = 5;
      public static final int IXA_INCHIBUILDER_OPTION_KET = 6;
      public static final int IXA_INCHIBUILDER_OPTION_15T = 7;
      public static final int IXA_INCHIBUILDER_OPTION_SaveOpt = 8;
      public static final int IXA_INCHIBUILDER_OPTION_AuxNone = 9;
      public static final int IXA_INCHIBUILDER_OPTION_WarnOnEmptyStructure = 10;
      public static final int IXA_INCHIBUILDER_OPTION_LargeMolecules = 11;
      public static final int IXA_INCHIBUILDER_OPTION_Polymers = 12;
      public static final int IXA_INCHIBUILDER_OPTION_Polymers105 = 13;
      public static final int IXA_INCHIBUILDER_OPTION_Polymers105Plus = 14;
      public static final int IXA_INCHIBUILDER_OPTION_FilterSS = 15;
      public static final int IXA_INCHIBUILDER_OPTION_InvFilterSS = 16;
      public static final int IXA_INCHIBUILDER_OPTION_NPZZ = 17;
      public static final int IXA_INCHIBUILDER_OPTION_SATZZ = 18;
      public static final int IXA_INCHIBUILDER_OPTION_NoFrameShift = 19;
      public static final int IXA_INCHIBUILDER_OPTION_FoldCRU = 20;
      public static final int IXA_INCHIBUILDER_OPTION_NoEdits = 21;
      public static final int IXA_INCHIBUILDER_OPTION_LooseTSACheck = 22;
      public static final int IXA_INCHIBUILDER_OPTION_OutErrInChI = 23;
      public static final int IXA_INCHIBUILDER_OPTION_NoWarnings = 24;
  };
  /** enum values */
  public static interface IXA_INCHIBUILDER_STEREOOPTION {
      public static final int IXA_INCHIBUILDER_STEREOOPTION_SAbs = 0;
      public static final int IXA_INCHIBUILDER_STEREOOPTION_SNon = 1;
      public static final int IXA_INCHIBUILDER_STEREOOPTION_SRel = 2;
      public static final int IXA_INCHIBUILDER_STEREOOPTION_SRac = 3;
      public static final int IXA_INCHIBUILDER_STEREOOPTION_SUCF = 4;
  };
  public static final int IXA_ATOM_NATURAL_MASS = (int)0;
  public static final int IXA_EXT_MOLDATA_INVALID = (int)(-1);
  public static final int IXA_EXT_POLYMER_INVALID = (int)(-1);
  public static final int IXA_EXT_V3000_INVALID = (int)(-1);
  public static final int IXA_USES_SMART_ALLOCS = (int)1;

  /*
   * Functions handling IXA Status Objects<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_Create()</code><br>
   * @return
   */
  static native Pointer IXA_STATUS_Create();
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_Clear(Pointer)</code><br>
   * @param hStatus
   */
  static native void IXA_STATUS_Clear(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_Destroy(Pointer)</code><br>
   * @param hStatus
   */
  static native void IXA_STATUS_Destroy(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_HasError(Pointer)</code><br>
   * @param hStatus
   * @return
   */
  static native boolean IXA_STATUS_HasError(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_HasWarning(Pointer)</code><br>
   * @param hStatus
   * @return
   */
  static native boolean IXA_STATUS_HasWarning(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_GetCount(Pointer)</code><br>
   * @param hStatus
   * @return
   */
  static native int IXA_STATUS_GetCount(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_GetSeverity(Pointer, int)</code><br>
   * @param hStatus
   * @param vIndex
   * @return
   */
  static native int IXA_STATUS_GetSeverity(Pointer hStatus, int vIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_STATUS_GetMessage(Pointer, int)</code><br>
   * @param hStatus
   * @param vIndex
   * @return
   */
  static native String IXA_STATUS_GetMessage(Pointer hStatus, int vIndex);
  /*
   * Functions to Create, Clear and Destroy Molecule Objects<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_Create(Pointer)</code><br>
   * @param hStatus
   * @return
   */
  static native Pointer IXA_MOL_Create(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_Clear(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   */
  static native void IXA_MOL_Clear(Pointer hStatus, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_Destroy(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   */
  static native void IXA_MOL_Destroy(Pointer hStatus, Pointer hMolecule);
  /*
   * Functions Operating on Complete Molecules<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_ReadMolfile(Pointer, Pointer, const char*)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param pBytes
   */
  static native void IXA_MOL_ReadMolfile(Pointer hStatus, Pointer hMolecule, byte[] pBytes);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_ReadInChI(Pointer, Pointer, const char*)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param pInChI
   */
  static native void IXA_MOL_ReadInChI(Pointer hStatus, Pointer hMolecule, byte[] pInChI);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetChiral(Pointer, Pointer, IXA_BOOL)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vChiral
   */
  static native void IXA_MOL_SetChiral(Pointer hStatus, Pointer hMolecule, boolean vChiral);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetChiral(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @return
   */
  static native boolean IXA_MOL_GetChiral(Pointer hStatus, Pointer hMolecule);
  /*
   * Functions to Add and Define Atoms<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_CreateAtom(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @return
   */
  static native Pointer IXA_MOL_CreateAtom(Pointer hStatus, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomElement(Pointer, Pointer, Pointer, const char*)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param pElement
   */
  static native void IXA_MOL_SetAtomElement(Pointer hStatus, Pointer hMolecule, Pointer vAtom, byte[] pElement);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomAtomicNumber(Pointer, Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vAtomicNumber
   */
  static native void IXA_MOL_SetAtomAtomicNumber(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vAtomicNumber);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomMass(Pointer, Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vMassNumber
   */
  static native void IXA_MOL_SetAtomMass(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vMassNumber);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomCharge(Pointer, Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vCharge
   */
  static native void IXA_MOL_SetAtomCharge(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vCharge);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomRadical(Pointer, Pointer, Pointer, IXA_ATOM_RADICAL)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vRadical
   */
  static native void IXA_MOL_SetAtomRadical(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vRadical);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomHydrogens(Pointer, Pointer, Pointer, int, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vHydrogenMassNumber
   * @param vHydrogenCount
   */
  static native void IXA_MOL_SetAtomHydrogens(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vHydrogenMassNumber, int vHydrogenCount);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomX(Pointer, Pointer, Pointer, double)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vX
   */
  static native void IXA_MOL_SetAtomX(Pointer hStatus, Pointer hMolecule, Pointer vAtom, double vX);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomY(Pointer, Pointer, Pointer, double)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vY
   */
  static native void IXA_MOL_SetAtomY(Pointer hStatus, Pointer hMolecule, Pointer vAtom, double vY);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetAtomZ(Pointer, Pointer, Pointer, double)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vZ
   */
  static native void IXA_MOL_SetAtomZ(Pointer hStatus, Pointer hMolecule, Pointer vAtom, double vZ);
  /*
   * Functions to Add and Define Bonds<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_CreateBond(Pointer, Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom1
   * @param vAtom2
   * @return
   */
  static native Pointer IXA_MOL_CreateBond(Pointer hStatus, Pointer hMolecule, Pointer vAtom1, Pointer vAtom2);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetBondType(Pointer, Pointer, Pointer, IXA_BOND_TYPE)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @param vType
   */
  static native void IXA_MOL_SetBondType(Pointer hStatus, Pointer hMolecule, Pointer vBond, int vType);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetBondWedge(Pointer, Pointer, Pointer, Pointer, IXA_BOND_WEDGE)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @param vRefAtom
   * @param vDirection
   */
  static native void IXA_MOL_SetBondWedge(Pointer hStatus, Pointer hMolecule, Pointer vBond, Pointer vRefAtom, int vDirection);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetDblBondConfig(Pointer, Pointer, Pointer, IXA_DBLBOND_CONFIG)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @param vConfig
   */
  static native void IXA_MOL_SetDblBondConfig(Pointer hStatus, Pointer hMolecule, Pointer vBond, int vConfig);
  
  /*
   * Functions to Add and Define Stereodescriptors<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_CreateStereoTetrahedron(Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vCentralAtom
   * @param vVertex1
   * @param vVertex2
   * @param vVertex3
   * @param vVertex4
   * @return
   */
  static native Pointer IXA_MOL_CreateStereoTetrahedron(Pointer hStatus, Pointer hMolecule, Pointer vCentralAtom, Pointer vVertex1, Pointer vVertex2, Pointer vVertex3, Pointer vVertex4);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_CreateStereoRectangle(Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vCentralBond
   * @param vVertex1
   * @param vVertex2
   * @param vVertex3
   * @param vVertex4
   * @return
   */
  static native Pointer IXA_MOL_CreateStereoRectangle(Pointer hStatus, Pointer hMolecule, Pointer vCentralBond, Pointer vVertex1, Pointer vVertex2, Pointer vVertex3, Pointer vVertex4);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_CreateStereoAntiRectangle(Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vCentralAtom
   * @param vVertex1
   * @param vVertex2
   * @param vVertex3
   * @param vVertex4
   * @return
   */
  static native Pointer IXA_MOL_CreateStereoAntiRectangle(Pointer hStatus, Pointer hMolecule, Pointer vCentralAtom, Pointer vVertex1, Pointer vVertex2, Pointer vVertex3, Pointer vVertex4);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetStereoParity(Pointer, Pointer, Pointer, IXA_STEREO_PARITY)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @param vParity
   */
  static native void IXA_MOL_SetStereoParity(Pointer hStatus, Pointer hMolecule, Pointer vStereo, int vParity);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_ReserveSpace(IXA_STATUS_HANDLE, IXA_MOL_HANDLE, int, int, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param num_atoms
   * @param num_bonds
   * @param num_stereos
   * @return
   */
  static native int IXA_MOL_ReserveSpace(Pointer hStatus, Pointer hMolecule, int num_atoms, int num_bonds, int num_stereos);
  
  /*
   * Functions to to Treat Extended molecular data
   */
  //FIXME IXA_MOL_CreatePolymerUnit and IXA_MOL_SetPolymerUnit are missing from Linux build
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_CreatePolymerUnit(IXA_STATUS_HANDLE, IXA_MOL_HANDLE)</code><br>
   * @param hStatus
   * @param hMolecule
   * @return
   */
  //static native Pointer IXA_MOL_CreatePolymerUnit(Pointer hStatus, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_SetPolymerUnit(IXA_STATUS_HANDLE, IXA_MOL_HANDLE, IXA_POLYMERUNITID, int, int, int, int, int, int, int, double[4], double[4], char[80], int*, int*)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vPunit
   * @param vid
   * @param vtype
   * @param vsubtype
   * @param vconn
   * @param vlabel
   * @param vna
   * @param vnb
   * @param vxbr1
   * @param vxbr2
   * @param vsmt
   * @param valist
   * @param vblist
   */
  //static native void IXA_MOL_SetPolymerUnit(Pointer hStatus, Pointer hMolecule, Pointer vPunit, int vid, int vtype, int vsubtype, int vconn, int vlabel, int vna, int vnb, DoubleBuffer vxbr1, DoubleBuffer vxbr2, ByteBuffer vsmt, IntBuffer valist, IntBuffer vblist);
  
  /*
   * Functions to Navigate Within a Molecule<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetNumAtoms(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @return
   */
  static native int IXA_MOL_GetNumAtoms(Pointer hStatus, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetNumBonds(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @return
   */
  static native int IXA_MOL_GetNumBonds(Pointer hStatus, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomId(Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtomIndex
   * @return
   */
  static native Pointer IXA_MOL_GetAtomId(Pointer hStatus, Pointer hMolecule, int vAtomIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondId(Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBondIndex
   * @return
   */
  static native Pointer IXA_MOL_GetBondId(Pointer hStatus, Pointer hMolecule, int vBondIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomIndex(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native int IXA_MOL_GetAtomIndex(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondIndex(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @return
   */
  static native int IXA_MOL_GetBondIndex(Pointer hStatus, Pointer hMolecule, Pointer vBond);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomNumBonds(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native int IXA_MOL_GetAtomNumBonds(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  //FIXME IXA_MOL_GetPolymerUnitId and IXA_MOL_GetPolymerUnitIndex are missing from Linux build
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetPolymerUnitId(IXA_STATUS_HANDLE, IXA_MOL_HANDLE, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vPolymerUnitIndex
   * @return
   */
  //static native Pointer IXA_MOL_GetPolymerUnitId(Pointer hStatus, Pointer hMolecule, int vPolymerUnitIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetPolymerUnitIndex(IXA_STATUS_HANDLE, IXA_MOL_HANDLE, IXA_POLYMERUNITID)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vPolymerUnit
   * @return
   */
  //static native int IXA_MOL_GetPolymerUnitIndex(Pointer hStatus, Pointer hMolecule, Pointer vPolymerUnit);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomBond(Pointer, Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vBondIndex
   * @return
   */
  static native Pointer IXA_MOL_GetAtomBond(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vBondIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetCommonBond(Pointer, Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom1
   * @param vAtom2
   * @return
   */
  static native Pointer IXA_MOL_GetCommonBond(Pointer hStatus, Pointer hMolecule, Pointer vAtom1, Pointer vAtom2);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondAtom1(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @return
   */
  static native Pointer IXA_MOL_GetBondAtom1(Pointer hStatus, Pointer hMolecule, Pointer vBond);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondAtom2(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @return
   */
  static native Pointer IXA_MOL_GetBondAtom2(Pointer hStatus, Pointer hMolecule, Pointer vBond);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondOtherAtom(IXA_STATUS_HANDLE, IXA_MOL_HANDLE, IXA_BONDID, IXA_ATOMID)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @param vAtom
   * @return
   */
  static native Pointer IXA_MOL_GetBondOtherAtom(Pointer hStatus, Pointer hMolecule, Pointer vBond, Pointer vAtom);
  
  /*
   * Functions to Return Information About Atoms<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomElement(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native String IXA_MOL_GetAtomElement(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomAtomicNumber(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native int IXA_MOL_GetAtomAtomicNumber(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomMass(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native int IXA_MOL_GetAtomMass(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomCharge(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native int IXA_MOL_GetAtomCharge(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomRadical(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native int IXA_MOL_GetAtomRadical(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomHydrogens(Pointer, Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @param vHydrogenMassNumber
   * @return
   */
  static native int IXA_MOL_GetAtomHydrogens(Pointer hStatus, Pointer hMolecule, Pointer vAtom, int vHydrogenMassNumber);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomX(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native double IXA_MOL_GetAtomX(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomY(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native double IXA_MOL_GetAtomY(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetAtomZ(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vAtom
   * @return
   */
  static native double IXA_MOL_GetAtomZ(Pointer hStatus, Pointer hMolecule, Pointer vAtom);
  
  /*
   * Functions to Return Information About Bonds<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondType(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @return
   */
  static native int IXA_MOL_GetBondType(Pointer hStatus, Pointer hMolecule, Pointer vBond);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetBondWedge(Pointer, Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @param vRefAtom
   * @return
   */
  static native int IXA_MOL_GetBondWedge(Pointer hStatus, Pointer hMolecule, Pointer vBond, Pointer vRefAtom);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetDblBondConfig(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vBond
   * @return
   */
  static native int IXA_MOL_GetDblBondConfig(Pointer hStatus, Pointer hMolecule, Pointer vBond);
  
  /*
   * Functions to return Information About Stereodescriptors<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetNumStereos(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @return
   */
  static native int IXA_MOL_GetNumStereos(Pointer hStatus, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoId(Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereoIndex
   * @return
   */
  static native Pointer IXA_MOL_GetStereoId(Pointer hStatus, Pointer hMolecule, int vStereoIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoIndex(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @return
   */
  static native int IXA_MOL_GetStereoIndex(Pointer hStatus, Pointer hMolecule, Pointer vStereo);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoTopology(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @return
   */
  static native int IXA_MOL_GetStereoTopology(Pointer hStatus, Pointer hMolecule, Pointer vStereo);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoCentralAtom(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @return
   */
  static native Pointer IXA_MOL_GetStereoCentralAtom(Pointer hStatus, Pointer hMolecule, Pointer vStereo);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoCentralBond(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @return
   */
  static native Pointer IXA_MOL_GetStereoCentralBond(Pointer hStatus, Pointer hMolecule, Pointer vStereo);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoNumVertices(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @return
   */
  static native int IXA_MOL_GetStereoNumVertices(Pointer hStatus, Pointer hMolecule, Pointer vStereo);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoVertex(Pointer, Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @param vVertexIndex
   * @return
   */
  static native Pointer IXA_MOL_GetStereoVertex(Pointer hStatus, Pointer hMolecule, Pointer vStereo, int vVertexIndex);
  /**
   * Original signature : <code>INCHI_DECL IXA_MOL_GetStereoParity(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hMolecule
   * @param vStereo
   * @return
   */
  static native int IXA_MOL_GetStereoParity(Pointer hStatus, Pointer hMolecule, Pointer vStereo);
  
  /*
   * Functions for Generating InChIs<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_Create(Pointer)</code><br>
   * @param hStatus
   * @return
   */
  static native Pointer IXA_INCHIBUILDER_Create(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_SetMolecule(Pointer, Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param hMolecule
   */
  static native void IXA_INCHIBUILDER_SetMolecule(Pointer hStatus, Pointer hInChIBuilder, Pointer hMolecule);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_GetInChI(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @return
   */
  static native String IXA_INCHIBUILDER_GetInChI(Pointer hStatus, Pointer hInChIBuilder);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_GetInChIEx(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hBuilder
   * @return
   */
  static native String IXA_INCHIBUILDER_GetInChIEx(Pointer hStatus, Pointer hBuilder);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_GetAuxInfo(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @return
   */
  static native String IXA_INCHIBUILDER_GetAuxInfo(Pointer hStatus, Pointer hInChIBuilder);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_GetLog(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @return
   */
  static native String IXA_INCHIBUILDER_GetLog(Pointer hStatus, Pointer hInChIBuilder);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_Destroy(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   */
  static native void IXA_INCHIBUILDER_Destroy(Pointer hStatus, Pointer hInChIBuilder);

  /*
   * Functions for Specifying InChI Generation Options<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_SetOption(Pointer, Pointer, IXA_INCHIBUILDER_OPTION, IXA_BOOL)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param vOption
   * @param vValue
   */
  static native void IXA_INCHIBUILDER_SetOption(Pointer hStatus, Pointer hInChIBuilder, int vOption, boolean vValue);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_SetOption_Stereo(Pointer, Pointer, IXA_INCHIBUILDER_STEREOOPTION)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param vValue
   */
  static native void IXA_INCHIBUILDER_SetOption_Stereo(Pointer hStatus, Pointer hInChIBuilder, int vValue);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_SetOption_Timeout(Pointer, Pointer, int)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param vValue
   */
  static native void IXA_INCHIBUILDER_SetOption_Timeout(Pointer hStatus, Pointer hInChIBuilder, int vValue);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_SetOption_Timeout_MilliSeconds(IXA_STATUS_HANDLE, IXA_INCHIBUILDER_HANDLE, long)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param vValue
   */
  static native void IXA_INCHIBUILDER_SetOption_Timeout_MilliSeconds(Pointer hStatus, Pointer hInChIBuilder, long vValue);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_CheckOption(IXA_STATUS_HANDLE, IXA_INCHIBUILDER_HANDLE, IXA_INCHIBUILDER_OPTION)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param vOption
   * @return
   */
  static native boolean IXA_INCHIBUILDER_CheckOption(Pointer hStatus, Pointer hInChIBuilder, int vOption);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIBUILDER_CheckOption_Stereo(IXA_STATUS_HANDLE, IXA_INCHIBUILDER_HANDLE, IXA_INCHIBUILDER_STEREOOPTION)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @param vValue
   * @return
   */
  static native boolean IXA_INCHIBUILDER_CheckOption_Stereo(Pointer hStatus, Pointer hInChIBuilder, int vValue);
  //FIXME IXA_INCHIBUILDER_GetOption_Timeout_MilliSeconds is missing from Linux build
  /**
   * Original signature : <code>long INCHI_DECL IXA_INCHIBUILDER_GetOption_Timeout_MilliSeconds(IXA_STATUS_HANDLE, IXA_INCHIBUILDER_HANDLE)</code><br>
   * @param hStatus
   * @param hInChIBuilder
   * @return
   */
  //static native long IXA_INCHIBUILDER_GetOption_Timeout_MilliSeconds(Pointer hStatus, Pointer hInChIBuilder);

  /*
   * Functions for Generating InChI Keys<br>
   */
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIKEYBUILDER_Create(Pointer)</code><br>
   * @param hStatus
   * @return
   */
  static native Pointer IXA_INCHIKEYBUILDER_Create(Pointer hStatus);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIKEYBUILDER_SetInChI(Pointer, Pointer, const char*)</code><br>
   * @param hStatus
   * @param hInChIKeyBuilder
   * @param pInChI
   */
  static native void IXA_INCHIKEYBUILDER_SetInChI(Pointer hStatus, Pointer hInChIKeyBuilder, byte[] pInChI);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIKEYBUILDER_GetInChIKey(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIKeyBuilder
   * @return
   */
  static native String IXA_INCHIKEYBUILDER_GetInChIKey(Pointer hStatus, Pointer hInChIKeyBuilder);
  /**
   * Original signature : <code>INCHI_DECL IXA_INCHIKEYBUILDER_Destroy(Pointer, Pointer)</code><br>
   * @param hStatus
   * @param hInChIKeyBuilder
   */
  static native void IXA_INCHIKEYBUILDER_Destroy(Pointer hStatus, Pointer hInChIKeyBuilder);

}
