# Important Issue

- Those using PDAL to compress to LAZ should be aware that we have found an issue with LASzip that may cause PDAL to create compressed data for point types 6 and greater that can't be fully read.  See https://github.com/LASzip/LASzip/issues/50 for more information or to see if the issue has been resolved in LASzip.

# Changes of Note

- PointTableRef is now publicly accessible from PointView (#1926) 
- Minimum CMake version is now 3.5
- ``filters.hexbin`` is now a built-in stage, rather than a plugin. (#2001)
- Removed support for `ght` compression in `writers.pgpointcloud`. (#2148)
- On OSX, plugins are now installed with ID of `@rpath` rather than `@loader_path/../lib`
- The API for `StreamPointTable::StreamPointTable()` now requires the capacity of the table to be passed as an argument.

# Enhancements

- Added ``denoise`` and ``reset`` options to ``pdal ground``. (#1579)
- ``readers.gdal`` now supports stream mode and provides the ``header`` option to map dimensions.  It also supports fetching bounds without reading the entire file. (#1819)
- ``readers.mbio`` added `datatype` option to support reading sidescan data. (#1852)
- ``filters.stats`` was computing expensive kurtosis and skewness statistics by default. These statistics are now available with the ``advanced`` option. (#1878)
- Added backtrace support for alpine linux-based Docker containers. (#1904)
- Added a `condition` option for ``filters.assign`` to limit assignment. (#1956)
- Add access to artifact manager keys. (#2026)
- Added support for LAZ compression in ``writers.pgpointcloud`` (#2050)
- Replaced ``last`` option with ``returns`` to support more flexible segmentation in ``filters.smrf`` and ``filters.pmf``. (#2053)
- ``writers.text`` now supports stream mode. (#2064)
- Added ``pdal tile`` kernel with streaming support to conveniently tile data. (#2065)
- A KD-tree used in one filter will now be reused in subsequent filters when possible. (#2123)
- ``writers.ply``  now has a `precision` option to specify output precision. (#2144)
- ``filters.smrf`` and ``filters.pmf`` supports complete range syntax for the `ignore` option. (#2157)
- ``filters.hexbin`` now supports stream mode. (#2170)
- ``readers.numpy`` now has the `order` option, which replaces the previous `x`, `y` and `z` options.  It also supports structured numpy arrays and maps values to the X, Y and Z dimensions accordingly.
- All readers now support setting a spatial reference to override any in the data with the `spatialreference` option.
- Add support for unicode filenames in pipelines on Windows platforms.
- Added NumpyReader::setArray() to support direct setting of a numpy array into `readers.numpy`.
- Added StreamPointTable::setNumPoints() and support in Streamable::execute() allowing custom point tables to know the number of points in each pass through the point table.
- Added SpatialReference::isProjected() to allow callers to determine if a spatial reference specifies a projection.  Also added SpatialReference::identifyHorizontalEPSG() and SpatialReference::identifyVerticalEPSG() to return an EPSG code from a spatial reference if possible.
- Added support for reading BPF files stored remotely.

# New stages

- `readers.rdb` - Support reading RIEGL RDB data.
- `readers.i3s` - Support reading of web service-style Esri I3S point clouds.
- `readers.slpk` - Support reading of file-based I3S-style point clouds.
- `writers.fbx` - Experimental Unity engine (SDK required) support. (#2127)
- `filters.nndistance` - Replaces `filters.kdistance` and adds average distance support. (#2071)
- `filters.dem` - Filter data based on bounds relative to a raster value. (#2090)
- `filters.delaunay` - Create a delauany triangulation of a point cloud. (#1855)
- `filters.info` - Generate metadata about an input point set.  Used by `pdal info`.

# Deprecated stages

- `filters.kdistance` - Replaced by `filters.nndistance`.

# Bug fixes

- Fixed an incorrect error message suggesting there were multiple SRSs in some cases when reading multiple inputs. (#2009)
- Fixed a problem in ``filters.reprojection`` in stream mode that would improperly reproject when there were multiple input sources with differing SRSs. (#2058)
- Fixed a problem in stream mode where a stage with no SRS would override the active SRS during processing. (#2069)
- Fixed a problem in ``writers.gdal`` where output would be aggregated if multiple inputs were provided. (#2074)
- The `count` option was not respected in stream mode.  It now properly limits the number of points read. (#2086)
- Fixed an off-by-one error that could create improper values in ``writers.gdal``.  Most data differences were small and not usually problematic. (#2095)
- Multiple option values can be specified on the command line by repeating the option assignment. (#2114)
- Added a missing initialization in `filters.returns` that could cause more point views to be returned than requested. (#2115)
- Emit an error if the `count` option isn't set for `readers.faux`. (#2128)
- PipelineManager::getStage() now returns a proper leaf node. (#2149)
- Fixed logic for `filters.crop` in streaming mode with multiple crop areas that could return too few points. (#2198)
- Added the `minimal` option for `readers.rxp` that was documented but not fully implemented. (#2225)
- Fixed an error in failing to read all points in `readers.rxp` exposed with a newer SDK. (#2226)
- Fixed an error in fetching floating point data from a PointContainer when the value was NaN. (#2239)

