This folder contains scripts and notebooks to prepare the user manual.

|       file name            |              description                      |
|----------------------------|-----------------------------------------------|
| blackbox.ipynb             | prepares the blackbox solver documentation    |
| numericalpolynomials.ipynb | documents the input to the solver             |
| numericalsolutions.ipynb   | explains what a numerical solution is         |
| reproducibleruns.ipynb     | on seeding the random number generator        |
| scaling.ipynb              | equation and variable scaling                 |
| speedup.py                 | script to illustrate speed up                 |
| qualityup.py               | compensating for double double arithmetic     |
| parallelruns.ipynb         | speed up and quality up with parallel runs    |
| rootcounts.ipynb           | root counts and start systems                 |
| incfixaposteriori.ipynb    | increment-fix aposteriori step control        |
| incfixapriori.ipynb        | increment-fix apriori step control            |
| schubert.ipynb             | Pieri and Littlewood-Richardson homotopies    |
| newtondeflation.ipynb      | Newton's method, deflation and multiplicity   |
| sweephomotopies.ipynb      | arc length parameter continuation             |
| seriesexpansions.ipynb     | power series expansions of algebraic curves   |
| posdimsolsets.ipynb        | positive dimensional solution sets            |
| snippets.py                | code snippets from the Jupyter notebook menus |
