package org.codehaus.plexus.util;

/*
 * Copyright The Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;

/**
 * Static methods to create Properties loaded from various sources.
 *
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @author <a href="mailto:mmaczka@interia.pl">Michal Maczka</a>
 * @version $Id$
 */
public class PropertyUtils
{

    public static Properties loadProperties( final URL url )
        throws IOException
    {
        if ( url == null )
        {
            throw new NullPointerException( "url" );
        }

        return loadProperties( url.openStream() );
    }

    public static Properties loadProperties( final File file )
        throws IOException
    {
        if ( file == null )
        {
            throw new NullPointerException( "file" );
        }

        return loadProperties( new FileInputStream( file ) );
    }

    public static Properties loadProperties( final InputStream is )
        throws IOException
    {
        InputStream in = is;
        try
        {
            final Properties properties = new Properties();

            // Make sure the properties stream is valid
            if ( in != null )
            {
                properties.load( in );
                in.close();
                in = null;
            }

            return properties;
        }
        finally
        {
            IOUtil.close( in );
        }
    }

}
