# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AllowCrashDumpCollection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allow crash dumps values."""

    ENABLED = "Enabled"
    """Crash dump collection enabled"""
    DISABLED = "Disabled"
    """Crash dump collection disabled"""


class CapabilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Capability image type."""

    APPLICATION_DEVELOPMENT = "ApplicationDevelopment"
    """Application development capability"""
    FIELD_SERVICING = "FieldServicing"
    """Field servicing capability"""


class CertificateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Certificate status values."""

    ACTIVE = "Active"
    """Certificate is active"""
    INACTIVE = "Inactive"
    """Certificate is inactive"""
    EXPIRED = "Expired"
    """Certificate has expired"""
    REVOKED = "Revoked"
    """Certificate has been revoked"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ImageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Image type values."""

    INVALID_IMAGE_TYPE = "InvalidImageType"
    """Invalid image."""
    ONE_BL = "OneBl"
    """One Bl image type"""
    PLUTON_RUNTIME = "PlutonRuntime"
    """Pluton image type"""
    WIFI_FIRMWARE = "WifiFirmware"
    """Wifi firmware image type"""
    SECURITY_MONITOR = "SecurityMonitor"
    """Security monitor image type"""
    NORMAL_WORLD_LOADER = "NormalWorldLoader"
    """Normal world loader image type"""
    NORMAL_WORLD_DTB = "NormalWorldDtb"
    """Normal world dtb image type"""
    NORMAL_WORLD_KERNEL = "NormalWorldKernel"
    """Normal world kernel image type"""
    ROOT_FS = "RootFs"
    """Root FS image type"""
    SERVICES = "Services"
    """Services image type"""
    APPLICATIONS = "Applications"
    """Applications image type"""
    FW_CONFIG = "FwConfig"
    """FW config image type"""
    BOOT_MANIFEST = "BootManifest"
    """Boot manifest image type"""
    NWFS = "Nwfs"
    """Nwfs image type"""
    TRUSTED_KEYSTORE = "TrustedKeystore"
    """Trusted key store image type"""
    POLICY = "Policy"
    """Policy image type"""
    CUSTOMER_BOARD_CONFIG = "CustomerBoardConfig"
    """Customer board config image type"""
    UPDATE_CERT_STORE = "UpdateCertStore"
    """Update certificate store image type"""
    BASE_SYSTEM_UPDATE_MANIFEST = "BaseSystemUpdateManifest"
    """Base system update manifest image type"""
    FIRMWARE_UPDATE_MANIFEST = "FirmwareUpdateManifest"
    """Firmware update manifest image type"""
    CUSTOMER_UPDATE_MANIFEST = "CustomerUpdateManifest"
    """Customer update manifest image type"""
    RECOVERY_MANIFEST = "RecoveryManifest"
    """Recovery manifest image type"""
    MANIFEST_SET = "ManifestSet"
    """manifest set image type"""
    OTHER = "Other"
    """Other image type"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class OSFeedType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OS feed type values."""

    RETAIL = "Retail"
    """Retail OS feed type."""
    RETAIL_EVAL = "RetailEval"
    """Retail evaluation OS feed type."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """The resource is being provisioned"""
    UPDATING = "Updating"
    """The resource is being updated"""
    DELETING = "Deleting"
    """The resource is being deleted"""
    ACCEPTED = "Accepted"
    """The resource create request has been accepted"""


class RegionalDataBoundary(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Regional data boundary values."""

    NONE = "None"
    """No data boundary"""
    EU = "EU"
    """EU data boundary"""


class UpdatePolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update policy values."""

    UPDATE_ALL = "UpdateAll"
    """Update all policy."""
    NO3_RD_PARTY_APP_UPDATES = "No3rdPartyAppUpdates"
    """No update for 3rd party app policy."""
