# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AcceleratorManufacturer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Accelerator manufacturers supported by Azure VMs."""

    AMD = "AMD"
    """AMD GpuType"""
    NVIDIA = "Nvidia"
    """Nvidia GpuType"""
    XILINX = "Xilinx"
    """Xilinx GpuType"""


class AcceleratorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Accelerator types supported by Azure VMs."""

    GPU = "GPU"
    """GPU Accelerator"""
    FPGA = "FPGA"
    """FPGA Accelerator"""


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ArchitectureType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Architecture types supported by Azure VMs."""

    ARM64 = "ARM64"
    """ARM64 Architecture"""
    X64 = "X64"
    """X64 Architecture"""


class CachingTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the caching requirements."""

    NONE = "None"
    """'None' is default for Standard Storage"""
    READ_ONLY = "ReadOnly"
    """'ReadOnly' is default for Premium Storage"""
    READ_WRITE = "ReadWrite"
    """'ReadWrite' is default for OS Disk"""


class CapacityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Capacity types for Compute Fleet."""

    VM = "VM"
    """Default. VM is the default capacity type for Compute Fleet where Fleet capacity is provisioned
    in terms of VMs."""
    V_CPU = "VCpu"
    """VCpu is the capacity type for Compute Fleet where Fleet capacity is provisioned in terms of
    VCpus.
    If VCpu capacity is not exactly divisible by VCpu count in VMSizes, Fleet capacity in VCpus
    will be overprovisioned by default."""


class CpuManufacturer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cpu Manufacturers  supported by Azure VMs."""

    INTEL = "Intel"
    """Intel CPU."""
    AMD = "AMD"
    """AMD CPU."""
    MICROSOFT = "Microsoft"
    """Microsoft CPU."""
    AMPERE = "Ampere"
    """Ampere CPU."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DeleteOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify what happens to the network interface when the VM is deleted."""

    DELETE = "Delete"
    """Delete Option"""
    DETACH = "Detach"
    """Detach Option"""


class DiffDiskOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ephemeral disk option for operating system disk."""

    LOCAL = "Local"
    """Local Option."""


class DiffDiskPlacement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ephemeral disk placement for operating system disk. This property
    can be used by user in the request to choose the location i.e, cache disk or
    resource disk space for Ephemeral OS disk provisioning. For more information on
    Ephemeral OS disk size requirements, please refer Ephemeral OS disk size
    requirements for Windows VM at
    `https://learn.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
    <https://learn.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements>`_
    and Linux VM at
    `https://learn.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements
    <https://learn.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>`_
    Minimum api-version for NvmeDisk: 2024-03-01.
    """

    CACHE_DISK = "CacheDisk"
    """CacheDisk option."""
    RESOURCE_DISK = "ResourceDisk"
    """Resource Disk option."""
    NVME_DISK = "NvmeDisk"
    """NvmeDisk option."""


class DiskControllerTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the disk controller type configured for the VM and
    VirtualMachineScaleSet. This property is only supported for virtual machines
    whose operating system disk and VM sku supports Generation 2
    (`https://learn.microsoft.com/en-us/azure/virtual-machines/generation-2
    <https://learn.microsoft.com/en-us/azure/virtual-machines/generation-2>`_), please
    check the HyperVGenerations capability returned as part of VM sku capabilities
    in the response of Microsoft.Compute SKUs api for the region contains V2
    (`https://learn.microsoft.com/rest/api/compute/resourceskus/list
    <https://learn.microsoft.com/rest/api/compute/resourceskus/list>`_). For more
    information about Disk Controller Types supported please refer to
    `https://aka.ms/azure-diskcontrollertypes <https://aka.ms/azure-diskcontrollertypes>`_.
    """

    SCSI = "SCSI"
    """SCSI disk type"""
    NV_ME = "NVMe"
    """NVMe disk type"""


class DiskCreateOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies how the virtual machine should be created."""

    FROM_IMAGE = "FromImage"
    """This value is used when you are using an image to create the virtual machine.
    If you are using a platform image, you also use the imageReference element
    described above. If you are using a marketplace image, you also use the
    plan element previously described."""
    EMPTY = "Empty"
    """This value is used when creating an empty data disk."""
    ATTACH = "Attach"
    """This value is used when you are using a specialized disk to create the virtual machine."""
    COPY = "Copy"
    """This value is used to create a data disk from a snapshot or another disk."""
    RESTORE = "Restore"
    """This value is used to create a data disk from a disk restore point."""


class DiskDeleteOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the behavior of the managed disk when the VM gets deleted, for
    example whether the managed disk is deleted or detached. Supported values are:
    **Delete.** If this value is used, the managed disk is deleted when VM gets
    deleted. **Detach.** If this value is used, the managed disk is retained after
    VM gets deleted. Minimum api-version: 2021-03-01.
    """

    DELETE = "Delete"
    """If this value is used, the managed disk is deleted when VM gets deleted."""
    DETACH = "Detach"
    """If this value is used, the managed disk is retained after VM gets deleted."""


class DomainNameLabelScopeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Domain name label scope.The concatenation of the hashed domain name label
    that generated according to the policy from domain name label scope and vm
    index will be the domain name labels of the PublicIPAddress resources that will
    be created.
    """

    TENANT_REUSE = "TenantReuse"
    """TenantReuse type"""
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    """SubscriptionReuse type"""
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    """ResourceGroupReuse type"""
    NO_REUSE = "NoReuse"
    """NoReuse type"""


class EvictionPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Different kind of eviction policies."""

    DELETE = "Delete"
    """When evicted, the Spot VM will be deleted and the corresponding capacity will be updated to
    reflect this."""
    DEALLOCATE = "Deallocate"
    """When evicted, the Spot VM will be deallocated/stopped"""


class FleetMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Modes for Compute Fleet."""

    MANAGED = "Managed"
    """Default. Managed is the default mode for Compute Fleet where VMs are provisioned via VMSS."""
    INSTANCE = "Instance"
    """Instance mode for Compute Fleet will directly provision VM instances."""


class IPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available from Api-Version 2017-03-30 onwards, it represents whether the
    specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
    values are: 'IPv4' and 'IPv6'.
    """

    I_PV4 = "IPv4"
    """IPv4 version"""
    I_PV6 = "IPv6"
    """IPv6 version"""


class LinuxPatchAssessmentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
    machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You
    control the timing of patch assessments on a virtual machine. <br /><br />
    **AutomaticByPlatform** - The platform will trigger periodic patch assessments.
    The property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    """You control the timing of patch assessments on a virtual machine."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """The platform will trigger periodic patch assessments.The property provisionVMAgent must be
    true."""


class LinuxVMGuestPatchAutomaticByPlatformRebootSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the reboot setting for all AutomaticByPlatform patch installation
    operations.
    """

    UNKNOWN = "Unknown"
    """Unknown Reboot setting"""
    IF_REQUIRED = "IfRequired"
    """IfRequired Reboot setting"""
    NEVER = "Never"
    """Never Reboot setting"""
    ALWAYS = "Always"
    """Always Reboot setting"""


class LinuxVMGuestPatchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
    machines associated to virtual machine scale set with OrchestrationMode as
    Flexible.
    """

    IMAGE_DEFAULT = "ImageDefault"
    """The virtual machine's default patching configuration is used."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """The virtual machine will be automatically updated by the platform. The property
    provisionVMAgent must be true."""


class LocalStorageDiskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Different kind of Local storage disk types supported by Azure VMs."""

    HDD = "HDD"
    """HDD DiskType."""
    SSD = "SSD"
    """SDD DiskType."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Mode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode that ProxyAgent will execute on if the feature is enabled.
    ProxyAgent will start to audit or monitor but not enforce access control over
    requests to host endpoints in Audit mode, while in Enforce mode it will enforce
    access control. The default value is Enforce mode.
    """

    AUDIT = "Audit"
    """Audit Mode"""
    ENFORCE = "Enforce"
    """Enforce Mode"""


class NetworkApiVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """specifies the Microsoft.Network API version used when creating networking
    resources in the Network Interface Configurations for Virtual Machine Scale Set
    with orchestration mode 'Flexible'.
    """

    V2020_11_01 = "2020-11-01"
    """Initial version supported. Later versions are supported as well."""


class NetworkInterfaceAuxiliaryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the Auxiliary mode is enabled for the Network Interface
    resource.
    """

    NONE = "None"
    """None Mode"""
    ACCELERATED_CONNECTIONS = "AcceleratedConnections"
    """AcceleratedConnections Mode"""
    FLOATING = "Floating"
    """Floating Mode"""


class NetworkInterfaceAuxiliarySku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the Auxiliary sku is enabled for the Network Interface
    resource.
    """

    NONE = "None"
    """no sku"""
    A1 = "A1"
    """A1 sku"""
    A2 = "A2"
    """A2 sku"""
    A4 = "A4"
    """A4 sku"""
    A8 = "A8"
    """A8 sku"""


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the type of the OS that is included in the
    disk if creating a VM from user-image or a specialized VHD. Possible values
    are: **Windows,** **Linux.**.
    """

    WINDOWS = "Windows"
    """Windows OS type"""
    LINUX = "Linux"
    """Linux OS type"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProtocolTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the protocol of WinRM listener. Possible values are: **http,**
    **https.**.
    """

    HTTP = "Http"
    """Http protocol"""
    HTTPS = "Https"
    """Https protocol"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    """Initial creation in progress."""
    UPDATING = "Updating"
    """Update in progress."""
    DELETING = "Deleting"
    """Deletion in progress."""
    MIGRATING = "Migrating"
    """Resource is being migrated from one subscription or resource group to another."""


class PublicIPAddressSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify public IP sku name."""

    BASIC = "Basic"
    """Basic sku name"""
    STANDARD = "Standard"
    """Standard sku name"""


class PublicIPAddressSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify public IP sku tier."""

    REGIONAL = "Regional"
    """Regional sku tier"""
    GLOBAL = "Global"
    """Global sku tier"""


class RegularPriorityAllocationStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Regular VM Allocation strategy types for Compute Fleet."""

    LOWEST_PRICE = "LowestPrice"
    """Default. VM sizes distribution will be determined to optimize for price."""
    PRIORITIZED = "Prioritized"
    """VM sizes distribution will be determined to optimize for the 'priority' as specified for each
    vm size."""


class SecurityEncryptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the EncryptionType of the managed disk.
    **Note:** It can be set for only Confidential VMs.
    """

    VM_GUEST_STATE_ONLY = "VMGuestStateOnly"
    """EncryptionType of the managed disk is set to VMGuestStateOnly for encryption
    of just the VMGuestState blob."""
    DISK_WITH_VM_GUEST_STATE = "DiskWithVMGuestState"
    """EncryptionType of the managed disk is set to DiskWithVMGuestState for encryption
    of the managed disk along with VMGuestState blob."""
    NON_PERSISTED_TPM = "NonPersistedTPM"
    """EncryptionType of the managed disk is set to NonPersistedTPM for not persisting
    firmware state in the VMGuestState blob."""


class SecurityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the SecurityType of the virtual machine. It has to be set to any
    specified value to enable UefiSettings. The default behavior is: UefiSettings
    will not be enabled unless this property is set.
    """

    TRUSTED_LAUNCH = "TrustedLaunch"
    """TrustedLaunch security type"""
    CONFIDENTIAL_VM = "ConfidentialVM"
    """ConfidentialVM security type"""


class SettingNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the name of the setting to which the content applies. Possible values
    are: FirstLogonCommands and AutoLogon.
    """

    AUTO_LOGON = "AutoLogon"
    """AutoLogon setting"""
    FIRST_LOGON_COMMANDS = "FirstLogonCommands"
    """FirstLogonCommands setting"""


class SpotAllocationStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Spot allocation strategy types for Compute Fleet."""

    PRICE_CAPACITY_OPTIMIZED = "PriceCapacityOptimized"
    """Default. VM sizes distribution will be determined to optimize for both price and capacity."""
    LOWEST_PRICE = "LowestPrice"
    """VM sizes distribution will be determined to optimize for price. Note: Capacity will still be
    considered here but will be given much less weight."""
    CAPACITY_OPTIMIZED = "CapacityOptimized"
    """VM sizes distribution will be determined to optimize for capacity."""


class StorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type for the managed disk. Managed OS disk
    storage account type can only be set when you create the scale set. NOTE:
    UltraSSD_LRS can only be used with data disks. It cannot be used with OS Disk.
    Standard_LRS uses Standard HDD. StandardSSD_LRS uses Standard SSD. Premium_LRS
    uses Premium SSD. UltraSSD_LRS uses Ultra disk. Premium_ZRS uses Premium SSD
    zone redundant storage. StandardSSD_ZRS uses Standard SSD zone redundant
    storage. For more information regarding disks supported for Windows Virtual
    Machines, refer to
    `https://learn.microsoft.com/azure/virtual-machines/windows/disks-types
    <https://learn.microsoft.com/azure/virtual-machines/windows/disks-types>`_ and, for
    Linux Virtual Machines, refer to
    `https://learn.microsoft.com/azure/virtual-machines/linux/disks-types
    <https://learn.microsoft.com/azure/virtual-machines/linux/disks-types>`_.
    """

    STANDARD_LRS = "Standard_LRS"
    """Standard_LRS option."""
    PREMIUM_LRS = "Premium_LRS"
    """Premium_LRS option."""
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    """StandardSSD_LRS option."""
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    """UltraSSD_LRS option."""
    PREMIUM_ZRS = "Premium_ZRS"
    """Premium_ZRS option."""
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    """StandardSSD_ZRS option."""
    PREMIUM_V2_LRS = "PremiumV2_LRS"
    """PremiumV2_LRS option."""


class VMAttributeSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VMSizes supported by Azure VMs. Included is a union of Excluded and Required."""

    EXCLUDED = "Excluded"
    """All VMSizes having the feature support will be excluded."""
    INCLUDED = "Included"
    """ VMSizes that have the feature support and that do not have the feature support will be used.
    Included is a union of Excluded and Required."""
    REQUIRED = "Required"
    """Only the VMSizes having the feature support will be used."""


class VMCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VMCategories defined for Azure VMs.
    See:
    `https://learn.microsoft.com/en-us/azure/virtual-machines/sizes/overview?tabs=breakdownseries%2Cgeneralsizelist%2Ccomputesizelist%2Cmemorysizelist%2Cstoragesizelist%2Cgpusizelist%2Cfpgasizelist%2Chpcsizelist#general-purpose
    <https://learn.microsoft.com/en-us/azure/virtual-machines/sizes/overview?tabs=breakdownseries%2Cgeneralsizelist%2Ccomputesizelist%2Cmemorysizelist%2Cstoragesizelist%2Cgpusizelist%2Cfpgasizelist%2Chpcsizelist#general-purpose>`_.
    """

    GENERAL_PURPOSE = "GeneralPurpose"
    """General purpose VM sizes provide balanced CPU-to-memory ratio. Ideal for testing and
    development, small to medium databases, and low to medium traffic web servers."""
    COMPUTE_OPTIMIZED = "ComputeOptimized"
    """Compute optimized VM sizes have a high CPU-to-memory ratio. These sizes are good for medium
    traffic web servers, network appliances, batch processes, and application servers."""
    MEMORY_OPTIMIZED = "MemoryOptimized"
    """Memory optimized VM sizes offer a high memory-to-CPU ratio that is great for relational
    database servers, medium to large caches, and in-memory analytics."""
    STORAGE_OPTIMIZED = "StorageOptimized"
    """Storage optimized virtual machine (VM) sizes offer high disk throughput and IO, and are ideal
    for Big Data, SQL, NoSQL databases, data warehousing, and large transactional databases.
    Examples include Cassandra, MongoDB, Cloudera, and Redis."""
    GPU_ACCELERATED = "GpuAccelerated"
    """GPU optimized VM sizes are specialized virtual machines available with single, multiple, or
    fractional GPUs.
    These sizes are designed for compute-intensive, graphics-intensive, and visualization
    workloads."""
    FPGA_ACCELERATED = "FpgaAccelerated"
    """FPGA optimized VM sizes are specialized virtual machines available with single or multiple
    FPGA.
    These sizes are designed for compute-intensive workloads. This article provides information
    about the number and type of FPGA, vCPUs, data disks, and NICs.
    Storage throughput and network bandwidth are also included for each size in this grouping."""
    HIGH_PERFORMANCE_COMPUTE = "HighPerformanceCompute"
    """Azure High Performance Compute VMs are optimized for various HPC workloads such as
    computational fluid dynamics, finite element analysis, frontend and backend EDA,
    rendering, molecular dynamics, computational geo science, weather simulation, and financial
    risk analysis."""


class VMOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Virtual Machine operation status values."""

    CREATING = "Creating"
    """Indicates that the virtual machine is either in the process of being created or is scheduled to
    be created."""
    CANCELED = "Canceled"
    """Indicates that the cancellation request was successful because the virtual machine had not been
    created yet."""
    CANCEL_FAILED_STATUS_UNKNOWN = "CancelFailedStatusUnknown"
    """Indicates that the cancellation request could not be applied because the virtual machine had
    already been created."""
    FAILED = "Failed"
    """Indicates that the virtual machine operation failed."""
    SUCCEEDED = "Succeeded"
    """Indicates that the virtual machine operation completed successfully."""


class WindowsPatchAssessmentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest patch assessment for the IaaS virtual machine."""

    IMAGE_DEFAULT = "ImageDefault"
    """You control the timing of patch assessments on a virtual machine."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """The platform will trigger periodic patch assessments. The property provisionVMAgent must be
    true."""


class WindowsVMGuestPatchAutomaticByPlatformRebootSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations."""

    UNKNOWN = "Unknown"
    """Unknown Reboot setting"""
    IF_REQUIRED = "IfRequired"
    """IfRequired Reboot setting"""
    NEVER = "Never"
    """Never Reboot setting"""
    ALWAYS = "Always"
    """Always Reboot setting"""


class WindowsVMGuestPatchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
    machines associated to virtual machine scale set with OrchestrationMode as
    Flexible.
    """

    MANUAL = "Manual"
    """You control the application of patches to a virtual machine.
    You do this by applying patches manually inside the VM. In this mode,
    automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates
    must be false"""
    AUTOMATIC_BY_OS = "AutomaticByOS"
    """The virtual machine will automatically be updated by the OS.
    The property WindowsConfiguration.enableAutomaticUpdates must be true."""
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    """The virtual machine will automatically updated by the platform. The properties
    provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true."""


class ZoneDistributionStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Distribution strategies for Compute Fleet zone allocation policy."""

    BEST_EFFORT_SINGLE_ZONE = "BestEffortSingleZone"
    """Default. Compute Fleet allocates all Fleet capacity within a single zone based on best effort.
    If capacity is not available, Compute Fleet can allocate capacity in different zones."""
    PRIORITIZED = "Prioritized"
    """Compute Fleet allocates capacity based on zone preferences.
    Higher priority zones are filled first before allocating to lower priority zones."""
