# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.conversations.v1.configuration.webhook import WebhookList


class ConfigurationList(ListResource):

    def __init__(self, version):
        """
        Initialize the ConfigurationList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationList
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationList
        """
        super(ConfigurationList, self).__init__(version)

        # Path Solution
        self._solution = {}

        # Components
        self._webhooks = None

    @property
    def webhooks(self):
        """
        Access the webhooks

        :returns: twilio.rest.conversations.v1.configuration.webhook.WebhookList
        :rtype: twilio.rest.conversations.v1.configuration.webhook.WebhookList
        """
        if self._webhooks is None:
            self._webhooks = WebhookList(self._version, )
        return self._webhooks

    def get(self):
        """
        Constructs a ConfigurationContext

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationContext
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationContext
        """
        return ConfigurationContext(self._version, )

    def __call__(self):
        """
        Constructs a ConfigurationContext

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationContext
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationContext
        """
        return ConfigurationContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ConfigurationList>'


class ConfigurationPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the ConfigurationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationPage
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationPage
        """
        super(ConfigurationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ConfigurationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        """
        return ConfigurationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ConfigurationPage>'


class ConfigurationContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the ConfigurationContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationContext
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationContext
        """
        super(ConfigurationContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Configuration'.format(**self._solution)

    def fetch(self):
        """
        Fetch the ConfigurationInstance

        :returns: The fetched ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ConfigurationInstance(self._version, payload, )

    def update(self, default_chat_service_sid=values.unset,
               default_messaging_service_sid=values.unset,
               default_inactive_timer=values.unset,
               default_closed_timer=values.unset):
        """
        Update the ConfigurationInstance

        :param unicode default_chat_service_sid: The SID of the default Conversation Service that every new conversation will be associated with.
        :param unicode default_messaging_service_sid: The SID of the default Messaging Service that every new conversation will be associated with.
        :param unicode default_inactive_timer: Default ISO8601 duration when conversation will be switched to `inactive` state.
        :param unicode default_closed_timer: Default ISO8601 duration when conversation will be switched to `closed` state.

        :returns: The updated ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        """
        data = values.of({
            'DefaultChatServiceSid': default_chat_service_sid,
            'DefaultMessagingServiceSid': default_messaging_service_sid,
            'DefaultInactiveTimer': default_inactive_timer,
            'DefaultClosedTimer': default_closed_timer,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return ConfigurationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.ConfigurationContext {}>'.format(context)


class ConfigurationInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the ConfigurationInstance

        :returns: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        """
        super(ConfigurationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'default_chat_service_sid': payload.get('default_chat_service_sid'),
            'default_messaging_service_sid': payload.get('default_messaging_service_sid'),
            'default_inactive_timer': payload.get('default_inactive_timer'),
            'default_closed_timer': payload.get('default_closed_timer'),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ConfigurationContext for this ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationContext
        """
        if self._context is None:
            self._context = ConfigurationContext(self._version, )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account responsible for this configuration.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def default_chat_service_sid(self):
        """
        :returns: The SID of the default Conversation Service that every new conversation is associated with.
        :rtype: unicode
        """
        return self._properties['default_chat_service_sid']

    @property
    def default_messaging_service_sid(self):
        """
        :returns: The SID of the default Messaging Service that every new conversation is associated with.
        :rtype: unicode
        """
        return self._properties['default_messaging_service_sid']

    @property
    def default_inactive_timer(self):
        """
        :returns: Default ISO8601 duration when conversation will be switched to `inactive` state.
        :rtype: unicode
        """
        return self._properties['default_inactive_timer']

    @property
    def default_closed_timer(self):
        """
        :returns: Default ISO8601 duration when conversation will be switched to `closed` state.
        :rtype: unicode
        """
        return self._properties['default_closed_timer']

    @property
    def url(self):
        """
        :returns: An absolute URL for this global configuration.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: Absolute URLs to access the webhook and default service configurations.
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the ConfigurationInstance

        :returns: The fetched ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        """
        return self._proxy.fetch()

    def update(self, default_chat_service_sid=values.unset,
               default_messaging_service_sid=values.unset,
               default_inactive_timer=values.unset,
               default_closed_timer=values.unset):
        """
        Update the ConfigurationInstance

        :param unicode default_chat_service_sid: The SID of the default Conversation Service that every new conversation will be associated with.
        :param unicode default_messaging_service_sid: The SID of the default Messaging Service that every new conversation will be associated with.
        :param unicode default_inactive_timer: Default ISO8601 duration when conversation will be switched to `inactive` state.
        :param unicode default_closed_timer: Default ISO8601 duration when conversation will be switched to `closed` state.

        :returns: The updated ConfigurationInstance
        :rtype: twilio.rest.conversations.v1.configuration.ConfigurationInstance
        """
        return self._proxy.update(
            default_chat_service_sid=default_chat_service_sid,
            default_messaging_service_sid=default_messaging_service_sid,
            default_inactive_timer=default_inactive_timer,
            default_closed_timer=default_closed_timer,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.ConfigurationInstance {}>'.format(context)
