% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareMOFA.R
\name{getDefaultModelOptions}
\alias{getDefaultModelOptions}
\title{Get default model options}
\usage{
getDefaultModelOptions(object)
}
\arguments{
\item{object}{an untrained \code{\link{MOFAmodel}} object}
}
\value{
Returns a list with the default model options, which have to be passed as
 an argument to \code{\link{prepareMOFA}}
}
\description{
Function to obtain the default model options.
}
\details{
The model options are the following: \cr
\itemize{
 \item{\strong{likelihood}:}{ character vector with data likelihoods per view: 
 'gaussian' for continuous data, 'bernoulli' for binary data and 'poisson' for count data.
 By default, they are guessed internally.}
 \item{\strong{numFactors}:}{ numeric value indicating the initial number of factors. 
 If you want to learn the number of factors automatically we recommend
  setting this to a large value, default is 25.}
 \item{\strong{sparsity}:}{ logical indicating whether to use sparsity.
 This is always recommended, as it will make the loadings more interpretable. Default is TRUE.}
}
}
\examples{
# load data
data("CLL_data", package = "MOFAdata")
#create a MOFAmodel object
MOFAobject <- createMOFAobject(CLL_data)
# set model options
ModelOptions <- getDefaultModelOptions(MOFAobject)
ModelOptions
}
