% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writer.R
\name{file_writer}
\alias{file_writer}
\title{File Writer}
\usage{
file_writer(path)
}
\arguments{
\item{path}{file name or path on disk}
}
\value{
Function with signature \code{writer(data = raw(), close = FALSE)}
}
\description{
Generates a closure that writes binary (raw) data to a file.
}
\details{
The writer function automatically opens the file on the first write and closes when
it goes out of scope, or explicitly by setting \code{close = TRUE}. This can be used
for the \code{data} callback in \code{multi_add()} or \code{curl_fetch_multi()}.
}
\examples{
# Doesn't open yet
tmp <- tempfile()
writer <- file_writer(tmp)

# Now it opens
writer(charToRaw("Hello!\n"))
writer(charToRaw("How are you?\n"))

# Close it!
writer(charToRaw("All done!\n"), close = TRUE)

# Check it worked
readLines(tmp)
}
