% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-helpers.R
\name{group_cols}
\alias{group_cols}
\title{Select grouping variables}
\usage{
group_cols(vars = NULL, data = NULL)
}
\arguments{
\item{vars}{Deprecated; please use data instead.}

\item{data}{For advanced use only. The default \code{NULL} automatically
finds the "current" data frames.}
}
\description{
This selection helpers matches grouping variables. It can be used
in \code{\link[=select]{select()}} or \code{\link[=vars]{vars()}} selections.
}
\examples{
gdf <- iris \%>\% group_by(Species)
gdf \%>\% select(group_cols())

# Remove the grouping variables from mutate selections:
gdf \%>\% mutate_at(vars(-group_cols()), `/`, 100)
# -> No longer necessary with across()
gdf \%>\% mutate(across(everything(), ~ . / 100))
}
\seealso{
\code{\link[=groups]{groups()}} and \code{\link[=group_vars]{group_vars()}} for retrieving the grouping
variables outside selection contexts.
}
