% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{coalesce}
\alias{coalesce}
\title{Find the first non-missing element}
\usage{
coalesce(..., .ptype = NULL, .size = NULL)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>

One or more vectors. These will be
\link[vctrs:theory-faq-recycling]{recycled} against each other, and will be
cast to their common type.}

\item{.ptype}{An optional prototype declaring the desired output type. If
supplied, this overrides the common type of the vectors in \code{...}.}

\item{.size}{An optional size declaring the desired output size. If supplied,
this overrides the common size of the vectors in \code{...}.}
}
\value{
A vector with the same type and size as the common type and common
size of the vectors in \code{...}.
}
\description{
Given a set of vectors, \code{coalesce()} finds the first non-missing value at
each position. It's inspired by the SQL \code{COALESCE} function which does the
same thing for SQL \code{NULL}s.
}
\examples{
# Replace missing values with a single value
x <- sample(c(1:5, NA, NA, NA))
coalesce(x, 0L)

# Or replace missing values with the corresponding non-missing value in
# another vector
x <- c(1, 2, NA, NA, 5, NA)
y <- c(NA, NA, 3, 4, 5, NA)
coalesce(x, y)

# For cases like these where your replacement is a single value or a single
# vector, `replace_values()` works just as well
replace_values(x, NA ~ 0)
coalesce(x, 0)

replace_values(x, NA ~ y)
coalesce(x, y)

# `coalesce()` really shines when you have >2 vectors to coalesce with
z <- c(NA, 2, 3, 4, 5, 6)
coalesce(x, y, z)

# If you're looking to replace values with `NA`, rather than replacing `NA`
# with a value, then use `replace_values()`
x <- c(0, -1, 5, -99, 8)
replace_values(x, c(-1, -99) ~ NA)

# The equivalent to a missing value in a list is `NULL`
coalesce(list(1, 2, NULL, NA), list(0))

# Supply lists of vectors by splicing them into dots
vecs <- list(
  c(1, 2, NA, NA, 5),
  c(NA, NA, 3, 4, 5)
)
coalesce(!!!vecs)
}
\seealso{
\itemize{
\item \code{\link[=na_if]{na_if()}} to replace a specified value with \code{NA}.
\item \code{\link[=replace_values]{replace_values()}} for making arbitrary replacements by value.
\item \code{\link[=replace_when]{replace_when()}} for making arbitrary replacements using logical
conditions.
}
}
