% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.glmfm.R
\name{plot.glmfm}
\alias{plot.glmfm}
\title{Comparison Diagnostic Plots for Generalized Linear Models}
\usage{
\method{plot}{glmfm}(x, which.plots = 1:6, ...)
}
\arguments{
\item{x}{a \code{glmfm} object.}

\item{which.plots}{either \code{"ask"} (character string) or an integer
vector specifying which plots to draw. In the later case, the plot numbers
are given above.}

\item{\dots}{other parameters to be passed through to plotting functions.}
}
\value{
\code{x} is invisibly returned.
}
\description{
Produces a set of comparison diagnostic plots.  The plot options are
\enumerate{
  \item Deviance Residuals vs. Predicted Values,
  \item Response vs. Fitted Values,
  \item Normal QQ Plot of Pearson Residuals,
  \item Normal QQ Plot of Deviance Residuals,
  \item Pearson Residuals vs. Mahalanobis Distance,
  \item Sqrt Deviance Residuals vs. Predicted Values.
}
}
\section{Side Effects}{
 The selected plots are drawn on a graphics device.
}

\examples{
# From ?glm:
# A Gamma example, from McCullagh & Nelder (1989, pp. 300-2)

clotting <- data.frame(
    u = c(5,10,15,20,30,40,60,80,100),
    lot1 = c(118,58,42,35,27,25,21,19,18),
    lot2 = c(69,35,26,21,18,16,13,12,12))

lot1 <- glm(lot1 ~ log(u), data = clotting, family = Gamma)
lot2 <- glm(lot2 ~ log(u), data = clotting, family = Gamma)

fm <- fit.models(lot1, lot2)
plot(fm)

}
\seealso{
\code{\link{sideBySideQQPlot}} for 4 and 5 and
\code{\link{sideBySideScatterPlot}} for the others.
}
\keyword{hplot}
\keyword{methods}
