% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_aes.R
\name{create_aes}
\alias{create_aes}
\title{Create Aes Mapping from a List}
\usage{
create_aes(.list, parse = FALSE)
}
\arguments{
\item{.list}{a list of aesthetic arguments; for example .list = list(x = "dose", y = "len", color = "dose").}

\item{parse}{logical. If TRUE, parse the input as an expression.}
}
\description{
Create aes mapping to make programming easy with ggplot2.
}
\examples{
# Simple aes creation
create_aes(list(x = "Sepal.Length", y = "Petal.Length" ))

# Parse an expression
x <- "log2(Sepal.Length)"
y <- "log2(Petal.Length)"
create_aes(list(x = x, y = y ), parse = TRUE)

# Create a ggplot
mapping <- create_aes(list(x = x, y = y ), parse = TRUE)
ggplot(iris, mapping) +
 geom_point()

}
