% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{formatter_logging}
\alias{formatter_logging}
\title{Mimic the default formatter used in the \pkg{logging} package}
\usage{
formatter_logging(
  ...,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{...}{string and further params passed to \code{sprintf} or R
expressions to be evaluated}

\item{.logcall}{the logging call being evaluated (useful in
formatters and layouts when you want to have access to the raw,
unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was
called (useful in formatters and layouts to extract the calling
function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function
where the formatter function will be evaluated and that is used
to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
character vector
}
\description{
The \pkg{logging} package uses a formatter that behaves differently
when the input is a string or other R object. If the first argument
is a string, then \code{\link[=sprintf]{sprintf()}} is being called -- otherwise it does
something like \code{\link[=log_eval]{log_eval()}} and logs the R expression(s) and the
result(s) as well.
}
\examples{
\dontshow{old <- logger:::namespaces_set()}
log_formatter(formatter_logging)
log_info("42")
log_info(42)
log_info(4 + 2)
log_info("foo \%s", "bar")
log_info("vector \%s", 1:3)
log_info(12, 1 + 1, 2 * 2)
\dontshow{logger:::namespaces_set(old)}
}
\seealso{
Other log_formatters: 
\code{\link{formatter_glue}()},
\code{\link{formatter_glue_or_sprintf}()},
\code{\link{formatter_glue_safe}()},
\code{\link{formatter_json}()},
\code{\link{formatter_pander}()},
\code{\link{formatter_paste}()},
\code{\link{formatter_sprintf}()}
}
\concept{log_formatters}
