/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Point;
import java.util.Arrays;
import java.util.Random;

public class VarPairData {
    public Point[] data;
    public float minX;
    public float maxX;
    public float minY;
    public float maxY;
    public String xVarName;
    public String yVarName;

    public VarPairData(float[] x, float[] y) throws IllegalArgumentException {
        this(x, y, "", "");
    }

    public VarPairData(float[] x, float[] y, String xVarName_, String yVarName_) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x[] and y[] must have the same length");
        }
        this.xVarName = xVarName_;
        this.yVarName = yVarName_;
        int numInCommon = 0;
        int i = 0;
        while (i < x.length) {
            if (!Float.isNaN(x[i]) && !Float.isNaN(y[i])) {
                ++numInCommon;
            }
            ++i;
        }
        this.data = new Point[numInCommon];
        this.minX = Float.MAX_VALUE;
        this.maxX = -3.4028235E38f;
        this.minY = Float.MAX_VALUE;
        this.maxY = -3.4028235E38f;
        i = 0;
        int numAdded = 0;
        while (i < x.length) {
            if (!Float.isNaN(x[i]) && !Float.isNaN(y[i])) {
                this.data[numAdded] = new Point(x[i], y[i]);
                if (this.data[numAdded].y < this.minY) {
                    this.minY = this.data[numAdded].y;
                }
                if (this.data[numAdded].y > this.maxY) {
                    this.maxY = this.data[numAdded].y;
                }
                if (this.data[numAdded].x < this.minX) {
                    this.minX = this.data[numAdded].x;
                }
                if (this.data[numAdded].x > this.maxX) {
                    this.maxX = this.data[numAdded].x;
                }
                ++numAdded;
            }
            ++i;
        }
    }

    public VarPairData(VarPairData vp, boolean switchXandY) {
        this.data = new Point[vp.data.length];
        int i = 0;
        while (i < vp.data.length) {
            this.data[i] = !switchXandY ? vp.data[i] : new Point(vp.data[i].y, vp.data[i].x);
            ++i;
        }
        if (!switchXandY) {
            this.minX = vp.minX;
            this.maxX = vp.maxX;
            this.minY = vp.minY;
            this.maxY = vp.maxY;
        } else {
            this.minX = vp.minY;
            this.maxX = vp.maxY;
            this.minY = vp.minX;
            this.maxY = vp.maxX;
        }
        this.xVarName = vp.xVarName;
        this.yVarName = vp.yVarName;
    }

    public VarPairData(VarPairData vp) {
        this(vp, false);
    }

    public int sampleSize() {
        return this.data.length;
    }

    public void sortByX() {
        Arrays.sort(this.data, Point.orderByX);
    }

    public void sortByY() {
        Arrays.sort(this.data, Point.orderByY);
    }

    public float[] getXs() {
        float[] rVal = new float[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            rVal[i] = this.data[i].x;
            ++i;
        }
        return rVal;
    }

    public float[] getYs() {
        float[] rVal = new float[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            rVal[i] = this.data[i].y;
            ++i;
        }
        return rVal;
    }

    public void addNoise(float xNoise, float yNoise) {
        Random r = new Random();
        int i = 0;
        while (i < this.data.length) {
            this.data[i].x = (float)((double)this.data[i].x + (double)xNoise * ((double)r.nextFloat() - 0.5));
            this.data[i].y = (float)((double)this.data[i].y + (double)yNoise * ((double)r.nextFloat() - 0.5));
            ++i;
        }
    }

    public float fourierCoefficientY(int repeats, int numSamples) {
        float real = 0.0f;
        float im = 0.0f;
        float w = (float)(Math.PI * 2 * (double)repeats / (double)numSamples);
        int t = 1;
        while (t <= numSamples) {
            real = (float)((double)real + (double)this.data[t - 1].y * Math.cos(w * (float)t));
            im = (float)((double)im + (double)this.data[t - 1].y * Math.sin(w * (float)t));
            ++t;
        }
        return (float)Math.sqrt(im * im + real * real);
    }

    public float FisherTest(int[] foundAt) {
        float maxCoeff = -3.4028235E38f;
        float partialSum = 0.0f;
        int k = 1;
        while (k <= (this.data.length - 1) / 2) {
            float I = this.fourierCoefficientY(k, this.data.length);
            partialSum += I;
            if (I > maxCoeff) {
                maxCoeff = I;
                foundAt[0] = k;
            }
            ++k;
        }
        return maxCoeff / partialSum;
    }

    public float pearsonCorrelation() {
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = this.data[0].x;
        double mean_y = this.data[0].y;
        int i = 1;
        while (i < this.data.length) {
            double sweep = ((double)i + 1.0 - 1.0) / (double)(i + 1);
            double delta_x = (double)this.data[i].x - mean_x;
            double delta_y = (double)this.data[i].y - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)(i + 1);
            mean_y += delta_y / (double)(i + 1);
            ++i;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)this.data.length);
        double pop_sd_y = Math.sqrt(sum_sq_y / (double)this.data.length);
        double cov_x_y = sum_coproduct / (double)this.data.length;
        return (float)cov_x_y / (float)(pop_sd_x * pop_sd_y);
    }

    public float spearmanCorrelation() {
        int j;
        Point[] ranks = Arrays.copyOf(this.data, this.data.length);
        Arrays.sort(ranks, Point.orderByX);
        int duplicates = 0;
        int i = 0;
        while (i < ranks.length) {
            if (i + 1 < ranks.length && ranks[i + 1].x == ranks[i].x) {
                ++duplicates;
            } else {
                if (duplicates > 0) {
                    j = i - duplicates;
                    while (j <= i) {
                        ranks[j].x = ((float)i + ((float)i - (float)duplicates)) / 2.0f;
                        ++j;
                    }
                } else {
                    ranks[i].x = i;
                }
                duplicates = 0;
            }
            ++i;
        }
        Arrays.sort(ranks, Point.orderByY);
        i = 0;
        while (i < ranks.length) {
            ranks[i].y = i;
            ++i;
        }
        duplicates = 0;
        i = 0;
        while (i < ranks.length) {
            if (i + 1 < ranks.length && ranks[i + 1].y == ranks[i].y) {
                ++duplicates;
            } else {
                if (duplicates > 0) {
                    j = i - duplicates;
                    while (j <= i) {
                        ranks[j].y = ((float)i + ((float)i - (float)duplicates)) / 2.0f;
                        ++j;
                    }
                } else {
                    ranks[i].y = i;
                }
                duplicates = 0;
            }
            ++i;
        }
        float sum_sq_x = 0.0f;
        float sum_sq_y = 0.0f;
        float sum_coproduct = 0.0f;
        float mean_x = ranks[0].x;
        float mean_y = ranks[0].y;
        int i2 = 1;
        while (i2 < ranks.length) {
            float sweep = ((float)i2 + 1.0f - 1.0f) / (float)(i2 + 1);
            float delta_x = ranks[i2].x - mean_x;
            float delta_y = ranks[i2].y - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (float)(i2 + 1);
            mean_y += delta_y / (float)(i2 + 1);
            ++i2;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (float)ranks.length);
        double pop_sd_y = Math.sqrt(sum_sq_y / (float)ranks.length);
        float cov_x_y = sum_coproduct / (float)ranks.length;
        return cov_x_y / (float)(pop_sd_x * pop_sd_y);
    }

    public float mutualInfoKDE(float smoothing) {
        float total = 0.0f;
        int i = 0;
        while (i < this.data.length) {
            total = (float)((double)total + Math.log(this.kernelDensityEstimatorXY(smoothing, this.data[i].x, this.data[i].y) / (this.kernelDensityEstimatorX(smoothing, this.data[i].x) * this.kernelDensityEstimatorY(smoothing, this.data[i].y))));
            ++i;
        }
        return total /= (float)this.data.length;
    }

    private float kernelDensityEstimatorY(float smoothing, float y) {
        float total = 0.0f;
        int i = 0;
        while (i < this.data.length) {
            total = (float)((double)total + Math.exp(-1.0f * (this.data[i].y - y) * (this.data[i].y - y) / (2.0f * smoothing * smoothing)));
            ++i;
        }
        total /= smoothing;
        total = (float)((double)total / Math.sqrt(Math.PI * 2));
        return total /= (float)this.data.length;
    }

    private float kernelDensityEstimatorX(float smoothing, float x) {
        float total = 0.0f;
        int i = 0;
        while (i < this.data.length) {
            total = (float)((double)total + Math.exp(-1.0f * (this.data[i].x - x) * (this.data[i].x - x) / (2.0f * smoothing * smoothing)));
            ++i;
        }
        total /= smoothing;
        total = (float)((double)total / Math.sqrt(Math.PI * 2));
        return total /= (float)this.data.length;
    }

    private float kernelDensityEstimatorXY(float smoothing, float x, float y) {
        float total = 0.0f;
        int i = 0;
        while (i < this.data.length) {
            float distanceSquared = (this.data[i].y - y) * (this.data[i].y - y) + (this.data[i].x - x) * (this.data[i].x - x);
            total = (float)((double)total + Math.exp(-1.0f * distanceSquared / (2.0f * smoothing * smoothing)));
            ++i;
        }
        total /= smoothing * smoothing;
        total = (float)((double)total / (Math.PI * 2));
        return total /= (float)this.data.length;
    }
}

