% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cstats}
\alias{cstats}
\title{Compute statistics (MIC and normalized TIC) between each pair of the two
collections of variables (convenience function).
If n and m are the number of variables in X and Y respectively, then the
  statistic between the (row) i (for X) and j (for Y) is stored in \code{mic[i, j]}
and \code{tic[i, j]}.}
\usage{
cstats(x, y, alpha = 0.6, C = 15, est = "mic_approx")
}
\arguments{
\item{x}{Numeric Matrix of m-by-n with n variables and m samples.}

\item{y}{Numeric Matrix of m-by-p with p variables and m samples.}

\item{alpha}{number (0, 1.0] or >=4 if alpha is in (0,1] then B will be max(n^alpha, 4) where n is the
number of samples. If alpha is >=4 then alpha defines directly the B
parameter. If alpha is higher than the number of samples (n) it will be
limited to be n, so B = min(alpha, n).}

\item{C}{number (> 0) determines how many more clumps there will be than columns in
every partition. Default value is 15, meaning that when trying to
draw x grid lines on the x-axis, the algorithm will start with at
most 15*x clumps.}

\item{est}{string ("mic_approx", "mic_e") estimator. 
With est="mic_approx" the original MINE statistics will
be computed, with est="mic_e" the equicharacteristic matrix is
is evaluated and MIC_e and TIC_e are returned.}
}
\value{
list of two elements:
MIC: the MIC statistic matrix (n x p).
TIC: the normalized TIC statistic matrix (n x p).
}
\description{
Compute statistics (MIC and normalized TIC) between each pair of the two
collections of variables (convenience function).
If n and m are the number of variables in X and Y respectively, then the
  statistic between the (row) i (for X) and j (for Y) is stored in \code{mic[i, j]}
and \code{tic[i, j]}.
}
\examples{
x <- matrix(rnorm(2560), ncol=8, nrow=320)
y <- matrix(rnorm(1280), ncol=4, nrow=320)

mictic <- cstats(x, y, alpha=9, C=5, est="mic_e")
head(mictic)

}
