% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{fn_body}
\alias{fn_body}
\alias{fn_body<-}
\title{Get or set function body}
\usage{
fn_body(fn = caller_fn())

fn_body(fn) <- value
}
\arguments{
\item{fn}{A function. It is lookep up in the calling frame if not
supplied.}

\item{value}{New formals or formals names for \code{fn}.}
}
\description{
\code{fn_body()} is a simple wrapper around \code{\link[base:body]{base::body()}}. It always
returns a \verb{\\\{} expression and throws an error when the input is a
primitive function (whereas \code{body()} returns \code{NULL}). The setter
version preserves attributes, unlike \verb{body<-}.
}
\examples{
# fn_body() is like body() but always returns a block:
fn <- function() do()
body(fn)
fn_body(fn)

# It also throws an error when used on a primitive function:
try(fn_body(base::list))
}
