% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/differential_expression.R
\name{FoldChange}
\alias{FoldChange}
\alias{FoldChange.default}
\alias{FoldChange.Assay}
\alias{FoldChange.SCTAssay}
\alias{FoldChange.DimReduc}
\alias{FoldChange.Seurat}
\title{Fold Change}
\usage{
FoldChange(object, ...)

\method{FoldChange}{default}(object, cells.1, cells.2, mean.fxn, fc.name, features = NULL, ...)

\method{FoldChange}{Assay}(
  object,
  cells.1,
  cells.2,
  features = NULL,
  slot = "data",
  pseudocount.use = 1,
  fc.name = NULL,
  mean.fxn = NULL,
  base = 2,
  norm.method = NULL,
  ...
)

\method{FoldChange}{SCTAssay}(
  object,
  cells.1,
  cells.2,
  features = NULL,
  slot = "data",
  pseudocount.use = 1,
  fc.name = NULL,
  mean.fxn = NULL,
  base = 2,
  ...
)

\method{FoldChange}{DimReduc}(
  object,
  cells.1,
  cells.2,
  features = NULL,
  slot = NULL,
  pseudocount.use = 1,
  fc.name = NULL,
  mean.fxn = NULL,
  ...
)

\method{FoldChange}{Seurat}(
  object,
  ident.1 = NULL,
  ident.2 = NULL,
  group.by = NULL,
  subset.ident = NULL,
  assay = NULL,
  slot = "data",
  reduction = NULL,
  features = NULL,
  pseudocount.use = 1,
  mean.fxn = NULL,
  base = 2,
  fc.name = NULL,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{cells.1}{Vector of cell names belonging to group 1}

\item{cells.2}{Vector of cell names belonging to group 2}

\item{mean.fxn}{Function to use for fold change or average difference calculation}

\item{fc.name}{Name of the fold change, average difference, or custom function column
in the output data.frame}

\item{features}{Features to calculate fold change for.
If NULL, use all features}

\item{slot}{Slot to pull data from}

\item{pseudocount.use}{Pseudocount to add to averaged expression values when
calculating logFC.}

\item{base}{The base with respect to which logarithms are computed.}

\item{norm.method}{Normalization method for mean function selection
when \code{slot} is \dQuote{\code{data}}}

\item{ident.1}{Identity class to calculate fold change for; pass an object of class
\code{phylo} or 'clustertree' to calculate fold change for a node in a cluster tree;
passing 'clustertree' requires \code{\link{BuildClusterTree}} to have been run}

\item{ident.2}{A second identity class for comparison; if \code{NULL},
use all other cells for comparison; if an object of class \code{phylo} or
'clustertree' is passed to \code{ident.1}, must pass a node to calculate fold change for}

\item{group.by}{Regroup cells into a different identity class prior to
calculating fold change (see example in \code{\link{FindMarkers}})}

\item{subset.ident}{Subset a particular identity class prior to regrouping.
Only relevant if group.by is set (see example in \code{\link{FindMarkers}})}

\item{assay}{Assay to use in fold change calculation}

\item{reduction}{Reduction to use - will calculate average difference on cell embeddings}
}
\value{
Returns a data.frame
}
\description{
Calculate log fold change and percentage of cells expressing each feature
for different identity classes.
}
\details{
If the slot is \code{scale.data} or a reduction is specified, average difference
is returned instead of log fold change and the column is named "avg_diff".
Otherwise, log2 fold change is returned with column named "avg_log2_FC".
}
\examples{
\dontrun{
data("pbmc_small")
FoldChange(pbmc_small, ident.1 = 1)
}

}
\seealso{
\code{FindMarkers}
}
\concept{differential_expression}
