% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_survdiff.R
\name{pairwise_survdiff}
\alias{pairwise_survdiff}
\title{Multiple Comparisons of Survival Curves}
\usage{
pairwise_survdiff(formula, data, p.adjust.method = "BH", na.action, rho = 0)
}
\arguments{
\item{formula}{a formula expression as for other survival models, of the form
Surv(time, status) ~ predictors.}

\item{data}{a data frame in which to interpret the variables occurring in the
formula.}

\item{p.adjust.method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}). Allowed values include "holm", "hochberg",
"hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't want to
adjust the p value (not recommended), use p.adjust.method = "none".}

\item{na.action}{a missing-data filter function. Default is
options()$na.action.}

\item{rho}{a scalar parameter that controls the type of test. Allowed values
include 0 (for Log-Rank test) and 1 (for peto & peto test).}
}
\value{
Returns an object of class "pairwise.htest", which is a list
 containing the p values.
}
\description{
Calculate pairwise comparisons between group levels with
 corrections for multiple testing.
}
\examples{

library(survival)
library(survminer)
data(myeloma)

# Pairwise survdiff
res <- pairwise_survdiff(Surv(time, event) ~ molecular_group,
     data = myeloma)
res

# Symbolic number coding
symnum(res$p.value, cutpoints = c(0, 0.0001, 0.001, 0.01, 0.05, 0.1, 1),
   symbols = c("****", "***", "**", "*", "+", " "),
   abbr.colnames = FALSE, na = "")


}
\seealso{
survival::survdiff
}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
