/*	png.h
	Copyright (C) 2004-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/

#include <gtk/gtk.h>


//	Loading/Saving errors

#define NOT_INDEXED -10
#define TOO_BIG -11
#define NOT_JPEG -13
#define NOT_TIFF -15
#define NOT_GIF -16

#define FILE_LIB_ERROR 123456
#define FILE_MEM_ERROR 123457


#ifdef WIN32
	#define DIR_SEP '\\'
#else
	#define DIR_SEP '/'
#endif

/* File types */
#define FT_NONE     0
#define FT_PNG      1
#define FT_JPEG     2
#define FT_ICO      3
#define FT_GIF      4
#define FT_BMP      5
#define FT_GPL      10
#define FT_TXT      11
#define FT_PAL      12
#define NUM_FTYPES  5
			// Used for writing
#define NUM_FTYPES2 5
			// Used for array

/* Features supported by file formats */
#define FF_BW      0x0001 /* Black and white */
#define FF_IDX     0x0002 /* Indexed color */
#define FF_RGB     0x0004 /* Truecolor */
#define FF_IMAGE   0x0007 /* Image of any kind */
#define FF_ANIM    0x0008 /* Animation */
#define FF_ALPHAI  0x0010 /* Alpha channel for indexed images */
#define FF_ALPHAR  0x0020 /* Alpha channel for RGB images */
#define FF_ALPHA   0x0030 /* Alpha channel for all images */
#define FF_MULTI   0x0040 /* Multiple channels */
#define FF_TRANS   0x0080 /* Indexed transparency */
#define FF_COMPR   0x0100 /* Compression levels */
#define FF_SPOT    0x0200 /* "Hot spot" */
#define FF_LAYER   0x0400 /* Layered images */
#define FF_PALETTE 0x0800 /* Palette file (not image) */

#define LONGEST_EXT 5

typedef struct {
	char *name, *ext, *ext2;
	guint32 flags;
} fformat;

fformat file_formats[NUM_FTYPES2];

/* All-in-one transport container for save/load */
typedef struct {
	/* Configuration data */
	int mode, ftype;
	int jpeg_quality;
	int silent;
	/* Image data */
	chanlist img;
	png_color *pal;
	int width, height, bpp, colors;
} ls_settings;

int silence_limit;


int file_type_by_ext(char *name, guint32 mask);
int save_image(char *file_name, ls_settings *settings);
int load_image(char *file_name);
int load_clipboard(char *file_name);
