#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ------------------------------------------------------------------------------
#
# automatically generates the section_xxx.dox file
#
progname=`basename $0`
USAGE="$progname: {1..9} input_dirs"
#
# where the digit in {1..9} is the section manual
#       xxx = the name of the section
#
# ------------------------------------------------------------------------------
# 1. build the .manN file list from the input_dirs
# ------------------------------------------------------------------------------
if test $# -eq 0; then
  echo "$USAGE" 1>&2; exit 0
fi
section_ident=$1; shift
input_dirs=$*;  # looking for .manN in dirs
section_label=""
section_title=""
case "$section_ident" in
  1) section_label="command"
     section_title="Commands"
     ;;
  2) section_label="class"
     section_title="Main classes"
     ;;
  3) section_label="function"
     section_title="Main functions"
     ;;
  4) section_label="linalgclass"
     section_title="Linalg classes"
     ;;
  5) section_label="linalgfunction"
     section_title="Linalg functions"
     ;;
  6) section_label="femclass"
     section_title="Finite elements"
     ;;
  7) section_label="utilclass"
     section_title="Utilities"
     ;;
  *) echo "$progname: unexpected manual section number $section_ident" 1>&2
     echo "$USAGE" 1>&2
     exit 1
esac
input_dirs=`echo "$input_dirs" | awk '{for(i=1;i<=NF;++i)print $i}' | sort -u`

#echo "input_dirs=$input_dirs" 1>&2; exit 0
L=""
for dir in $input_dirs; do 
  L="$L `/bin/ls $dir/*.man${section_ident} 2>/dev/null`"
done

#echo "L0=$L" 1>&2; exit 0
L=`echo "$L" | awk '{for(i=1;i<=NF;++i)print $i}' | sort -u`
#echo "L1=$L" 1>&2; exit 0

# ------------------------------------------------------------------------------
# 2. sort the .manN list by alphabetical order of its basename
# ------------------------------------------------------------------------------
tmp="/tmp/tmp$$.txt"
rm -f $tmp
touch $tmp
for x in $L; do
  echo "`basename $x` $x" >> $tmp
done
# TODO: avoid double occurrence when srcdir=builddir
#       => use an hash-table in awk
L=`sort -u < $tmp | awk '{print $2}'`
rm -f $tmp
#echo "L2=$L" 1>&2; 

# ------------------------------------------------------------------------------
# 3. create the .dox file on stdout
# ------------------------------------------------------------------------------
cat << EOF1
// do not edit: this file was automatically generated by `basename $0`
namespace rheolef {
/**
@page ${section_label}_page ${section_title}

<table>
EOF1
for x in $L; do
  comment=`grep -e "@${section_label}file" "$x" | awk '{for (i=3; i <= NF; ++i) printf("%s ",$i)}'`
  if test x"$comment" = x""; then
    echo "`basename $0`: error: $x without @${section_label}file" 1>&2
    exit 1
  fi
  name=`basename $x`
  name=`expr $name : '\(.*\)\..*' \| $name`
  ref_name="`echo $name | sed -e 's/-/_/g'`"
  #comment=`echo $comment`; # dot it flat
  #echo "x=$x" 1>&2
  #echo "comment=$comment" 1>&2
  if test $name = "rheolef"; then continue; fi # treated separately
  if test "${section_ident}" = "1"; then
    # unix command
    ref_section="@ref ${ref_name}_${section_ident}"
  else
    # class, func, ...
    #ref_section="${ref_name}" # direct class ref: does not work...
    ref_section="@ref ${ref_name}_${section_ident}"
  fi
  cat << EOF2
<tr valign="top">
  <td>
    ${ref_section}
  </td>
  <td>
    $comment
  </td>
</tr>
EOF2
done

cat << EOF3
</table>
*/
} // namespace rheolef
EOF3
