///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include <iostream>
#include <vector>
#include <ginac/ginac.h>
using namespace std;
using namespace GiNaC;

ex fct_2D_D(ex u0,ex u1,ex v0, ex v1, symbol x0,symbol x1) {
    ex Du00 = diff(u0,x0);
    ex Du01 = (diff(u0,x1) + diff(u1,x0))/2;
    ex Du11 = diff(u1,x1);
    ex Dv00 = diff(v0,x0);
    ex Dv01 = (diff(v0,x1) + diff(v1,x0))/2;
    ex Dv11 = diff(v1,x1);
    return 2*(Du00*Dv00 + 2*Du01*Dv01 + Du11*Dv11);
}
ex form_2D_D(ex u0,ex u1,ex v0,ex v1,symbol x0,symbol x1) {
    ex a = 0, b = 1;
    ex f = fct_2D_D(u0,u1,v0,v1,x0,x1);
    ex i0 = integral(x0,a,b,f).eval_integ();
    ex i1 = integral(x1,a,b,i0).eval_integ();
    return i1;
}
int main() {
    symbol x0("x"), x1("y");
    vector<ex> monom(6);
    monom[0] = 1;
    monom[1] = x0;
    monom[2] = x1;
    monom[3] = x0*x0;
    monom[4] = x0*x1;
    monom[5] = x1*x1;
    cout << "// file automatiocally generated by form_2D_D_symbolic.cc" << endl
         << "void init_expect_form_2D_D (Float t[6][6][6][6]) {" << endl;
    for (size_t iu0 = 0; iu0 < 6; iu0++) {
    for (size_t iu1 = 0; iu1 < 6; iu1++) {
    for (size_t iv0 = 0; iv0 < 6; iv0++) {
    for (size_t iv1 = 0; iv1 < 6; iv1++) {
	ex u0 = monom[iu0];
	ex u1 = monom[iu1];
	ex v0 = monom[iv0];
	ex v1 = monom[iv1];
	ex value = form_2D_D(u0,u1,v0,v1,x0,x1);
	cout << "	t["<<iu0<<"]["<<iu1<<"]["<<iv0<<"]["<<iv1<<"]=";
	value.print(print_csrc_double(cout));
	cout << ";" << endl;
    }}}}
    cout << "}" << endl;
    return 0;
}
