/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;

public final class HealpixNestedFixedRadiusCone4XMatch {
    private final int hashDepth;
    private final HealpixNested hn;
    private final HashComputer hc;
    private final NeighbourSelector neiSelect;
    private final int twiceDeltaOrder;
    private final double coneRadiusRad;
    private final NeighbourList neigList;

    protected HealpixNestedFixedRadiusCone4XMatch(int hashDepth, double coneRadiusRad) {
        this.hashDepth = hashDepth;
        int optimalStartingDepth = Healpix.getBestStartingDepth(coneRadiusRad);
        if (optimalStartingDepth < this.hashDepth) {
            throw new IllegalArgumentException("Choosen radius too large for the wanted depth!");
        }
        this.hn = Healpix.getNested(optimalStartingDepth);
        this.hc = this.hn.newHashComputer();
        this.neiSelect = this.hn.newNeighbourSelector();
        this.twiceDeltaOrder = optimalStartingDepth - hashDepth << 1;
        this.coneRadiusRad = coneRadiusRad;
        this.neigList = new NeighbourList(this.hashDepth);
    }

    private HealpixNestedFixedRadiusCone4XMatch(HealpixNestedFixedRadiusCone4XMatch o) {
        this.hashDepth = o.hashDepth;
        this.hn = o.hn;
        this.hc = this.hn.newHashComputer();
        this.neiSelect = this.hn.newNeighbourSelector();
        this.twiceDeltaOrder = o.twiceDeltaOrder;
        this.coneRadiusRad = o.coneRadiusRad;
        this.neigList = new NeighbourList(this.hashDepth);
    }

    public double getRadius() {
        return this.coneRadiusRad;
    }

    public int getResultDepth() {
        return this.hashDepth;
    }

    public int overlappingCells(double coneCenterLonRad, double coneCenterLatRad, long[] result) {
        long ch;
        long centerHash = this.hc.hash(coneCenterLonRad, coneCenterLatRad);
        this.neiSelect.neighbours(centerHash, this.neigList);
        result[0] = ch = centerHash >>> this.twiceDeltaOrder;
        int ir = 1;
        for (int i = 0; i < this.neigList.size(); ++i) {
            long h = this.neigList.get(i) >>> this.twiceDeltaOrder;
            if (h == ch || !HealpixNestedFixedRadiusCone4XMatch.isNotIn(h, result, ir)) continue;
            result[ir++] = h;
        }
        return ir;
    }

    private static final boolean isNotIn(long h, long[] ah, long alength) {
        int i = 1;
        while ((long)i < alength) {
            if (h == ah[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public HealpixNestedFixedRadiusCone4XMatch newComputer() {
        return new HealpixNestedFixedRadiusCone4XMatch(this);
    }
}

