## TFSA-2022-059: Null pointer dereference in `BuildXlaCompilationCache` (XLA)

### CVE Number
CVE-2022-23595

### Impact
When [building an XLA compilation cache](https://github.com/tensorflow/tensorflow/blob/274df9b02330b790aa8de1cee164b70f72b9b244/tensorflow/compiler/jit/xla_platform_info.cc#L43-L104), if default settings are used, TensorFlow triggers a null pointer dereference:

```cc
  string allowed_gpus =
      flr->config_proto()->gpu_options().visible_device_list();
```

In the default scenario, all devices are allowed, so `flr->config_proto` is `nullptr`.

### Patches
We have patched the issue in GitHub commit [e21af685e1828f7ca65038307df5cc06de4479e8](https://github.com/tensorflow/tensorflow/commit/e21af685e1828f7ca65038307df5cc06de4479e8).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
