/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: sound-process.c,v 1.3 2000/01/18 22:29:57 rich Exp $
 */

/* Please see comments in src/sound.c.
 *
 * IMPORTANT NOTE: This file is not part of the normal XRacer process.
 * It may be running as a child process, or as a separate thread. You
 * cannot call normal XRacer library functions such as xrLog* from here,
 * so don't try it. Another thing this library must not do is to call
 * exit(3). This could cause all the atexit handlers from the main program
 * to be called twice, with unexpected results. Use _exit(2) instead.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "xracer.h"
#include "xracer-sound-process.h"
#include "xracer-arch.h"
#include "xracer-log.h"

/* Shared memory. */
static struct xrSoundSharedMemory *shm = 0;

static void user_signal (void);

/* This is the entry point into the sound process, called just after
 * it is forked off from the parent.
 */
void
xrSoundProcessRun (void *_shm)
{
  shm = _shm;

  /* Ensure that log system never tries to display any log messages. */
  xrLogSetDisplayThreshold (LOG_ERROR+1);

  /* Register for SIGUSR1 signals. */
  xrArchSetCallbackOnUserSignal (user_signal);

  xrLog (LOG_DEBUG, "Sound processing running.");

  sleep (6000);
}

static void
user_signal ()
{
#if defined(linux) && 1
  /* Debug SIGUSR1 signals. */
  const char *s = "Received user signal.\n";
  int len = strlen (s);

  write (2, s, len);
#endif

  _exit (0);
}
