# Non-documentation, Non-core files for Asymptote
# This file is intended for any files that are generated by asy.

# Additionally, ensure this file is included after asy target & base files target has been defined in
# CMakeLists.txt.

set(ASY_MISC_FILES_OUT_DIR ${CMAKE_CURRENT_BINARY_DIR}/misc-output)
file(MAKE_DIRECTORY ${ASY_MISC_FILES_OUT_DIR})

# asy.list
add_custom_command(
        OUTPUT ${ASY_MISC_FILES_OUT_DIR}/asy.list
        COMMAND ${PY3_INTERPRETER} ${ASY_SCRIPTS_DIR}/generate_asy_list_file.py
            --asy-executable $<TARGET_FILE:asy>
            --asy-base-dir=${ASY_BUILD_BASE_DIR}
            --output-file ${ASY_MISC_FILES_OUT_DIR}/asy.list
        DEPENDS asy ${ASY_OUTPUT_BASE_FILES} ${ASY_SCRIPTS_DIR}/generate_asy_list_file.py
)


# asy-keywords.el
add_custom_command(
        OUTPUT ${ASY_MISC_FILES_OUT_DIR}/asy-keywords.el
        COMMAND ${PY3_INTERPRETER} ${ASY_SCRIPTS_DIR}/asy-list.py
            --asy-list-file ${ASY_MISC_FILES_OUT_DIR}/asy.list
            --revision ${ASY_VERSION}
            --output-file ${ASY_MISC_FILES_OUT_DIR}/asy-keywords.el
        WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
        DEPENDS ${ASY_MISC_FILES_OUT_DIR}/asy.list ${CMAKE_CURRENT_SOURCE_DIR}/camp.l ${ASY_SCRIPTS_DIR}/asy-list.py
)

set(ASY_OUTPUT_DIST_MISC_FILES
        ${ASY_MISC_FILES_OUT_DIR}/asy-keywords.el
)
add_custom_target(asy-dist-misc-files DEPENDS ${ASY_OUTPUT_DIST_MISC_FILES})
