#!/bin/sh

SUBDIRS="App ToolScene Dialogs Gui Book Data File Items Scenes AutoNote"

cd `dirname $0`
cd ../src

echo "# Automatically generated by updatesources.sh" > CMakeLists.txt
echo "" >> CMakeLists.txt

for DIR in $SUBDIRS; do
    echo "include(src/$DIR/CMakeLists.txt)" >> CMakeLists.txt
    echo "target_include_directories(notedeln PRIVATE src/$DIR)" >> CMakeLists.txt

    echo "# Automatically generated by updatesources.sh" > $DIR/CMakeLists.txt
    echo "" >> $DIR/CMakeLists.txt
    find $DIR -name \*.h -exec echo "target_sources(notedeln PRIVATE " 'src/{}' ")" ';' | sort -df >> $DIR/CMakeLists.txt
    find $DIR -name \*.cpp -exec echo "target_sources(notedeln PRIVATE " 'src/{}' ")" ';' | sort -df >> $DIR/CMakeLists.txt
    find $DIR -name \*.qrc -exec echo "target_sources(notedeln PRIVATE " 'src/{}' ")" ';' | sort -df >> $DIR/CMakeLists.txt
    find $DIR -name \*.ui -exec echo "target_sources(notedeln PRIVATE " 'src/{}' ")" ';' | sort -df >> $DIR/CMakeLists.txt
done
