/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

export const BACKGROUND_COLOR = {
  CATEGORIES: ["background-color"],
  PROPERTIES: ["background", "background-color"],
};

export const BORDER_COLOR = {
  CATEGORIES: ["border-color", "border", "outline"],
  PROPERTIES: [
    "border",
    "border-color",
    "outline",
    "outline-color",
    "border-top",
    "border-right",
    "border-bottom",
    "border-left",
    "border-top-color",
    "border-right-color",
    "border-bottom-color",
    "border-left-color",
    "border-block",
    "border-block-color",
    "border-block-start",
    "border-block-start-color",
    "border-block-end",
    "border-block-end-color",
    "border-inline",
    "border-inline-color",
    "border-inline-start",
    "border-inline-start-color",
    "border-inline-end",
    "border-inline-end-color",
  ],
};

export const BORDER_RADIUS = {
  CATEGORIES: ["border-radius"],
  PROPERTIES: [
    "border-radius",
    "border-top-left-radius",
    "border-top-right-radius",
    "border-bottom-right-radius",
    "border-bottom-left-radius",
    "border-start-start-radius",
    "border-start-end-radius",
    "border-end-start-radius",
    "border-end-end-radius",
  ],
};

export const BORDER_WIDTH = {
  CATEGORIES: ["border-width"],
  PROPERTIES: [
    "border",
    "border-width",
    "border-top",
    "border-top-width",
    "border-block-start",
    "border-block-start-width",
    "border-right",
    "border-right-width",
    "border-inline-end",
    "border-inline-width",
    "border-bottom",
    "border-bottom-width",
    "border-block-end",
    "border-block-end-width",
    "border-left",
    "border-left-width",
    "border-inline-start",
    "border-inline-start-width",
    "outline",
    "outline-width",
  ],
};

export const FONT_SIZE = {
  CATEGORIES: ["font-size", "heading-font"],
  PROPERTIES: ["font-size", "font"],
};

export const FONT_WEIGHT = {
  CATEGORIES: ["font-weight"],
  PROPERTIES: ["font-weight", "font"],
};

export const ICON_COLOR = {
  CATEGORIES: ["icon-color"],
  PROPERTIES: ["color", "fill", "stroke"],
};

export const SIZE = {
  CATEGORIES: ["size", "icon-size"],
  PROPERTIES: [
    "width",
    "min-width",
    "max-width",
    "height",
    "min-height",
    "max-height",
    "inline-size",
    "min-inline-size",
    "max-inline-size",
    "block-size",
    "min-block-size",
    "max-block-size",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "flex",
    "flex-basis",
    "grid",
    "grid-template-rows",
    "grid-template-columns",
    "grid-auto-rows",
    "grid-auto-columns",
    "background-size",
    "transform",
  ],
};

export const OPACITY = {
  CATEGORIES: ["opacity"],
  PROPERTIES: ["opacity"],
};

export const SPACE = {
  CATEGORIES: ["space"],
  PROPERTIES: [
    "margin",
    "margin-top",
    "margin-right",
    "margin-bottom",
    "margin-left",
    "margin-block",
    "margin-block-start",
    "margin-block-end",
    "margin-inline",
    "margin-inline-start",
    "margin-inline-end",
    "padding",
    "padding-top",
    "padding-right",
    "padding-bottom",
    "padding-left",
    "padding-block",
    "padding-block-start",
    "padding-block-end",
    "padding-inline",
    "padding-inline-start",
    "padding-inline-end",
    "inset",
    "inset-block",
    "inset-block-end",
    "inset-block-start",
    "inset-inline",
    "inset-inline-end",
    "inset-inline-start",
    "gap",
    "row-gap",
    "column-gap",
    "scroll-margin",
    "scroll-margin-top",
    "scroll-margin-right",
    "scroll-margin-bottom",
    "scroll-margin-left",
    "scroll-margin-block",
    "scroll-margin-block-start",
    "scroll-margin-block-end",
    "scroll-margin-inline",
    "scroll-margin-inline-start",
    "scroll-margin-inline-end",
    "scroll-padding",
    "scroll-padding-top",
    "scroll-padding-right",
    "scroll-padding-bottom",
    "scroll-padding-left",
    "scroll-padding-block",
    "scroll-padding-block-start",
    "scroll-padding-block-end",
    "scroll-padding-inline",
    "scroll-padding-inline-start",
    "scroll-padding-inline-end",
    "border-spacing",
  ],
};

export const TEXT_COLOR = {
  CATEGORIES: ["text-color", "link"],
  PROPERTIES: ["color", "fill", "stroke"],
};

export const BOX_SHADOW = {
  CATEGORIES: ["box-shadow"],
  PROPERTIES: ["box-shadow", "filter", "backdrop-filter"],
};
