/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * Azure Virtual Desktop Gateway / Azure Resource Manager
 *
 * Copyright 2023 Michael Saxl <mike@mwsys.mine.bz>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef FREERDP_LIB_CORE_GATEWAY_ARM_H
#define FREERDP_LIB_CORE_GATEWAY_ARM_H

#include <winpr/wtypes.h>
#include <winpr/wlog.h>

#include <freerdp/api.h>
#include <freerdp/types.h>

FREERDP_LOCAL BOOL arm_resolve_endpoint(wLog* log, rdpContext* context, DWORD timeout);

#endif /* FREERDP_LIB_CORE_GATEWAY_ARM_H */
