/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_SAA5281_C 1

#include "gatos.h"
#include "saa5281.h"
#include "i2c.h"

#include <stdio.h>
#include <errno.h>
#include <string.h>

/* ------------------------------------------------------------------------ */
/* Initialization routines */

int saa5281_init(void) {

  /* Scan I2C bus for a SAA5281 chip */
  gatos.saa5281.addr = 0xFF ;
  if (i2c_device(0x22)) saa5281_register(0x22) ;
  RETURN0 ; }

/* ------------------------------------------------------------------------ */
/* Private routines */

static int saa5281_register(u8 addr) {
  char *ident, name[64] ;
  ident = "SAA5281" ;
  gatos.saa5281.addr = addr ;
  gatos.saa5281.deviceid = 0 ;
  gatos.saa5281.revision = 0 ;
  snprintf(name,sizeof(name),"%s European TeleText Decoder",ident) ;
  i2c_register(addr,ident,name) ; RETURN0 ; }
