//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// DO NOT EDIT.

package armconnectedvmware

import "time"

// AvailablePatchCountByClassification - Summarization of patches available for installation on the machine by classification.
type AvailablePatchCountByClassification struct {
	// READ-ONLY; Number of critical patches available for installation.
	Critical *int32 `json:"critical,omitempty" azure:"ro"`

	// READ-ONLY; Number of definition patches available for installation.
	Definition *int32 `json:"definition,omitempty" azure:"ro"`

	// READ-ONLY; Number of feature pack patches available for installation.
	FeaturePack *int32 `json:"featurePack,omitempty" azure:"ro"`

	// READ-ONLY; Number of other patches available for installation.
	Other *int32 `json:"other,omitempty" azure:"ro"`

	// READ-ONLY; Number of security patches available for installation.
	Security *int32 `json:"security,omitempty" azure:"ro"`

	// READ-ONLY; Number of service pack patches available for installation.
	ServicePack *int32 `json:"servicePack,omitempty" azure:"ro"`

	// READ-ONLY; Number of tools patches available for installation.
	Tools *int32 `json:"tools,omitempty" azure:"ro"`

	// READ-ONLY; Number of update Rollup patches available for installation.
	UpdateRollup *int32 `json:"updateRollup,omitempty" azure:"ro"`

	// READ-ONLY; Number of updates category patches available for installation.
	Updates *int32 `json:"updates,omitempty" azure:"ro"`
}

// Cluster - Define the cluster.
type Cluster struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterInventoryItem - The cluster inventory item.
type ClusterInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type ClusterInventoryItem.
func (c *ClusterInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     c.InventoryType,
		ManagedResourceID: c.ManagedResourceID,
		MoRefID:           c.MoRefID,
		MoName:            c.MoName,
		ProvisioningState: c.ProvisioningState,
	}
}

// ClusterProperties - Defines the resource properties.
type ClusterProperties struct {
	// Gets or sets the inventory Item ID for the cluster.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this cluster resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the datastore ARM ids.
	DatastoreIDs []*string `json:"datastoreIds,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the cluster.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the network ARM ids.
	NetworkIDs []*string `json:"networkIds,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// ClustersClientBeginCreateOptions contains the optional parameters for the ClustersClient.BeginCreate method.
type ClustersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.ListByResourceGroup method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListOptions contains the optional parameters for the ClustersClient.List method.
type ClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientUpdateOptions contains the optional parameters for the ClustersClient.Update method.
type ClustersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ClustersList - List of Clusters.
type ClustersList struct {
	// REQUIRED; Array of Clusters
	Value []*Cluster `json:"value,omitempty"`

	// Url to follow for getting next page of Clusters.
	NextLink *string `json:"nextLink,omitempty"`
}

// Condition defines an extension to status.
type Condition struct {
	// READ-ONLY; A human readable message indicating details about the status.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The reason for the condition's status.
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; Severity with which to treat failures of this type of condition.
	Severity *string `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; Status of the condition.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// Datastore - Define the datastore.
type Datastore struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *DatastoreProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatastoreInventoryItem - The datastore inventory item.
type DatastoreInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets Maximum capacity of this datastore, in GBs.
	CapacityGB *int64 `json:"capacityGB,omitempty"`

	// Gets or sets Available space of this datastore, in GBs.
	FreeSpaceGB *int64 `json:"freeSpaceGB,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type DatastoreInventoryItem.
func (d *DatastoreInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     d.InventoryType,
		ManagedResourceID: d.ManagedResourceID,
		MoRefID:           d.MoRefID,
		MoName:            d.MoName,
		ProvisioningState: d.ProvisioningState,
	}
}

// DatastoreProperties - Defines the resource properties.
type DatastoreProperties struct {
	// Gets or sets the inventory Item ID for the datastore.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the datastore.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this datastore resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the datastore.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// DatastoresClientBeginCreateOptions contains the optional parameters for the DatastoresClient.BeginCreate method.
type DatastoresClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatastoresClientBeginDeleteOptions contains the optional parameters for the DatastoresClient.BeginDelete method.
type DatastoresClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatastoresClientGetOptions contains the optional parameters for the DatastoresClient.Get method.
type DatastoresClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatastoresClientListByResourceGroupOptions contains the optional parameters for the DatastoresClient.ListByResourceGroup
// method.
type DatastoresClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DatastoresClientListOptions contains the optional parameters for the DatastoresClient.List method.
type DatastoresClientListOptions struct {
	// placeholder for future optional parameters
}

// DatastoresClientUpdateOptions contains the optional parameters for the DatastoresClient.Update method.
type DatastoresClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatastoresList - List of Datastores.
type DatastoresList struct {
	// REQUIRED; Array of Datastores
	Value []*Datastore `json:"value,omitempty"`

	// Url to follow for getting next page of Datastores.
	NextLink *string `json:"nextLink,omitempty"`
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorDetail - Error details.
type ErrorDetail struct {
	// REQUIRED; The error's code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; A human readable error message.
	Message *string `json:"message,omitempty"`

	// Additional error details.
	Details []*ErrorDetail `json:"details,omitempty"`

	// Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// ExtendedLocation - The extended location.
type ExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

// GuestAgent - Defines the GuestAgent.
type GuestAgent struct {
	// REQUIRED; Resource properties.
	Properties *GuestAgentProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GuestAgentList - List of GuestAgent.
type GuestAgentList struct {
	// REQUIRED; Array of GuestAgent
	Value []*GuestAgent `json:"value,omitempty"`

	// Url to follow for getting next page of GuestAgent.
	NextLink *string `json:"nextLink,omitempty"`
}

// GuestAgentProfile - Defines the resource properties.
type GuestAgentProfile struct {
	// READ-ONLY; The hybrid machine agent full version.
	AgentVersion *string `json:"agentVersion,omitempty" azure:"ro"`

	// READ-ONLY; Details about the error state.
	ErrorDetails []*ErrorDetail `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last status change.
	LastStatusChange *time.Time `json:"lastStatusChange,omitempty" azure:"ro"`

	// READ-ONLY; The status of the hybrid machine agent.
	Status *StatusTypes `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the VM's unique SMBIOS ID.
	VMUUID *string `json:"vmUuid,omitempty" azure:"ro"`
}

// GuestAgentProperties - Defines the resource properties.
type GuestAgentProperties struct {
	// Username / Password Credentials to provision guest agent.
	Credentials *GuestCredential `json:"credentials,omitempty"`

	// HTTP Proxy configuration for the VM.
	HTTPProxyConfig *HTTPProxyConfiguration `json:"httpProxyConfig,omitempty"`

	// Gets or sets the guest agent provisioning action.
	ProvisioningAction *ProvisioningAction `json:"provisioningAction,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the guest agent status.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// GuestAgentsClientBeginCreateOptions contains the optional parameters for the GuestAgentsClient.BeginCreate method.
type GuestAgentsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GuestAgentsClientBeginDeleteOptions contains the optional parameters for the GuestAgentsClient.BeginDelete method.
type GuestAgentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GuestAgentsClientGetOptions contains the optional parameters for the GuestAgentsClient.Get method.
type GuestAgentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GuestAgentsClientListByVMOptions contains the optional parameters for the GuestAgentsClient.ListByVM method.
type GuestAgentsClientListByVMOptions struct {
	// placeholder for future optional parameters
}

// GuestCredential - Username / Password Credentials to connect to guest.
type GuestCredential struct {
	// Gets or sets the password to connect with the guest.
	Password *string `json:"password,omitempty"`

	// Gets or sets username to connect with the guest.
	Username *string `json:"username,omitempty"`
}

// HTTPProxyConfiguration - HTTP Proxy configuration for the VM.
type HTTPProxyConfiguration struct {
	// Gets or sets httpsProxy url.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`
}

// HardwareProfile - Defines the resource properties.
type HardwareProfile struct {
	// Gets or sets memory size in MBs for the vm.
	MemorySizeMB *int32 `json:"memorySizeMB,omitempty"`

	// Gets or sets the number of vCPUs for the vm.
	NumCPUs *int32 `json:"numCPUs,omitempty"`

	// Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
	NumCoresPerSocket *int32 `json:"numCoresPerSocket,omitempty"`

	// READ-ONLY; Gets or sets a value indicating whether virtual processors can be added while this virtual machine is running.
	CPUHotAddEnabled *bool `json:"cpuHotAddEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a value indicating whether virtual processors can be removed while this virtual machine is running.
	CPUHotRemoveEnabled *bool `json:"cpuHotRemoveEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a value indicating whether memory can be added while this virtual machine is running.
	MemoryHotAddEnabled *bool `json:"memoryHotAddEnabled,omitempty" azure:"ro"`
}

// Host - Define the host.
type Host struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *HostProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HostInventoryItem - The host inventory item.
type HostInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// Parent host inventory resource details.
	Parent *InventoryItemDetails `json:"parent,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type HostInventoryItem.
func (h *HostInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     h.InventoryType,
		ManagedResourceID: h.ManagedResourceID,
		MoRefID:           h.MoRefID,
		MoName:            h.MoName,
		ProvisioningState: h.ProvisioningState,
	}
}

// HostProperties - Defines the resource properties.
type HostProperties struct {
	// Gets or sets the inventory Item ID for the host.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the host.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this host resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the host.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// HostsClientBeginCreateOptions contains the optional parameters for the HostsClient.BeginCreate method.
type HostsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HostsClientBeginDeleteOptions contains the optional parameters for the HostsClient.BeginDelete method.
type HostsClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HostsClientGetOptions contains the optional parameters for the HostsClient.Get method.
type HostsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HostsClientListByResourceGroupOptions contains the optional parameters for the HostsClient.ListByResourceGroup method.
type HostsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// HostsClientListOptions contains the optional parameters for the HostsClient.List method.
type HostsClientListOptions struct {
	// placeholder for future optional parameters
}

// HostsClientUpdateOptions contains the optional parameters for the HostsClient.Update method.
type HostsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// HostsList - List of Hosts.
type HostsList struct {
	// REQUIRED; Array of Hosts
	Value []*Host `json:"value,omitempty"`

	// Url to follow for getting next page of Hosts.
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridIdentityMetadata - Defines the HybridIdentityMetadata.
type HybridIdentityMetadata struct {
	// REQUIRED; Resource properties.
	Properties *HybridIdentityMetadataProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridIdentityMetadataClientCreateOptions contains the optional parameters for the HybridIdentityMetadataClient.Create
// method.
type HybridIdentityMetadataClientCreateOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataClientDeleteOptions contains the optional parameters for the HybridIdentityMetadataClient.Delete
// method.
type HybridIdentityMetadataClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataClientGetOptions contains the optional parameters for the HybridIdentityMetadataClient.Get method.
type HybridIdentityMetadataClientGetOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataClientListByVMOptions contains the optional parameters for the HybridIdentityMetadataClient.ListByVM
// method.
type HybridIdentityMetadataClientListByVMOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataList - List of HybridIdentityMetadata.
type HybridIdentityMetadataList struct {
	// REQUIRED; Array of HybridIdentityMetadata
	Value []*HybridIdentityMetadata `json:"value,omitempty"`

	// Url to follow for getting next page of HybridIdentityMetadata.
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridIdentityMetadataProperties - Defines the resource properties.
type HybridIdentityMetadataProperties struct {
	// Gets or sets the Public Key.
	PublicKey *string `json:"publicKey,omitempty"`

	// Gets or sets the Vm Id.
	VMID *string `json:"vmId,omitempty"`

	// READ-ONLY; The identity of the resource.
	Identity *Identity `json:"identity,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Identity - Managed service identity.
type Identity struct {
	// REQUIRED; The type of managed service identity.
	Type *IdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal id of managed service identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant of managed service identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// InventoryItem - Defines the inventory item.
type InventoryItem struct {
	// REQUIRED; Resource properties.
	Properties InventoryItemPropertiesClassification `json:"properties,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InventoryItemDetails - Defines the resource properties.
type InventoryItemDetails struct {
	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the resource.
	MoName *string `json:"moName,omitempty"`
}

// InventoryItemPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetInventoryItemProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ClusterInventoryItem, *DatastoreInventoryItem, *HostInventoryItem, *InventoryItemProperties, *ResourcePoolInventoryItem,
// - *VirtualMachineInventoryItem, *VirtualMachineTemplateInventoryItem, *VirtualNetworkInventoryItem
type InventoryItemPropertiesClassification interface {
	// GetInventoryItemProperties returns the InventoryItemProperties content of the underlying type.
	GetInventoryItemProperties() *InventoryItemProperties
}

// InventoryItemProperties - Defines the resource properties.
type InventoryItemProperties struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type InventoryItemProperties.
func (i *InventoryItemProperties) GetInventoryItemProperties() *InventoryItemProperties { return i }

// InventoryItemsClientCreateOptions contains the optional parameters for the InventoryItemsClient.Create method.
type InventoryItemsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsClientDeleteOptions contains the optional parameters for the InventoryItemsClient.Delete method.
type InventoryItemsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsClientGetOptions contains the optional parameters for the InventoryItemsClient.Get method.
type InventoryItemsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsClientListByVCenterOptions contains the optional parameters for the InventoryItemsClient.ListByVCenter method.
type InventoryItemsClientListByVCenterOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsList - List of InventoryItems.
type InventoryItemsList struct {
	// REQUIRED; Array of InventoryItems
	Value []*InventoryItem `json:"value,omitempty"`

	// Url to follow for getting next page of InventoryItems.
	NextLink *string `json:"nextLink,omitempty"`
}

// LinuxParameters - Input for InstallPatches on a Linux VM, as directly received by the API
type LinuxParameters struct {
	// The update classifications to select when installing patches for Linux.
	ClassificationsToInclude []*VMGuestPatchClassificationLinux `json:"classificationsToInclude,omitempty"`

	// packages to exclude in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToExclude []*string `json:"packageNameMasksToExclude,omitempty"`

	// packages to include in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToInclude []*string `json:"packageNameMasksToInclude,omitempty"`
}

// MachineExtension - Describes a Machine Extension.
type MachineExtension struct {
	// Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// Describes Machine Extension Properties.
	Properties *MachineExtensionProperties `json:"properties,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MachineExtensionInstanceView - Describes the Machine Extension Instance View.
type MachineExtensionInstanceView struct {
	// Instance view status.
	Status *MachineExtensionInstanceViewStatus `json:"status,omitempty"`

	// READ-ONLY; The machine extension name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty" azure:"ro"`
}

// MachineExtensionInstanceViewStatus - Instance view status.
type MachineExtensionInstanceViewStatus struct {
	// READ-ONLY; The status code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty" azure:"ro"`

	// READ-ONLY; The level code.
	Level *StatusLevelTypes `json:"level,omitempty" azure:"ro"`

	// READ-ONLY; The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The time of the status.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// MachineExtensionProperties - Describes the properties of a Machine Extension.
type MachineExtensionProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The machine extension instance view.
	InstanceView *MachineExtensionPropertiesInstanceView `json:"instanceView,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// MachineExtensionPropertiesInstanceView - The machine extension instance view.
type MachineExtensionPropertiesInstanceView struct {
	// Instance view status.
	Status *MachineExtensionInstanceViewStatus `json:"status,omitempty"`

	// READ-ONLY; The machine extension name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty" azure:"ro"`
}

// MachineExtensionUpdate - Describes a Machine Extension Update.
type MachineExtensionUpdate struct {
	// Describes Machine Extension Update Properties.
	Properties *MachineExtensionUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MachineExtensionUpdateProperties - Describes the properties of a Machine Extension.
type MachineExtensionUpdateProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
}

// MachineExtensionsClientBeginCreateOrUpdateOptions contains the optional parameters for the MachineExtensionsClient.BeginCreateOrUpdate
// method.
type MachineExtensionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MachineExtensionsClientBeginDeleteOptions contains the optional parameters for the MachineExtensionsClient.BeginDelete
// method.
type MachineExtensionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MachineExtensionsClientBeginUpdateOptions contains the optional parameters for the MachineExtensionsClient.BeginUpdate
// method.
type MachineExtensionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MachineExtensionsClientGetOptions contains the optional parameters for the MachineExtensionsClient.Get method.
type MachineExtensionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MachineExtensionsClientListOptions contains the optional parameters for the MachineExtensionsClient.List method.
type MachineExtensionsClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// MachineExtensionsListResult - Describes the Machine Extensions List Result.
type MachineExtensionsListResult struct {
	// The uri to fetch the next page of machine extensions. Call ListNext() with this to fetch the next page of extensions.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of extensions
	Value []*MachineExtension `json:"value,omitempty"`
}

// NetworkInterface - Network Interface model
type NetworkInterface struct {
	// Gets or sets the device key value.
	DeviceKey *int32 `json:"deviceKey,omitempty"`

	// Gets or sets the ipsettings.
	IPSettings *NicIPSettings `json:"ipSettings,omitempty"`

	// Gets or sets the name of the network interface.
	Name *string `json:"name,omitempty"`

	// Gets or sets the ARM Id of the network resource to connect the virtual machine.
	NetworkID *string `json:"networkId,omitempty"`

	// NIC type
	NicType *NICType `json:"nicType,omitempty"`

	// Gets or sets the power on boot.
	PowerOnBoot *PowerOnBootOption `json:"powerOnBoot,omitempty"`

	// READ-ONLY; Gets or sets the nic ip addresses.
	IPAddresses []*string `json:"ipAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the label of the virtual network in vCenter that the nic is connected to.
	Label *string `json:"label,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the NIC MAC address.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name of the virtual network in vCenter that the nic is connected to.
	NetworkMoName *string `json:"networkMoName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter MoRef (Managed Object Reference) ID of the virtual network that the nic is connected
	// to.
	NetworkMoRefID *string `json:"networkMoRefId,omitempty" azure:"ro"`
}

// NetworkInterfaceUpdate - Defines the network interface update.
type NetworkInterfaceUpdate struct {
	// Gets or sets the device key value.
	DeviceKey *int32 `json:"deviceKey,omitempty"`

	// Gets or sets the name of the network interface.
	Name *string `json:"name,omitempty"`

	// Gets or sets the ARM Id of the network resource to connect the virtual machine.
	NetworkID *string `json:"networkId,omitempty"`

	// NIC type
	NicType *NICType `json:"nicType,omitempty"`

	// Gets or sets the power on boot.
	PowerOnBoot *PowerOnBootOption `json:"powerOnBoot,omitempty"`
}

// NetworkProfile - Defines the resource properties.
type NetworkProfile struct {
	// Gets or sets the list of network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`
}

// NetworkProfileUpdate - Defines the update resource properties.
type NetworkProfileUpdate struct {
	// Gets or sets the list of network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterfaceUpdate `json:"networkInterfaces,omitempty"`
}

// NicIPAddressSettings - IP address information for a virtual network adapter reported by the fabric.
type NicIPAddressSettings struct {
	// READ-ONLY; Gets the ip address allocation method.
	AllocationMethod *string `json:"allocationMethod,omitempty" azure:"ro"`

	// READ-ONLY; Gets the ip address for the nic.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`

	// READ-ONLY; Gets the mask.
	SubnetMask *string `json:"subnetMask,omitempty" azure:"ro"`
}

// NicIPSettings - Defines the network interface ip settings.
type NicIPSettings struct {
	// Gets or sets the nic allocation method.
	AllocationMethod *IPAddressAllocationMethod `json:"allocationMethod,omitempty"`

	// Gets or sets the dns servers.
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Gets or sets the gateway.
	Gateway []*string `json:"gateway,omitempty"`

	// Gets or sets the ip address for the nic.
	IPAddress *string `json:"ipAddress,omitempty"`

	// Gets or sets the mask.
	SubnetMask *string `json:"subnetMask,omitempty"`

	// READ-ONLY; Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information
	// above plus IPV6 information.
	IPAddressInfo []*NicIPAddressSettings `json:"ipAddressInfo,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the primary server.
	PrimaryWinsServer *string `json:"primaryWinsServer,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the secondary server.
	SecondaryWinsServer *string `json:"secondaryWinsServer,omitempty" azure:"ro"`
}

// Operation provided by provider
type Operation struct {
	// Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is data action or not.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Properties of the operation
type OperationDisplay struct {
	// Description of the operation
	Description *string `json:"description,omitempty"`

	// Operation name
	Operation *string `json:"operation,omitempty"`

	// Provider name
	Provider *string `json:"provider,omitempty"`

	// Resource name
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsList - Lists the operations available.
type OperationsList struct {
	// REQUIRED; Array of operations
	Value []*Operation `json:"value,omitempty"`

	// Url to follow for getting next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OsProfile - Defines the resource properties.
type OsProfile struct {
	// Gets or sets administrator password.
	AdminPassword *string `json:"adminPassword,omitempty"`

	// Gets or sets administrator username.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Gets or sets computer name.
	ComputerName *string `json:"computerName,omitempty"`

	// Gets or sets the guestId.
	GuestID *string `json:"guestId,omitempty"`

	// Specifies the linux configuration for update management.
	LinuxConfiguration *OsProfileLinuxConfiguration `json:"linuxConfiguration,omitempty"`

	// Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty"`

	// Specifies the windows configuration for update management.
	WindowsConfiguration *OsProfileWindowsConfiguration `json:"windowsConfiguration,omitempty"`

	// READ-ONLY; Gets or sets a value indicating whether the VM is ready for extension operations.
	AllowExtensionOperations *bool `json:"allowExtensionOperations,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets os name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current running status of VMware Tools running in the guest operating system.
	ToolsRunningStatus *string `json:"toolsRunningStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string `json:"toolsVersion,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string `json:"toolsVersionStatus,omitempty" azure:"ro"`
}

// OsProfileLinuxConfiguration - Specifies the linux configuration for update management.
type OsProfileLinuxConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
}

// OsProfileUpdate - Defines the os update properties.
type OsProfileUpdate struct {
	// Specifies the linux configuration for update management.
	LinuxConfiguration *OsProfileUpdateLinuxConfiguration `json:"linuxConfiguration,omitempty"`

	// Specifies the windows configuration for update management.
	WindowsConfiguration *OsProfileUpdateWindowsConfiguration `json:"windowsConfiguration,omitempty"`
}

// OsProfileUpdateLinuxConfiguration - Specifies the linux configuration for update management.
type OsProfileUpdateLinuxConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
}

// OsProfileUpdateWindowsConfiguration - Specifies the windows configuration for update management.
type OsProfileUpdateWindowsConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
}

// OsProfileWindowsConfiguration - Specifies the windows configuration for update management.
type OsProfileWindowsConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
}

// PatchSettings - Specifies the patch settings.
type PatchSettings struct {
	// Specifies the assessment mode.
	AssessmentMode *string `json:"assessmentMode,omitempty"`

	// Specifies the patch mode.
	PatchMode *string `json:"patchMode,omitempty"`
}

// PlacementProfile - Defines the resource properties.
type PlacementProfile struct {
	// Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
	ClusterID *string `json:"clusterId,omitempty"`

	// Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
	DatastoreID *string `json:"datastoreId,omitempty"`

	// Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
	HostID *string `json:"hostId,omitempty"`

	// Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
	ResourcePoolID *string `json:"resourcePoolId,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourcePatch - Object containing updates for patch operations.
type ResourcePatch struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ResourcePool - Define the resourcePool.
type ResourcePool struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *ResourcePoolProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourcePoolInventoryItem - The resource pool inventory item.
type ResourcePoolInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// Parent resourcePool inventory resource details.
	Parent *InventoryItemDetails `json:"parent,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type ResourcePoolInventoryItem.
func (r *ResourcePoolInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     r.InventoryType,
		ManagedResourceID: r.ManagedResourceID,
		MoRefID:           r.MoRefID,
		MoName:            r.MoName,
		ProvisioningState: r.ProvisioningState,
	}
}

// ResourcePoolProperties - Defines the resource properties.
type ResourcePoolProperties struct {
	// Gets or sets the inventory Item ID for the resource pool.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource pool.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets or sets CPULimitMHz which specifies a CPU usage limit in MHz. Utilization will not exceed this limit even
	// if there are available resources.
	CPULimitMHz *int64 `json:"cpuLimitMHz,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets CPUReservationMHz which specifies the CPU size in MHz that is guaranteed to be available.
	CPUReservationMHz *int64 `json:"cpuReservationMHz,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets CPUSharesLevel which specifies the CPU allocation level for this pool. This property is used in
	// relative allocation between resource consumers.
	CPUSharesLevel *string `json:"cpuSharesLevel,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets MemLimitMB specifies a memory usage limit in megabytes. Utilization will not exceed the specified
	// limit even if there are available resources.
	MemLimitMB *int64 `json:"memLimitMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets MemReservationMB which specifies the guaranteed available memory in megabytes.
	MemReservationMB *int64 `json:"memReservationMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets CPUSharesLevel which specifies the memory allocation level for this pool. This property is used
	// in relative allocation between resource consumers.
	MemSharesLevel *string `json:"memSharesLevel,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the resource pool.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// ResourcePoolsClientBeginCreateOptions contains the optional parameters for the ResourcePoolsClient.BeginCreate method.
type ResourcePoolsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ResourcePoolsClientBeginDeleteOptions contains the optional parameters for the ResourcePoolsClient.BeginDelete method.
type ResourcePoolsClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ResourcePoolsClientGetOptions contains the optional parameters for the ResourcePoolsClient.Get method.
type ResourcePoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourcePoolsClientListByResourceGroupOptions contains the optional parameters for the ResourcePoolsClient.ListByResourceGroup
// method.
type ResourcePoolsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ResourcePoolsClientListOptions contains the optional parameters for the ResourcePoolsClient.List method.
type ResourcePoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourcePoolsClientUpdateOptions contains the optional parameters for the ResourcePoolsClient.Update method.
type ResourcePoolsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ResourcePoolsList - List of ResourcePools.
type ResourcePoolsList struct {
	// REQUIRED; Array of ResourcePools
	Value []*ResourcePool `json:"value,omitempty"`

	// Url to follow for getting next page of ResourcePools.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceStatus - The resource status information.
type ResourceStatus struct {
	// READ-ONLY; The last update time for this condition.
	LastUpdatedAt *time.Time `json:"lastUpdatedAt,omitempty" azure:"ro"`

	// READ-ONLY; A human readable message indicating details about the status.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The reason for the condition's status.
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; Severity with which to treat failures of this type of condition.
	Severity *string `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; Status of the condition.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The type of the condition.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityProfile - Specifies the Security profile settings for the virtual machine.
type SecurityProfile struct {
	// Specifies the security settings like secure boot used while creating the virtual machine.
	UefiSettings *UefiSettings `json:"uefiSettings,omitempty"`
}

// StopVirtualMachineOptions - Defines the stop action properties.
type StopVirtualMachineOptions struct {
	// Gets or sets a value indicating whether to request non-graceful VM shutdown. True value for this flag indicates non-graceful
	// shutdown whereas false indicates otherwise. Defaults to false.
	SkipShutdown *bool `json:"skipShutdown,omitempty"`
}

// StorageProfile - Defines the resource properties.
type StorageProfile struct {
	// Gets or sets the list of virtual disks associated with the virtual machine.
	Disks []*VirtualDisk `json:"disks,omitempty"`

	// READ-ONLY; Gets or sets the list of virtual SCSI controllers associated with the virtual machine.
	ScsiControllers []*VirtualSCSIController `json:"scsiControllers,omitempty" azure:"ro"`
}

// StorageProfileUpdate - Defines the resource update properties.
type StorageProfileUpdate struct {
	// Gets or sets the list of virtual disks associated with the virtual machine.
	Disks []*VirtualDiskUpdate `json:"disks,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UefiSettings - Specifies the security settings like secure boot used while creating the virtual machine.
type UefiSettings struct {
	// Specifies whether secure boot should be enabled on the virtual machine.
	SecureBootEnabled *bool `json:"secureBootEnabled,omitempty"`
}

// VCenter - Defines the vCenter.
type VCenter struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VCenterProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VCenterProperties - Defines the resource properties.
type VCenterProperties struct {
	// REQUIRED; Gets or sets the FQDN/IPAddress of the vCenter.
	Fqdn *string `json:"fqdn,omitempty"`

	// Username / Password Credentials to connect to vcenter.
	Credentials *VICredential `json:"credentials,omitempty"`

	// Gets or sets the port of the vCenter.
	Port *int32 `json:"port,omitempty"`

	// READ-ONLY; Gets or sets the connection status to the vCenter.
	ConnectionStatus *string `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the instance UUID of the vCenter.
	InstanceUUID *string `json:"instanceUuid,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the version of the vCenter.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// VCentersClientBeginCreateOptions contains the optional parameters for the VCentersClient.BeginCreate method.
type VCentersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VCentersClientBeginDeleteOptions contains the optional parameters for the VCentersClient.BeginDelete method.
type VCentersClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VCentersClientGetOptions contains the optional parameters for the VCentersClient.Get method.
type VCentersClientGetOptions struct {
	// placeholder for future optional parameters
}

// VCentersClientListByResourceGroupOptions contains the optional parameters for the VCentersClient.ListByResourceGroup method.
type VCentersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VCentersClientListOptions contains the optional parameters for the VCentersClient.List method.
type VCentersClientListOptions struct {
	// placeholder for future optional parameters
}

// VCentersClientUpdateOptions contains the optional parameters for the VCentersClient.Update method.
type VCentersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VCentersList - List of VCenters.
type VCentersList struct {
	// REQUIRED; Array of VCenters
	Value []*VCenter `json:"value,omitempty"`

	// Url to follow for getting next page of VCenters.
	NextLink *string `json:"nextLink,omitempty"`
}

// VICredential - Username / Password Credentials to connect to vcenter.
type VICredential struct {
	// Gets or sets the password to connect with the vCenter.
	Password *string `json:"password,omitempty"`

	// Gets or sets username to connect with the vCenter.
	Username *string `json:"username,omitempty"`
}

// VirtualDisk - Virtual disk model
type VirtualDisk struct {
	// Gets or sets the controller id.
	ControllerKey *int32 `json:"controllerKey,omitempty"`

	// Gets or sets the device key value.
	DeviceKey *int32 `json:"deviceKey,omitempty"`

	// Gets or sets the device name.
	DeviceName *string `json:"deviceName,omitempty"`

	// Gets or sets the disk mode.
	DiskMode *DiskMode `json:"diskMode,omitempty"`

	// Gets or sets the disk total size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Gets or sets the disk backing type.
	DiskType *DiskType `json:"diskType,omitempty"`

	// Gets or sets the name of the virtual disk.
	Name *string `json:"name,omitempty"`

	// Gets or sets the unit number of the disk on the controller.
	UnitNumber *int32 `json:"unitNumber,omitempty"`

	// READ-ONLY; Gets or sets the disk object id.
	DiskObjectID *string `json:"diskObjectId,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the label of the virtual disk in vCenter.
	Label *string `json:"label,omitempty" azure:"ro"`
}

// VirtualDiskUpdate - Defines the virtual disk update.
type VirtualDiskUpdate struct {
	// Gets or sets the controller id.
	ControllerKey *int32 `json:"controllerKey,omitempty"`

	// Gets or sets the device key value.
	DeviceKey *int32 `json:"deviceKey,omitempty"`

	// Gets or sets the device name.
	DeviceName *string `json:"deviceName,omitempty"`

	// Gets or sets the disk mode.
	DiskMode *DiskMode `json:"diskMode,omitempty"`

	// Gets or sets the disk total size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Gets or sets the disk backing type.
	DiskType *DiskType `json:"diskType,omitempty"`

	// Gets or sets the name of the virtual disk.
	Name *string `json:"name,omitempty"`

	// Gets or sets the unit number of the disk on the controller.
	UnitNumber *int32 `json:"unitNumber,omitempty"`
}

// VirtualMachine - Define the virtualMachine.
type VirtualMachine struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineAssessPatchesResult - Describes the properties of an AssessPatches result.
type VirtualMachineAssessPatchesResult struct {
	// Summarization of patches available for installation on the machine by classification.
	AvailablePatchCountByClassification *AvailablePatchCountByClassification `json:"availablePatchCountByClassification,omitempty"`

	// READ-ONLY; The activity ID of the operation that produced this result.
	AssessmentActivityID *string `json:"assessmentActivityId,omitempty" azure:"ro"`

	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	ErrorDetails *ErrorDetail `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation finished.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The operating system type of the machine.
	OSType *OsTypeUM `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the patch service used for the operation.
	PatchServiceUsed *PatchServiceUsed `json:"patchServiceUsed,omitempty" azure:"ro"`

	// READ-ONLY; The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete
	// installation but the reboot has not yet occurred.
	RebootPending *bool `json:"rebootPending,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *time.Time `json:"startDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if operation was triggered by user or by platform.
	StartedBy *PatchOperationStartedBy `json:"startedBy,omitempty" azure:"ro"`

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Unknown", "Failed", "Succeeded", or
	// "CompletedWithWarnings."
	Status *PatchOperationStatus `json:"status,omitempty" azure:"ro"`
}

// VirtualMachineInstallPatchesParameters - Input for InstallPatches as directly received by the API
type VirtualMachineInstallPatchesParameters struct {
	// REQUIRED; Specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string
	// such as PT4H (4 hours)
	MaximumDuration *string `json:"maximumDuration,omitempty"`

	// REQUIRED; Defines when it is acceptable to reboot a VM during a software update operation.
	RebootSetting *VMGuestPatchRebootSetting `json:"rebootSetting,omitempty"`

	// Input for InstallPatches on a Linux VM, as directly received by the API
	LinuxParameters *LinuxParameters `json:"linuxParameters,omitempty"`

	// Input for InstallPatches on a Windows VM, as directly received by the API
	WindowsParameters *WindowsParameters `json:"windowsParameters,omitempty"`
}

// VirtualMachineInstallPatchesResult - The result summary of an installation operation.
type VirtualMachineInstallPatchesResult struct {
	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	ErrorDetails *ErrorDetail `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that were not installed due to the user blocking their installation.
	ExcludedPatchCount *int32 `json:"excludedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that could not be installed due to some issue. See errors for details.
	FailedPatchCount *int32 `json:"failedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The activity ID of the operation that produced this result.
	InstallationActivityID *string `json:"installationActivityId,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches successfully installed.
	InstalledPatchCount *int32 `json:"installedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation finished.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation ran out of time before it completed all its intended actions.
	MaintenanceWindowExceeded *bool `json:"maintenanceWindowExceeded,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that were detected as available for install, but did not meet the operation's criteria.
	NotSelectedPatchCount *int32 `json:"notSelectedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The operating system type of the machine.
	OSType *OsTypeUM `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the patch service used for the operation.
	PatchServiceUsed *PatchServiceUsed `json:"patchServiceUsed,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that were identified as meeting the installation criteria, but were not able to be installed.
	// Typically this happens when maintenanceWindowExceeded == true.
	PendingPatchCount *int32 `json:"pendingPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The reboot state of the VM following completion of the operation.
	RebootStatus *VMGuestPatchRebootStatus `json:"rebootStatus,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *time.Time `json:"startDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if operation was triggered by user or by platform.
	StartedBy *PatchOperationStartedBy `json:"startedBy,omitempty" azure:"ro"`

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Failed", "Succeeded", "Unknown" or "CompletedWithWarnings."
	Status *PatchOperationStatus `json:"status,omitempty" azure:"ro"`
}

// VirtualMachineInventoryItem - The VM inventory item.
type VirtualMachineInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the folder path of the vm.
	FolderPath *string `json:"folderPath,omitempty"`

	// Host inventory resource details.
	Host *InventoryItemDetails `json:"host,omitempty"`

	// Gets or sets the nic ip addresses.
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// Gets or sets the instance uuid of the vm.
	InstanceUUID *string `json:"instanceUuid,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets os name.
	OSName *string `json:"osName,omitempty"`

	// Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty"`

	// ResourcePool inventory resource details.
	ResourcePool *InventoryItemDetails `json:"resourcePool,omitempty"`

	// Gets or sets the SMBIOS UUID of the vm.
	SmbiosUUID *string `json:"smbiosUuid,omitempty"`

	// READ-ONLY; Gets the power state of the virtual machine.
	PowerState *string `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current running status of VMware Tools running in the guest operating system.
	ToolsRunningStatus *string `json:"toolsRunningStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string `json:"toolsVersion,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string `json:"toolsVersionStatus,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualMachineInventoryItem.
func (v *VirtualMachineInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		MoRefID:           v.MoRefID,
		MoName:            v.MoName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachineProperties - Defines the resource properties.
type VirtualMachineProperties struct {
	// Firmware type
	FirmwareType *FirmwareType `json:"firmwareType,omitempty"`

	// Guest agent status properties.
	GuestAgentProfile *GuestAgentProfile `json:"guestAgentProfile,omitempty"`

	// Hardware properties.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// Gets or sets the inventory Item ID for the virtual machine.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
	MoRefID *string `json:"moRefId,omitempty"`

	// Network properties.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// OS properties.
	OSProfile *OsProfile `json:"osProfile,omitempty"`

	// Placement properties.
	PlacementProfile *PlacementProfile `json:"placementProfile,omitempty"`

	// Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
	ResourcePoolID *string `json:"resourcePoolId,omitempty"`

	// Gets the security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// Gets or sets the SMBIOS UUID of the vm.
	SmbiosUUID *string `json:"smbiosUuid,omitempty"`

	// Storage properties.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// Gets or sets the ARM Id of the template resource to deploy the virtual machine.
	TemplateID *string `json:"templateId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the folder path of the vm.
	FolderPath *string `json:"folderPath,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the instance uuid of the vm.
	InstanceUUID *string `json:"instanceUuid,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the virtual machine.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the power state of the virtual machine.
	PowerState *string `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for the vm resource.
	VMID *string `json:"vmId,omitempty" azure:"ro"`
}

// VirtualMachineTemplate - Define the virtualMachineTemplate.
type VirtualMachineTemplate struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VirtualMachineTemplateProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineTemplateInventoryItem - The VM Template inventory item.
type VirtualMachineTemplateInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the folder path of the template.
	FolderPath *string `json:"folderPath,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets memory size in MBs for the template.
	MemorySizeMB *int32 `json:"memorySizeMB,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the number of vCPUs for the template.
	NumCPUs *int32 `json:"numCPUs,omitempty"`

	// Gets or sets the number of cores per socket for the template. Defaults to 1 if unspecified.
	NumCoresPerSocket *int32 `json:"numCoresPerSocket,omitempty"`

	// Gets or sets os name.
	OSName *string `json:"osName,omitempty"`

	// Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualMachineTemplateInventoryItem.
func (v *VirtualMachineTemplateInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		MoRefID:           v.MoRefID,
		MoName:            v.MoName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachineTemplateProperties - Defines the resource properties.
type VirtualMachineTemplateProperties struct {
	// Gets or sets the inventory Item ID for the virtual machine template.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine template.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this template resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the disks the template.
	Disks []*VirtualDisk `json:"disks,omitempty" azure:"ro"`

	// READ-ONLY; Firmware type
	FirmwareType *FirmwareType `json:"firmwareType,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the folder path of the template.
	FolderPath *string `json:"folderPath,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets memory size in MBs for the template.
	MemorySizeMB *int32 `json:"memorySizeMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the virtual machine template.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the network interfaces of the template.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the number of vCPUs for the template.
	NumCPUs *int32 `json:"numCPUs,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the number of cores per socket for the template. Defaults to 1 if unspecified.
	NumCoresPerSocket *int32 `json:"numCoresPerSocket,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets os name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string `json:"toolsVersion,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string `json:"toolsVersionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// VirtualMachineTemplatesClientBeginCreateOptions contains the optional parameters for the VirtualMachineTemplatesClient.BeginCreate
// method.
type VirtualMachineTemplatesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineTemplatesClientBeginDeleteOptions contains the optional parameters for the VirtualMachineTemplatesClient.BeginDelete
// method.
type VirtualMachineTemplatesClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineTemplatesClientGetOptions contains the optional parameters for the VirtualMachineTemplatesClient.Get method.
type VirtualMachineTemplatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesClientListByResourceGroupOptions contains the optional parameters for the VirtualMachineTemplatesClient.ListByResourceGroup
// method.
type VirtualMachineTemplatesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesClientListOptions contains the optional parameters for the VirtualMachineTemplatesClient.List method.
type VirtualMachineTemplatesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesClientUpdateOptions contains the optional parameters for the VirtualMachineTemplatesClient.Update
// method.
type VirtualMachineTemplatesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesList - List of VirtualMachineTemplates.
type VirtualMachineTemplatesList struct {
	// REQUIRED; Array of VirtualMachineTemplates
	Value []*VirtualMachineTemplate `json:"value,omitempty"`

	// Url to follow for getting next page of VirtualMachineTemplates.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineUpdate - Defines the virtualMachineUpdate.
type VirtualMachineUpdate struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Resource properties.
	Properties *VirtualMachineUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineUpdateProperties - Defines the resource properties.
type VirtualMachineUpdateProperties struct {
	// Defines the resource properties.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// Defines the update resource properties.
	NetworkProfile *NetworkProfileUpdate `json:"networkProfile,omitempty"`

	// OS properties.
	OSProfile *OsProfileUpdate `json:"osProfile,omitempty"`

	// Defines the resource update properties.
	StorageProfile *StorageProfileUpdate `json:"storageProfile,omitempty"`
}

// VirtualMachinesClientBeginAssessPatchesOptions contains the optional parameters for the VirtualMachinesClient.BeginAssessPatches
// method.
type VirtualMachinesClientBeginAssessPatchesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginCreateOptions contains the optional parameters for the VirtualMachinesClient.BeginCreate method.
type VirtualMachinesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeleteOptions contains the optional parameters for the VirtualMachinesClient.BeginDelete method.
type VirtualMachinesClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Whether to just disable the VM from azure and retain the VM in the VMM.
	Retain *bool
}

// VirtualMachinesClientBeginInstallPatchesOptions contains the optional parameters for the VirtualMachinesClient.BeginInstallPatches
// method.
type VirtualMachinesClientBeginInstallPatchesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRestartOptions contains the optional parameters for the VirtualMachinesClient.BeginRestart method.
type VirtualMachinesClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStartOptions contains the optional parameters for the VirtualMachinesClient.BeginStart method.
type VirtualMachinesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStopOptions contains the optional parameters for the VirtualMachinesClient.BeginStop method.
type VirtualMachinesClientBeginStopOptions struct {
	// Virtualmachine stop action payload.
	Body *StopVirtualMachineOptions
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginUpdate method.
type VirtualMachinesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListByResourceGroupOptions contains the optional parameters for the VirtualMachinesClient.ListByResourceGroup
// method.
type VirtualMachinesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListOptions contains the optional parameters for the VirtualMachinesClient.List method.
type VirtualMachinesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesList - List of VirtualMachines.
type VirtualMachinesList struct {
	// REQUIRED; Array of VirtualMachines
	Value []*VirtualMachine `json:"value,omitempty"`

	// Url to follow for getting next page of VirtualMachines.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetwork - Define the virtualNetwork.
type VirtualNetwork struct {
	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VirtualNetworkProperties `json:"properties,omitempty"`

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets or sets the Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkInventoryItem - The Virtual network inventory item.
type VirtualNetworkInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty"`

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string `json:"moName,omitempty"`

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string `json:"moRefId,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualNetworkInventoryItem.
func (v *VirtualNetworkInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		MoRefID:           v.MoRefID,
		MoName:            v.MoName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualNetworkProperties - Defines the resource properties.
type VirtualNetworkProperties struct {
	// Gets or sets the inventory Item ID for the virtual network.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual network.
	MoRefID *string `json:"moRefId,omitempty"`

	// Gets or sets the ARM Id of the vCenter resource in which this template resides.
	VCenterID *string `json:"vCenterId,omitempty"`

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string `json:"customResourceName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the virtual network.
	MoName *string `json:"moName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus `json:"statuses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// VirtualNetworksClientBeginCreateOptions contains the optional parameters for the VirtualNetworksClient.BeginCreate method.
type VirtualNetworksClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginDeleteOptions contains the optional parameters for the VirtualNetworksClient.BeginDelete method.
type VirtualNetworksClientBeginDeleteOptions struct {
	// Whether force delete was specified.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientGetOptions contains the optional parameters for the VirtualNetworksClient.Get method.
type VirtualNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListByResourceGroupOptions contains the optional parameters for the VirtualNetworksClient.ListByResourceGroup
// method.
type VirtualNetworksClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListOptions contains the optional parameters for the VirtualNetworksClient.List method.
type VirtualNetworksClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientUpdateOptions contains the optional parameters for the VirtualNetworksClient.Update method.
type VirtualNetworksClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksList - List of VirtualNetworks.
type VirtualNetworksList struct {
	// REQUIRED; Array of VirtualNetworks
	Value []*VirtualNetwork `json:"value,omitempty"`

	// Url to follow for getting next page of VirtualNetworks.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualSCSIController - This data object type contains the properties of a SCSI controller device attached to a virtual
// machine that is reported by the controller.
type VirtualSCSIController struct {
	// Gets or sets the bus number of the controller.
	BusNumber *int32 `json:"busNumber,omitempty"`

	// Gets or sets the key of the controller.
	ControllerKey *int32 `json:"controllerKey,omitempty"`

	// Gets or sets the SCSI controller unit number.
	ScsiCtlrUnitNumber *int32 `json:"scsiCtlrUnitNumber,omitempty"`

	// Gets or sets the sharing mode.
	Sharing *VirtualSCSISharing `json:"sharing,omitempty"`

	// Gets or sets the controller type.
	Type *SCSIControllerType `json:"type,omitempty"`
}

// WindowsParameters - Input for InstallPatches on a Windows VM, as directly received by the API
type WindowsParameters struct {
	// The update classifications to select when installing patches for Windows.
	ClassificationsToInclude []*VMGuestPatchClassificationWindows `json:"classificationsToInclude,omitempty"`

	// Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
	ExcludeKbsRequiringReboot *bool `json:"excludeKbsRequiringReboot,omitempty"`

	// Kbs to exclude in the patch operation
	KbNumbersToExclude []*string `json:"kbNumbersToExclude,omitempty"`

	// Kbs to include in the patch operation
	KbNumbersToInclude []*string `json:"kbNumbersToInclude,omitempty"`

	// This is used to install patches that were published on or before this given max published date.
	MaxPatchPublishDate *time.Time `json:"maxPatchPublishDate,omitempty"`
}
