//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplace

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PrivateStoreClient contains the methods for the PrivateStore group.
// Don't use this type directly, use NewPrivateStoreClient() instead.
type PrivateStoreClient struct {
	host string
	pl   runtime.Pipeline
}

// NewPrivateStoreClient creates a new instance of PrivateStoreClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPrivateStoreClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PrivateStoreClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PrivateStoreClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// AcknowledgeOfferNotification - Acknowledge notification for offer
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// offerID - The offer ID to update or delete
// options - PrivateStoreClientAcknowledgeOfferNotificationOptions contains the optional parameters for the PrivateStoreClient.AcknowledgeOfferNotification
// method.
func (client *PrivateStoreClient) AcknowledgeOfferNotification(ctx context.Context, privateStoreID string, offerID string, options *PrivateStoreClientAcknowledgeOfferNotificationOptions) (PrivateStoreClientAcknowledgeOfferNotificationResponse, error) {
	req, err := client.acknowledgeOfferNotificationCreateRequest(ctx, privateStoreID, offerID, options)
	if err != nil {
		return PrivateStoreClientAcknowledgeOfferNotificationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientAcknowledgeOfferNotificationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientAcknowledgeOfferNotificationResponse{}, runtime.NewResponseError(resp)
	}
	return PrivateStoreClientAcknowledgeOfferNotificationResponse{}, nil
}

// acknowledgeOfferNotificationCreateRequest creates the AcknowledgeOfferNotification request.
func (client *PrivateStoreClient) acknowledgeOfferNotificationCreateRequest(ctx context.Context, privateStoreID string, offerID string, options *PrivateStoreClientAcknowledgeOfferNotificationOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/offers/{offerId}/acknowledgeNotification"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if offerID == "" {
		return nil, errors.New("parameter offerID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{offerId}", url.PathEscape(offerID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// AdminRequestApprovalsList - Get list of admin request approvals
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientAdminRequestApprovalsListOptions contains the optional parameters for the PrivateStoreClient.AdminRequestApprovalsList
// method.
func (client *PrivateStoreClient) AdminRequestApprovalsList(ctx context.Context, privateStoreID string, options *PrivateStoreClientAdminRequestApprovalsListOptions) (PrivateStoreClientAdminRequestApprovalsListResponse, error) {
	req, err := client.adminRequestApprovalsListCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientAdminRequestApprovalsListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientAdminRequestApprovalsListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientAdminRequestApprovalsListResponse{}, runtime.NewResponseError(resp)
	}
	return client.adminRequestApprovalsListHandleResponse(resp)
}

// adminRequestApprovalsListCreateRequest creates the AdminRequestApprovalsList request.
func (client *PrivateStoreClient) adminRequestApprovalsListCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientAdminRequestApprovalsListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/adminRequestApprovals"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// adminRequestApprovalsListHandleResponse handles the AdminRequestApprovalsList response.
func (client *PrivateStoreClient) adminRequestApprovalsListHandleResponse(resp *http.Response) (PrivateStoreClientAdminRequestApprovalsListResponse, error) {
	result := PrivateStoreClientAdminRequestApprovalsListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdminRequestApprovalsList); err != nil {
		return PrivateStoreClientAdminRequestApprovalsListResponse{}, err
	}
	return result, nil
}

// BillingAccounts - Tenant billing accounts names
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientBillingAccountsOptions contains the optional parameters for the PrivateStoreClient.BillingAccounts
// method.
func (client *PrivateStoreClient) BillingAccounts(ctx context.Context, privateStoreID string, options *PrivateStoreClientBillingAccountsOptions) (PrivateStoreClientBillingAccountsResponse, error) {
	req, err := client.billingAccountsCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientBillingAccountsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientBillingAccountsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientBillingAccountsResponse{}, runtime.NewResponseError(resp)
	}
	return client.billingAccountsHandleResponse(resp)
}

// billingAccountsCreateRequest creates the BillingAccounts request.
func (client *PrivateStoreClient) billingAccountsCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientBillingAccountsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/billingAccounts"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// billingAccountsHandleResponse handles the BillingAccounts response.
func (client *PrivateStoreClient) billingAccountsHandleResponse(resp *http.Response) (PrivateStoreClientBillingAccountsResponse, error) {
	result := PrivateStoreClientBillingAccountsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BillingAccountsResponse); err != nil {
		return PrivateStoreClientBillingAccountsResponse{}, err
	}
	return result, nil
}

// BulkCollectionsAction - Perform an action on bulk collections
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientBulkCollectionsActionOptions contains the optional parameters for the PrivateStoreClient.BulkCollectionsAction
// method.
func (client *PrivateStoreClient) BulkCollectionsAction(ctx context.Context, privateStoreID string, options *PrivateStoreClientBulkCollectionsActionOptions) (PrivateStoreClientBulkCollectionsActionResponse, error) {
	req, err := client.bulkCollectionsActionCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientBulkCollectionsActionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientBulkCollectionsActionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientBulkCollectionsActionResponse{}, runtime.NewResponseError(resp)
	}
	return client.bulkCollectionsActionHandleResponse(resp)
}

// bulkCollectionsActionCreateRequest creates the BulkCollectionsAction request.
func (client *PrivateStoreClient) bulkCollectionsActionCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientBulkCollectionsActionOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/bulkCollectionsAction"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// bulkCollectionsActionHandleResponse handles the BulkCollectionsAction response.
func (client *PrivateStoreClient) bulkCollectionsActionHandleResponse(resp *http.Response) (PrivateStoreClientBulkCollectionsActionResponse, error) {
	result := PrivateStoreClientBulkCollectionsActionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BulkCollectionsResponse); err != nil {
		return PrivateStoreClientBulkCollectionsActionResponse{}, err
	}
	return result, nil
}

// CollectionsToSubscriptionsMapping - For a given subscriptions list, the API will return a map of collections and the related
// subscriptions from the supplied list.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientCollectionsToSubscriptionsMappingOptions contains the optional parameters for the PrivateStoreClient.CollectionsToSubscriptionsMapping
// method.
func (client *PrivateStoreClient) CollectionsToSubscriptionsMapping(ctx context.Context, privateStoreID string, options *PrivateStoreClientCollectionsToSubscriptionsMappingOptions) (PrivateStoreClientCollectionsToSubscriptionsMappingResponse, error) {
	req, err := client.collectionsToSubscriptionsMappingCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientCollectionsToSubscriptionsMappingResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientCollectionsToSubscriptionsMappingResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientCollectionsToSubscriptionsMappingResponse{}, runtime.NewResponseError(resp)
	}
	return client.collectionsToSubscriptionsMappingHandleResponse(resp)
}

// collectionsToSubscriptionsMappingCreateRequest creates the CollectionsToSubscriptionsMapping request.
func (client *PrivateStoreClient) collectionsToSubscriptionsMappingCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientCollectionsToSubscriptionsMappingOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collectionsToSubscriptionsMapping"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// collectionsToSubscriptionsMappingHandleResponse handles the CollectionsToSubscriptionsMapping response.
func (client *PrivateStoreClient) collectionsToSubscriptionsMappingHandleResponse(resp *http.Response) (PrivateStoreClientCollectionsToSubscriptionsMappingResponse, error) {
	result := PrivateStoreClientCollectionsToSubscriptionsMappingResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CollectionsToSubscriptionsMappingResponse); err != nil {
		return PrivateStoreClientCollectionsToSubscriptionsMappingResponse{}, err
	}
	return result, nil
}

// CreateApprovalRequest - Create approval request
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// requestApprovalID - The request approval ID to get create or update
// options - PrivateStoreClientCreateApprovalRequestOptions contains the optional parameters for the PrivateStoreClient.CreateApprovalRequest
// method.
func (client *PrivateStoreClient) CreateApprovalRequest(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientCreateApprovalRequestOptions) (PrivateStoreClientCreateApprovalRequestResponse, error) {
	req, err := client.createApprovalRequestCreateRequest(ctx, privateStoreID, requestApprovalID, options)
	if err != nil {
		return PrivateStoreClientCreateApprovalRequestResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientCreateApprovalRequestResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientCreateApprovalRequestResponse{}, runtime.NewResponseError(resp)
	}
	return client.createApprovalRequestHandleResponse(resp)
}

// createApprovalRequestCreateRequest creates the CreateApprovalRequest request.
func (client *PrivateStoreClient) createApprovalRequestCreateRequest(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientCreateApprovalRequestOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/requestApprovals/{requestApprovalId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if requestApprovalID == "" {
		return nil, errors.New("parameter requestApprovalID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestApprovalId}", url.PathEscape(requestApprovalID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// createApprovalRequestHandleResponse handles the CreateApprovalRequest response.
func (client *PrivateStoreClient) createApprovalRequestHandleResponse(resp *http.Response) (PrivateStoreClientCreateApprovalRequestResponse, error) {
	result := PrivateStoreClientCreateApprovalRequestResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RequestApprovalResource); err != nil {
		return PrivateStoreClientCreateApprovalRequestResponse{}, err
	}
	return result, nil
}

// CreateOrUpdate - Changes private store properties
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientCreateOrUpdateOptions contains the optional parameters for the PrivateStoreClient.CreateOrUpdate
// method.
func (client *PrivateStoreClient) CreateOrUpdate(ctx context.Context, privateStoreID string, options *PrivateStoreClientCreateOrUpdateOptions) (PrivateStoreClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return PrivateStoreClientCreateOrUpdateResponse{}, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PrivateStoreClient) createOrUpdateCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// Delete - Deletes the private store. All that is not saved will be lost.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientDeleteOptions contains the optional parameters for the PrivateStoreClient.Delete method.
func (client *PrivateStoreClient) Delete(ctx context.Context, privateStoreID string, options *PrivateStoreClientDeleteOptions) (PrivateStoreClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return PrivateStoreClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return PrivateStoreClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PrivateStoreClient) deleteCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// FetchAllSubscriptionsInTenant - Fetch all subscriptions in tenant, only for marketplace admin
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientFetchAllSubscriptionsInTenantOptions contains the optional parameters for the PrivateStoreClient.FetchAllSubscriptionsInTenant
// method.
func (client *PrivateStoreClient) FetchAllSubscriptionsInTenant(ctx context.Context, privateStoreID string, options *PrivateStoreClientFetchAllSubscriptionsInTenantOptions) (PrivateStoreClientFetchAllSubscriptionsInTenantResponse, error) {
	req, err := client.fetchAllSubscriptionsInTenantCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientFetchAllSubscriptionsInTenantResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientFetchAllSubscriptionsInTenantResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientFetchAllSubscriptionsInTenantResponse{}, runtime.NewResponseError(resp)
	}
	return client.fetchAllSubscriptionsInTenantHandleResponse(resp)
}

// fetchAllSubscriptionsInTenantCreateRequest creates the FetchAllSubscriptionsInTenant request.
func (client *PrivateStoreClient) fetchAllSubscriptionsInTenantCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientFetchAllSubscriptionsInTenantOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/fetchAllSubscriptionsInTenant"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.NextPageToken != nil {
		req.Raw().Header["next-page-token"] = []string{*options.NextPageToken}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// fetchAllSubscriptionsInTenantHandleResponse handles the FetchAllSubscriptionsInTenant response.
func (client *PrivateStoreClient) fetchAllSubscriptionsInTenantHandleResponse(resp *http.Response) (PrivateStoreClientFetchAllSubscriptionsInTenantResponse, error) {
	result := PrivateStoreClientFetchAllSubscriptionsInTenantResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsResponse); err != nil {
		return PrivateStoreClientFetchAllSubscriptionsInTenantResponse{}, err
	}
	return result, nil
}

// Get - Get information about the private store
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientGetOptions contains the optional parameters for the PrivateStoreClient.Get method.
func (client *PrivateStoreClient) Get(ctx context.Context, privateStoreID string, options *PrivateStoreClientGetOptions) (PrivateStoreClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *PrivateStoreClient) getCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PrivateStoreClient) getHandleResponse(resp *http.Response) (PrivateStoreClientGetResponse, error) {
	result := PrivateStoreClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateStore); err != nil {
		return PrivateStoreClientGetResponse{}, err
	}
	return result, nil
}

// GetAdminRequestApproval - Get open approval requests
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// adminRequestApprovalID - The admin request approval ID to get create or update
// publisherID - The publisher id of this offer.
// options - PrivateStoreClientGetAdminRequestApprovalOptions contains the optional parameters for the PrivateStoreClient.GetAdminRequestApproval
// method.
func (client *PrivateStoreClient) GetAdminRequestApproval(ctx context.Context, privateStoreID string, adminRequestApprovalID string, publisherID string, options *PrivateStoreClientGetAdminRequestApprovalOptions) (PrivateStoreClientGetAdminRequestApprovalResponse, error) {
	req, err := client.getAdminRequestApprovalCreateRequest(ctx, privateStoreID, adminRequestApprovalID, publisherID, options)
	if err != nil {
		return PrivateStoreClientGetAdminRequestApprovalResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientGetAdminRequestApprovalResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientGetAdminRequestApprovalResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAdminRequestApprovalHandleResponse(resp)
}

// getAdminRequestApprovalCreateRequest creates the GetAdminRequestApproval request.
func (client *PrivateStoreClient) getAdminRequestApprovalCreateRequest(ctx context.Context, privateStoreID string, adminRequestApprovalID string, publisherID string, options *PrivateStoreClientGetAdminRequestApprovalOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/adminRequestApprovals/{adminRequestApprovalId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if adminRequestApprovalID == "" {
		return nil, errors.New("parameter adminRequestApprovalID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{adminRequestApprovalId}", url.PathEscape(adminRequestApprovalID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	reqQP.Set("publisherId", publisherID)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAdminRequestApprovalHandleResponse handles the GetAdminRequestApproval response.
func (client *PrivateStoreClient) getAdminRequestApprovalHandleResponse(resp *http.Response) (PrivateStoreClientGetAdminRequestApprovalResponse, error) {
	result := PrivateStoreClientGetAdminRequestApprovalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdminRequestApprovalsResource); err != nil {
		return PrivateStoreClientGetAdminRequestApprovalResponse{}, err
	}
	return result, nil
}

// GetApprovalRequestsList - Get all open approval requests of current user
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientGetApprovalRequestsListOptions contains the optional parameters for the PrivateStoreClient.GetApprovalRequestsList
// method.
func (client *PrivateStoreClient) GetApprovalRequestsList(ctx context.Context, privateStoreID string, options *PrivateStoreClientGetApprovalRequestsListOptions) (PrivateStoreClientGetApprovalRequestsListResponse, error) {
	req, err := client.getApprovalRequestsListCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientGetApprovalRequestsListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientGetApprovalRequestsListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientGetApprovalRequestsListResponse{}, runtime.NewResponseError(resp)
	}
	return client.getApprovalRequestsListHandleResponse(resp)
}

// getApprovalRequestsListCreateRequest creates the GetApprovalRequestsList request.
func (client *PrivateStoreClient) getApprovalRequestsListCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientGetApprovalRequestsListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/requestApprovals"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getApprovalRequestsListHandleResponse handles the GetApprovalRequestsList response.
func (client *PrivateStoreClient) getApprovalRequestsListHandleResponse(resp *http.Response) (PrivateStoreClientGetApprovalRequestsListResponse, error) {
	result := PrivateStoreClientGetApprovalRequestsListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RequestApprovalsList); err != nil {
		return PrivateStoreClientGetApprovalRequestsListResponse{}, err
	}
	return result, nil
}

// GetRequestApproval - Get open request approval details
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// requestApprovalID - The request approval ID to get create or update
// options - PrivateStoreClientGetRequestApprovalOptions contains the optional parameters for the PrivateStoreClient.GetRequestApproval
// method.
func (client *PrivateStoreClient) GetRequestApproval(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientGetRequestApprovalOptions) (PrivateStoreClientGetRequestApprovalResponse, error) {
	req, err := client.getRequestApprovalCreateRequest(ctx, privateStoreID, requestApprovalID, options)
	if err != nil {
		return PrivateStoreClientGetRequestApprovalResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientGetRequestApprovalResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientGetRequestApprovalResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRequestApprovalHandleResponse(resp)
}

// getRequestApprovalCreateRequest creates the GetRequestApproval request.
func (client *PrivateStoreClient) getRequestApprovalCreateRequest(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientGetRequestApprovalOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/requestApprovals/{requestApprovalId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if requestApprovalID == "" {
		return nil, errors.New("parameter requestApprovalID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestApprovalId}", url.PathEscape(requestApprovalID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRequestApprovalHandleResponse handles the GetRequestApproval response.
func (client *PrivateStoreClient) getRequestApprovalHandleResponse(resp *http.Response) (PrivateStoreClientGetRequestApprovalResponse, error) {
	result := PrivateStoreClientGetRequestApprovalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RequestApprovalResource); err != nil {
		return PrivateStoreClientGetRequestApprovalResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets the list of available private stores.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// options - PrivateStoreClientListOptions contains the optional parameters for the PrivateStoreClient.List method.
func (client *PrivateStoreClient) NewListPager(options *PrivateStoreClientListOptions) *runtime.Pager[PrivateStoreClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[PrivateStoreClientListResponse]{
		More: func(page PrivateStoreClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PrivateStoreClientListResponse) (PrivateStoreClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return PrivateStoreClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PrivateStoreClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PrivateStoreClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *PrivateStoreClient) listCreateRequest(ctx context.Context, options *PrivateStoreClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.UseCache != nil {
		reqQP.Set("use-cache", *options.UseCache)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *PrivateStoreClient) listHandleResponse(resp *http.Response) (PrivateStoreClientListResponse, error) {
	result := PrivateStoreClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateStoreList); err != nil {
		return PrivateStoreClientListResponse{}, err
	}
	return result, nil
}

// ListNewPlansNotifications - List new plans notifications
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientListNewPlansNotificationsOptions contains the optional parameters for the PrivateStoreClient.ListNewPlansNotifications
// method.
func (client *PrivateStoreClient) ListNewPlansNotifications(ctx context.Context, privateStoreID string, options *PrivateStoreClientListNewPlansNotificationsOptions) (PrivateStoreClientListNewPlansNotificationsResponse, error) {
	req, err := client.listNewPlansNotificationsCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientListNewPlansNotificationsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientListNewPlansNotificationsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientListNewPlansNotificationsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listNewPlansNotificationsHandleResponse(resp)
}

// listNewPlansNotificationsCreateRequest creates the ListNewPlansNotifications request.
func (client *PrivateStoreClient) listNewPlansNotificationsCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientListNewPlansNotificationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/listNewPlansNotifications"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listNewPlansNotificationsHandleResponse handles the ListNewPlansNotifications response.
func (client *PrivateStoreClient) listNewPlansNotificationsHandleResponse(resp *http.Response) (PrivateStoreClientListNewPlansNotificationsResponse, error) {
	result := PrivateStoreClientListNewPlansNotificationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NewPlansNotificationsList); err != nil {
		return PrivateStoreClientListNewPlansNotificationsResponse{}, err
	}
	return result, nil
}

// ListStopSellOffersPlansNotifications - List stop sell notifications for both stop sell offers and stop sell plans
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientListStopSellOffersPlansNotificationsOptions contains the optional parameters for the PrivateStoreClient.ListStopSellOffersPlansNotifications
// method.
func (client *PrivateStoreClient) ListStopSellOffersPlansNotifications(ctx context.Context, privateStoreID string, options *PrivateStoreClientListStopSellOffersPlansNotificationsOptions) (PrivateStoreClientListStopSellOffersPlansNotificationsResponse, error) {
	req, err := client.listStopSellOffersPlansNotificationsCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientListStopSellOffersPlansNotificationsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientListStopSellOffersPlansNotificationsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientListStopSellOffersPlansNotificationsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listStopSellOffersPlansNotificationsHandleResponse(resp)
}

// listStopSellOffersPlansNotificationsCreateRequest creates the ListStopSellOffersPlansNotifications request.
func (client *PrivateStoreClient) listStopSellOffersPlansNotificationsCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientListStopSellOffersPlansNotificationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/listStopSellOffersPlansNotifications"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.StopSellSubscriptions != nil {
		return req, runtime.MarshalAsJSON(req, *options.StopSellSubscriptions)
	}
	return req, nil
}

// listStopSellOffersPlansNotificationsHandleResponse handles the ListStopSellOffersPlansNotifications response.
func (client *PrivateStoreClient) listStopSellOffersPlansNotificationsHandleResponse(resp *http.Response) (PrivateStoreClientListStopSellOffersPlansNotificationsResponse, error) {
	result := PrivateStoreClientListStopSellOffersPlansNotificationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StopSellOffersPlansNotificationsList); err != nil {
		return PrivateStoreClientListStopSellOffersPlansNotificationsResponse{}, err
	}
	return result, nil
}

// ListSubscriptionsContext - List all the subscriptions in the private store context
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientListSubscriptionsContextOptions contains the optional parameters for the PrivateStoreClient.ListSubscriptionsContext
// method.
func (client *PrivateStoreClient) ListSubscriptionsContext(ctx context.Context, privateStoreID string, options *PrivateStoreClientListSubscriptionsContextOptions) (PrivateStoreClientListSubscriptionsContextResponse, error) {
	req, err := client.listSubscriptionsContextCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientListSubscriptionsContextResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientListSubscriptionsContextResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientListSubscriptionsContextResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSubscriptionsContextHandleResponse(resp)
}

// listSubscriptionsContextCreateRequest creates the ListSubscriptionsContext request.
func (client *PrivateStoreClient) listSubscriptionsContextCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientListSubscriptionsContextOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/listSubscriptionsContext"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSubscriptionsContextHandleResponse handles the ListSubscriptionsContext response.
func (client *PrivateStoreClient) listSubscriptionsContextHandleResponse(resp *http.Response) (PrivateStoreClientListSubscriptionsContextResponse, error) {
	result := PrivateStoreClientListSubscriptionsContextResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsContextList); err != nil {
		return PrivateStoreClientListSubscriptionsContextResponse{}, err
	}
	return result, nil
}

// QueryApprovedPlans - Get map of plans and related approved subscriptions.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientQueryApprovedPlansOptions contains the optional parameters for the PrivateStoreClient.QueryApprovedPlans
// method.
func (client *PrivateStoreClient) QueryApprovedPlans(ctx context.Context, privateStoreID string, options *PrivateStoreClientQueryApprovedPlansOptions) (PrivateStoreClientQueryApprovedPlansResponse, error) {
	req, err := client.queryApprovedPlansCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientQueryApprovedPlansResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientQueryApprovedPlansResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientQueryApprovedPlansResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryApprovedPlansHandleResponse(resp)
}

// queryApprovedPlansCreateRequest creates the QueryApprovedPlans request.
func (client *PrivateStoreClient) queryApprovedPlansCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientQueryApprovedPlansOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/queryApprovedPlans"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// queryApprovedPlansHandleResponse handles the QueryApprovedPlans response.
func (client *PrivateStoreClient) queryApprovedPlansHandleResponse(resp *http.Response) (PrivateStoreClientQueryApprovedPlansResponse, error) {
	result := PrivateStoreClientQueryApprovedPlansResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.QueryApprovedPlansResponse); err != nil {
		return PrivateStoreClientQueryApprovedPlansResponse{}, err
	}
	return result, nil
}

// QueryNotificationsState - Get private store notifications state
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientQueryNotificationsStateOptions contains the optional parameters for the PrivateStoreClient.QueryNotificationsState
// method.
func (client *PrivateStoreClient) QueryNotificationsState(ctx context.Context, privateStoreID string, options *PrivateStoreClientQueryNotificationsStateOptions) (PrivateStoreClientQueryNotificationsStateResponse, error) {
	req, err := client.queryNotificationsStateCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientQueryNotificationsStateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientQueryNotificationsStateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientQueryNotificationsStateResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryNotificationsStateHandleResponse(resp)
}

// queryNotificationsStateCreateRequest creates the QueryNotificationsState request.
func (client *PrivateStoreClient) queryNotificationsStateCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientQueryNotificationsStateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/queryNotificationsState"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// queryNotificationsStateHandleResponse handles the QueryNotificationsState response.
func (client *PrivateStoreClient) queryNotificationsStateHandleResponse(resp *http.Response) (PrivateStoreClientQueryNotificationsStateResponse, error) {
	result := PrivateStoreClientQueryNotificationsStateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateStoreNotificationsState); err != nil {
		return PrivateStoreClientQueryNotificationsStateResponse{}, err
	}
	return result, nil
}

// QueryOffers - List of offers, regardless the collections
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// options - PrivateStoreClientQueryOffersOptions contains the optional parameters for the PrivateStoreClient.QueryOffers
// method.
func (client *PrivateStoreClient) QueryOffers(ctx context.Context, privateStoreID string, options *PrivateStoreClientQueryOffersOptions) (PrivateStoreClientQueryOffersResponse, error) {
	req, err := client.queryOffersCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreClientQueryOffersResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientQueryOffersResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientQueryOffersResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryOffersHandleResponse(resp)
}

// queryOffersCreateRequest creates the QueryOffers request.
func (client *PrivateStoreClient) queryOffersCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreClientQueryOffersOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/queryOffers"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// queryOffersHandleResponse handles the QueryOffers response.
func (client *PrivateStoreClient) queryOffersHandleResponse(resp *http.Response) (PrivateStoreClientQueryOffersResponse, error) {
	result := PrivateStoreClientQueryOffersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.QueryOffers); err != nil {
		return PrivateStoreClientQueryOffersResponse{}, err
	}
	return result, nil
}

// QueryRequestApproval - Get request statuses foreach plan, this api is used as a complex GET action.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// requestApprovalID - The request approval ID to get create or update
// options - PrivateStoreClientQueryRequestApprovalOptions contains the optional parameters for the PrivateStoreClient.QueryRequestApproval
// method.
func (client *PrivateStoreClient) QueryRequestApproval(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientQueryRequestApprovalOptions) (PrivateStoreClientQueryRequestApprovalResponse, error) {
	req, err := client.queryRequestApprovalCreateRequest(ctx, privateStoreID, requestApprovalID, options)
	if err != nil {
		return PrivateStoreClientQueryRequestApprovalResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientQueryRequestApprovalResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientQueryRequestApprovalResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryRequestApprovalHandleResponse(resp)
}

// queryRequestApprovalCreateRequest creates the QueryRequestApproval request.
func (client *PrivateStoreClient) queryRequestApprovalCreateRequest(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientQueryRequestApprovalOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/requestApprovals/{requestApprovalId}/query"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if requestApprovalID == "" {
		return nil, errors.New("parameter requestApprovalID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestApprovalId}", url.PathEscape(requestApprovalID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// queryRequestApprovalHandleResponse handles the QueryRequestApproval response.
func (client *PrivateStoreClient) queryRequestApprovalHandleResponse(resp *http.Response) (PrivateStoreClientQueryRequestApprovalResponse, error) {
	result := PrivateStoreClientQueryRequestApprovalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.QueryRequestApproval); err != nil {
		return PrivateStoreClientQueryRequestApprovalResponse{}, err
	}
	return result, nil
}

// UpdateAdminRequestApproval - Update the admin action, weather the request is approved or rejected and the approved plans
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// adminRequestApprovalID - The admin request approval ID to get create or update
// options - PrivateStoreClientUpdateAdminRequestApprovalOptions contains the optional parameters for the PrivateStoreClient.UpdateAdminRequestApproval
// method.
func (client *PrivateStoreClient) UpdateAdminRequestApproval(ctx context.Context, privateStoreID string, adminRequestApprovalID string, options *PrivateStoreClientUpdateAdminRequestApprovalOptions) (PrivateStoreClientUpdateAdminRequestApprovalResponse, error) {
	req, err := client.updateAdminRequestApprovalCreateRequest(ctx, privateStoreID, adminRequestApprovalID, options)
	if err != nil {
		return PrivateStoreClientUpdateAdminRequestApprovalResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientUpdateAdminRequestApprovalResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientUpdateAdminRequestApprovalResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateAdminRequestApprovalHandleResponse(resp)
}

// updateAdminRequestApprovalCreateRequest creates the UpdateAdminRequestApproval request.
func (client *PrivateStoreClient) updateAdminRequestApprovalCreateRequest(ctx context.Context, privateStoreID string, adminRequestApprovalID string, options *PrivateStoreClientUpdateAdminRequestApprovalOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/adminRequestApprovals/{adminRequestApprovalId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if adminRequestApprovalID == "" {
		return nil, errors.New("parameter adminRequestApprovalID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{adminRequestApprovalId}", url.PathEscape(adminRequestApprovalID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// updateAdminRequestApprovalHandleResponse handles the UpdateAdminRequestApproval response.
func (client *PrivateStoreClient) updateAdminRequestApprovalHandleResponse(resp *http.Response) (PrivateStoreClientUpdateAdminRequestApprovalResponse, error) {
	result := PrivateStoreClientUpdateAdminRequestApprovalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdminRequestApprovalsResource); err != nil {
		return PrivateStoreClientUpdateAdminRequestApprovalResponse{}, err
	}
	return result, nil
}

// WithdrawPlan - Withdraw a user request approval on specific plan
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// requestApprovalID - The request approval ID to get create or update
// options - PrivateStoreClientWithdrawPlanOptions contains the optional parameters for the PrivateStoreClient.WithdrawPlan
// method.
func (client *PrivateStoreClient) WithdrawPlan(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientWithdrawPlanOptions) (PrivateStoreClientWithdrawPlanResponse, error) {
	req, err := client.withdrawPlanCreateRequest(ctx, privateStoreID, requestApprovalID, options)
	if err != nil {
		return PrivateStoreClientWithdrawPlanResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreClientWithdrawPlanResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreClientWithdrawPlanResponse{}, runtime.NewResponseError(resp)
	}
	return PrivateStoreClientWithdrawPlanResponse{}, nil
}

// withdrawPlanCreateRequest creates the WithdrawPlan request.
func (client *PrivateStoreClient) withdrawPlanCreateRequest(ctx context.Context, privateStoreID string, requestApprovalID string, options *PrivateStoreClientWithdrawPlanOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/requestApprovals/{requestApprovalId}/withdrawPlan"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if requestApprovalID == "" {
		return nil, errors.New("parameter requestApprovalID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestApprovalId}", url.PathEscape(requestApprovalID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}
