# OpenbaoClient::RadiusConfigureRequest

## Properties

| Name | Type | Description | Notes |
| ---- | ---- | ----------- | ----- |
| **dial_timeout** | **Integer** | Number of seconds before connect times out (default: 10) | [optional][default to 10] |
| **host** | **String** | RADIUS server host | [optional] |
| **nas_identifier** | **String** | RADIUS NAS Identifier field (optional) | [optional][default to &#39;&#39;] |
| **nas_port** | **Integer** | RADIUS NAS port field (default: 10) | [optional][default to 10] |
| **port** | **Integer** | RADIUS server port (default: 1812) | [optional][default to 1812] |
| **read_timeout** | **Integer** | Number of seconds before response times out (default: 10) | [optional][default to 10] |
| **secret** | **String** | Secret shared with the RADIUS server | [optional] |
| **token_bound_cidrs** | **Array&lt;String&gt;** | Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token. | [optional] |
| **token_explicit_max_ttl** | **Integer** | If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed. | [optional] |
| **token_max_ttl** | **Integer** | The maximum lifetime of the generated token | [optional] |
| **token_no_default_policy** | **Boolean** | If true, the &#39;default&#39; policy will not automatically be added to generated tokens | [optional] |
| **token_num_uses** | **Integer** | The maximum number of times a token may be used, a value of zero means unlimited | [optional] |
| **token_period** | **Integer** | If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. \&quot;24h\&quot;). | [optional] |
| **token_policies** | **Array&lt;String&gt;** | Comma-separated list of policies. This will apply to all tokens generated by this auth method, in addition to any configured for specific users. | [optional] |
| **token_strictly_bind_ip** | **Boolean** | If true, CIDRs for the token will be strictly bound to the source IP address of the login request | [optional] |
| **token_ttl** | **Integer** | The initial ttl of the token to generate | [optional] |
| **token_type** | **String** | The type of token to generate, service or batch | [optional][default to &#39;default-service&#39;] |
| **unregistered_user_policies** | **String** | Comma-separated list of policies to grant upon successful RADIUS authentication of an unregistered user (default: empty) | [optional][default to &#39;&#39;] |

## Example

```ruby
require 'openbao_client'

instance = OpenbaoClient::RadiusConfigureRequest.new(
  dial_timeout: null,
  host: null,
  nas_identifier: null,
  nas_port: null,
  port: null,
  read_timeout: null,
  secret: null,
  token_bound_cidrs: null,
  token_explicit_max_ttl: null,
  token_max_ttl: null,
  token_no_default_policy: null,
  token_num_uses: null,
  token_period: null,
  token_policies: null,
  token_strictly_bind_ip: null,
  token_ttl: null,
  token_type: null,
  unregistered_user_policies: null
)
```

