// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace GLib {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Application : GLib.Object, GLib.IActionGroup, GLib.IActionMap {

		public Application (IntPtr raw) : base(raw) {}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_new(IntPtr application_id, int flags);

		public Application (string application_id, GLib.ApplicationFlags flags) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Application)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("application_id");
				vals.Add (new GLib.Value (application_id));
				names.Add ("flags");
				vals.Add (new GLib.Value (flags));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_application_id = GLib.Marshaller.StringToPtrGStrdup (application_id);
			Raw = g_application_new(native_application_id, (int) flags);
			GLib.Marshaller.Free (native_application_id);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_get_application_id(IntPtr raw);

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_set_application_id(IntPtr raw, IntPtr application_id);

		[GLib.Property ("application-id")]
		public string ApplicationId {
			get  {
				IntPtr raw_ret = g_application_get_application_id(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				g_application_set_application_id(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int g_application_get_flags(IntPtr raw);

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_set_flags(IntPtr raw, int flags);

		[GLib.Property ("flags")]
		public GLib.ApplicationFlags Flags {
			get  {
				int raw_ret = g_application_get_flags(Handle);
				GLib.ApplicationFlags ret = (GLib.ApplicationFlags) raw_ret;
				return ret;
			}
			set  {
				g_application_set_flags(Handle, (int) value);
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_get_resource_base_path(IntPtr raw);

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_set_resource_base_path(IntPtr raw, IntPtr resource_path);

		[GLib.Property ("resource-base-path")]
		public string ResourceBasePath {
			get  {
				IntPtr raw_ret = g_application_get_resource_base_path(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				g_application_set_resource_base_path(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_application_get_is_registered(IntPtr raw);

		[GLib.Property ("is-registered")]
		public bool IsRegistered {
			get  {
				bool raw_ret = g_application_get_is_registered(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_application_get_is_remote(IntPtr raw);

		[GLib.Property ("is-remote")]
		public bool IsRemote {
			get  {
				bool raw_ret = g_application_get_is_remote(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint g_application_get_inactivity_timeout(IntPtr raw);

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_set_inactivity_timeout(IntPtr raw, uint inactivity_timeout);

		[GLib.Property ("inactivity-timeout")]
		public uint InactivityTimeout {
			get  {
				uint raw_ret = g_application_get_inactivity_timeout(Handle);
				uint ret = raw_ret;
				return ret;
			}
			set  {
				g_application_set_inactivity_timeout(Handle, value);
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_set_action_group(IntPtr raw, IntPtr action_group);

		[Obsolete]
		[GLib.Property ("action-group")]
		public GLib.IActionGroup ActionGroup {
			set  {
				g_application_set_action_group(Handle, value == null ? IntPtr.Zero : ((value is GLib.Object) ? (value as GLib.Object).Handle : (value as GLib.ActionGroupAdapter).Handle));
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_application_get_is_busy(IntPtr raw);

		[GLib.Property ("is-busy")]
		public bool IsBusy {
			get  {
				bool raw_ret = g_application_get_is_busy(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[GLib.Signal("command-line")]
		public event GLib.CommandLineHandler CommandLine {
			add {
				this.AddSignalHandler ("command-line", value, typeof (GLib.CommandLineArgs));
			}
			remove {
				this.RemoveSignalHandler ("command-line", value);
			}
		}

		[GLib.Signal("activate")]
		public event System.EventHandler Activated {
			add {
				this.AddSignalHandler ("activate", value);
			}
			remove {
				this.RemoveSignalHandler ("activate", value);
			}
		}

		[GLib.Signal("shutdown")]
		public event System.EventHandler Shutdown {
			add {
				this.AddSignalHandler ("shutdown", value);
			}
			remove {
				this.RemoveSignalHandler ("shutdown", value);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void OpenedSignalDelegate (IntPtr inst, IntPtr arg0, int arg1, IntPtr arg2, IntPtr gch);

		static void OpenedSignalCallback (IntPtr inst, IntPtr arg0, int arg1, IntPtr arg2, IntPtr gch)
		{
			GLib.OpenedArgs args = new GLib.OpenedArgs ();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if (sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[3];
				args.Args[0] = GLib.FileAdapter.GetObject (arg0, false);
				args.Args[1] = arg1;
				args.Args[2] = GLib.Marshaller.Utf8PtrToString (arg2);
				GLib.OpenedHandler handler = (GLib.OpenedHandler) sig.Handler;
				handler (GLib.Object.GetObject (inst), args);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.Signal("open")]
		public event GLib.OpenedHandler Opened {
			add {
				this.AddSignalHandler ("open", value, new OpenedSignalDelegate(OpenedSignalCallback));
			}
			remove {
				this.RemoveSignalHandler ("open", value);
			}
		}

		[GLib.Signal("startup")]
		public event System.EventHandler Startup {
			add {
				this.AddSignalHandler ("startup", value);
			}
			remove {
				this.RemoveSignalHandler ("startup", value);
			}
		}

		static StartupNativeDelegate Startup_cb_delegate;
		static StartupNativeDelegate StartupVMCallback {
			get {
				if (Startup_cb_delegate == null)
					Startup_cb_delegate = new StartupNativeDelegate (Startup_cb);
				return Startup_cb_delegate;
			}
		}

		static void OverrideStartup (GLib.GType gtype)
		{
			OverrideStartup (gtype, StartupVMCallback);
		}

		static void OverrideStartup (GLib.GType gtype, StartupNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("startup"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void StartupNativeDelegate (IntPtr inst);

		static void Startup_cb (IntPtr inst)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnStartup ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideStartup")]
		protected virtual void OnStartup ()
		{
			InternalStartup ();
		}

		private void InternalStartup ()
		{
			StartupNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("startup"));
				unmanaged = (StartupNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(StartupNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static ActivatedNativeDelegate Activated_cb_delegate;
		static ActivatedNativeDelegate ActivatedVMCallback {
			get {
				if (Activated_cb_delegate == null)
					Activated_cb_delegate = new ActivatedNativeDelegate (Activated_cb);
				return Activated_cb_delegate;
			}
		}

		static void OverrideActivated (GLib.GType gtype)
		{
			OverrideActivated (gtype, ActivatedVMCallback);
		}

		static void OverrideActivated (GLib.GType gtype, ActivatedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("activate"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ActivatedNativeDelegate (IntPtr inst);

		static void Activated_cb (IntPtr inst)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnActivated ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideActivated")]
		protected virtual void OnActivated ()
		{
			InternalActivated ();
		}

		private void InternalActivated ()
		{
			ActivatedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("activate"));
				unmanaged = (ActivatedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ActivatedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static OpenedNativeDelegate Opened_cb_delegate;
		static OpenedNativeDelegate OpenedVMCallback {
			get {
				if (Opened_cb_delegate == null)
					Opened_cb_delegate = new OpenedNativeDelegate (Opened_cb);
				return Opened_cb_delegate;
			}
		}

		static void OverrideOpened (GLib.GType gtype)
		{
			OverrideOpened (gtype, OpenedVMCallback);
		}

		static void OverrideOpened (GLib.GType gtype, OpenedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("open"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void OpenedNativeDelegate (IntPtr inst, IntPtr files, int n_files, IntPtr hint);

		static void Opened_cb (IntPtr inst, IntPtr files, int n_files, IntPtr hint)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnOpened (GLib.FileAdapter.GetObject (files, false), n_files, GLib.Marshaller.Utf8PtrToString (hint));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideOpened")]
		protected virtual void OnOpened (GLib.IFile files, int n_files, string hint)
		{
			InternalOpened (files, n_files, hint);
		}

		private void InternalOpened (GLib.IFile files, int n_files, string hint)
		{
			OpenedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("open"));
				unmanaged = (OpenedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(OpenedNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_hint = GLib.Marshaller.StringToPtrGStrdup (hint);
			unmanaged (this.Handle, files == null ? IntPtr.Zero : ((files is GLib.Object) ? (files as GLib.Object).Handle : (files as GLib.FileAdapter).Handle), n_files, native_hint);
			GLib.Marshaller.Free (native_hint);
		}

		static CommandLineNativeDelegate CommandLine_cb_delegate;
		static CommandLineNativeDelegate CommandLineVMCallback {
			get {
				if (CommandLine_cb_delegate == null)
					CommandLine_cb_delegate = new CommandLineNativeDelegate (CommandLine_cb);
				return CommandLine_cb_delegate;
			}
		}

		static void OverrideCommandLine (GLib.GType gtype)
		{
			OverrideCommandLine (gtype, CommandLineVMCallback);
		}

		static void OverrideCommandLine (GLib.GType gtype, CommandLineNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("command_line"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int CommandLineNativeDelegate (IntPtr inst, IntPtr command_line);

		static int CommandLine_cb (IntPtr inst, IntPtr command_line)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				int __result;
				__result = __obj.OnCommandLine (GLib.Object.GetObject(command_line) as GLib.ApplicationCommandLine);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideCommandLine")]
		protected virtual int OnCommandLine (GLib.ApplicationCommandLine command_line)
		{
			return InternalCommandLine (command_line);
		}

		private int InternalCommandLine (GLib.ApplicationCommandLine command_line)
		{
			CommandLineNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("command_line"));
				unmanaged = (CommandLineNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(CommandLineNativeDelegate));
			}
			if (unmanaged == null) return 0;

			int __result = unmanaged (this.Handle, command_line == null ? IntPtr.Zero : command_line.Handle);
			return __result;
		}

		static LocalCommandLineNativeDelegate LocalCommandLine_cb_delegate;
		static LocalCommandLineNativeDelegate LocalCommandLineVMCallback {
			get {
				if (LocalCommandLine_cb_delegate == null)
					LocalCommandLine_cb_delegate = new LocalCommandLineNativeDelegate (LocalCommandLine_cb);
				return LocalCommandLine_cb_delegate;
			}
		}

		static void OverrideLocalCommandLine (GLib.GType gtype)
		{
			OverrideLocalCommandLine (gtype, LocalCommandLineVMCallback);
		}

		static void OverrideLocalCommandLine (GLib.GType gtype, LocalCommandLineNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("local_command_line"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool LocalCommandLineNativeDelegate (IntPtr inst, IntPtr arguments, out int exit_status);

		static bool LocalCommandLine_cb (IntPtr inst, IntPtr arguments, out int exit_status)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				bool __result;
				__result = __obj.OnLocalCommandLine (GLib.Marshaller.PtrToStringGFree(arguments), out exit_status);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideLocalCommandLine")]
		protected virtual bool OnLocalCommandLine (string arguments, out int exit_status)
		{
			return InternalLocalCommandLine (arguments, out exit_status);
		}

		private bool InternalLocalCommandLine (string arguments, out int exit_status)
		{
			LocalCommandLineNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("local_command_line"));
				unmanaged = (LocalCommandLineNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(LocalCommandLineNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			bool __result = unmanaged (this.Handle, GLib.Marshaller.StringToPtrGStrdup(arguments), out exit_status);
			return __result;
		}

		static BeforeEmitNativeDelegate BeforeEmit_cb_delegate;
		static BeforeEmitNativeDelegate BeforeEmitVMCallback {
			get {
				if (BeforeEmit_cb_delegate == null)
					BeforeEmit_cb_delegate = new BeforeEmitNativeDelegate (BeforeEmit_cb);
				return BeforeEmit_cb_delegate;
			}
		}

		static void OverrideBeforeEmit (GLib.GType gtype)
		{
			OverrideBeforeEmit (gtype, BeforeEmitVMCallback);
		}

		static void OverrideBeforeEmit (GLib.GType gtype, BeforeEmitNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("before_emit"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void BeforeEmitNativeDelegate (IntPtr inst, IntPtr platform_data);

		static void BeforeEmit_cb (IntPtr inst, IntPtr platform_data)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnBeforeEmit (new GLib.Variant(platform_data));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideBeforeEmit")]
		protected virtual void OnBeforeEmit (GLib.Variant platform_data)
		{
			InternalBeforeEmit (platform_data);
		}

		private void InternalBeforeEmit (GLib.Variant platform_data)
		{
			BeforeEmitNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("before_emit"));
				unmanaged = (BeforeEmitNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(BeforeEmitNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, platform_data == null ? IntPtr.Zero : platform_data.Handle);
		}

		static AfterEmitNativeDelegate AfterEmit_cb_delegate;
		static AfterEmitNativeDelegate AfterEmitVMCallback {
			get {
				if (AfterEmit_cb_delegate == null)
					AfterEmit_cb_delegate = new AfterEmitNativeDelegate (AfterEmit_cb);
				return AfterEmit_cb_delegate;
			}
		}

		static void OverrideAfterEmit (GLib.GType gtype)
		{
			OverrideAfterEmit (gtype, AfterEmitVMCallback);
		}

		static void OverrideAfterEmit (GLib.GType gtype, AfterEmitNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("after_emit"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void AfterEmitNativeDelegate (IntPtr inst, IntPtr platform_data);

		static void AfterEmit_cb (IntPtr inst, IntPtr platform_data)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnAfterEmit (new GLib.Variant(platform_data));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideAfterEmit")]
		protected virtual void OnAfterEmit (GLib.Variant platform_data)
		{
			InternalAfterEmit (platform_data);
		}

		private void InternalAfterEmit (GLib.Variant platform_data)
		{
			AfterEmitNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("after_emit"));
				unmanaged = (AfterEmitNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(AfterEmitNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, platform_data == null ? IntPtr.Zero : platform_data.Handle);
		}

		static QuitMainloopNativeDelegate QuitMainloop_cb_delegate;
		static QuitMainloopNativeDelegate QuitMainloopVMCallback {
			get {
				if (QuitMainloop_cb_delegate == null)
					QuitMainloop_cb_delegate = new QuitMainloopNativeDelegate (QuitMainloop_cb);
				return QuitMainloop_cb_delegate;
			}
		}

		static void OverrideQuitMainloop (GLib.GType gtype)
		{
			OverrideQuitMainloop (gtype, QuitMainloopVMCallback);
		}

		static void OverrideQuitMainloop (GLib.GType gtype, QuitMainloopNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("quit_mainloop"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void QuitMainloopNativeDelegate (IntPtr inst);

		static void QuitMainloop_cb (IntPtr inst)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnQuitMainloop ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideQuitMainloop")]
		protected virtual void OnQuitMainloop ()
		{
			InternalQuitMainloop ();
		}

		private void InternalQuitMainloop ()
		{
			QuitMainloopNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("quit_mainloop"));
				unmanaged = (QuitMainloopNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(QuitMainloopNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static RunMainloopNativeDelegate RunMainloop_cb_delegate;
		static RunMainloopNativeDelegate RunMainloopVMCallback {
			get {
				if (RunMainloop_cb_delegate == null)
					RunMainloop_cb_delegate = new RunMainloopNativeDelegate (RunMainloop_cb);
				return RunMainloop_cb_delegate;
			}
		}

		static void OverrideRunMainloop (GLib.GType gtype)
		{
			OverrideRunMainloop (gtype, RunMainloopVMCallback);
		}

		static void OverrideRunMainloop (GLib.GType gtype, RunMainloopNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("run_mainloop"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void RunMainloopNativeDelegate (IntPtr inst);

		static void RunMainloop_cb (IntPtr inst)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnRunMainloop ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideRunMainloop")]
		protected virtual void OnRunMainloop ()
		{
			InternalRunMainloop ();
		}

		private void InternalRunMainloop ()
		{
			RunMainloopNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("run_mainloop"));
				unmanaged = (RunMainloopNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(RunMainloopNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static ShutdownNativeDelegate Shutdown_cb_delegate;
		static ShutdownNativeDelegate ShutdownVMCallback {
			get {
				if (Shutdown_cb_delegate == null)
					Shutdown_cb_delegate = new ShutdownNativeDelegate (Shutdown_cb);
				return Shutdown_cb_delegate;
			}
		}

		static void OverrideShutdown (GLib.GType gtype)
		{
			OverrideShutdown (gtype, ShutdownVMCallback);
		}

		static void OverrideShutdown (GLib.GType gtype, ShutdownNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("shutdown"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ShutdownNativeDelegate (IntPtr inst);

		static void Shutdown_cb (IntPtr inst)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnShutdown ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideShutdown")]
		protected virtual void OnShutdown ()
		{
			InternalShutdown ();
		}

		private void InternalShutdown ()
		{
			ShutdownNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("shutdown"));
				unmanaged = (ShutdownNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ShutdownNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static DbusRegisterNativeDelegate DbusRegister_cb_delegate;
		static DbusRegisterNativeDelegate DbusRegisterVMCallback {
			get {
				if (DbusRegister_cb_delegate == null)
					DbusRegister_cb_delegate = new DbusRegisterNativeDelegate (DbusRegister_cb);
				return DbusRegister_cb_delegate;
			}
		}

		static void OverrideDbusRegister (GLib.GType gtype)
		{
			OverrideDbusRegister (gtype, DbusRegisterVMCallback);
		}

		static void OverrideDbusRegister (GLib.GType gtype, DbusRegisterNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("dbus_register"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool DbusRegisterNativeDelegate (IntPtr inst, IntPtr connection, IntPtr object_path, out IntPtr error);

		static bool DbusRegister_cb (IntPtr inst, IntPtr connection, IntPtr object_path, out IntPtr error)
		{
			error = IntPtr.Zero;

			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				bool __result;
				__result = __obj.OnDbusRegister (connection == IntPtr.Zero ? null : (GLib.DBusConnection) GLib.Opaque.GetOpaque (connection, typeof (GLib.DBusConnection), false), GLib.Marshaller.Utf8PtrToString (object_path));
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideDbusRegister")]
		protected virtual bool OnDbusRegister (GLib.DBusConnection connection, string object_path)
		{
			return InternalDbusRegister (connection, object_path);
		}

		private bool InternalDbusRegister (GLib.DBusConnection connection, string object_path)
		{
			DbusRegisterNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("dbus_register"));
				unmanaged = (DbusRegisterNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DbusRegisterNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			IntPtr native_object_path = GLib.Marshaller.StringToPtrGStrdup (object_path);
			IntPtr error = IntPtr.Zero;
			bool __result = unmanaged (this.Handle, connection == null ? IntPtr.Zero : connection.Handle, native_object_path, out error);
			GLib.Marshaller.Free (native_object_path);
			return __result;
		}

		static DbusUnregisterNativeDelegate DbusUnregister_cb_delegate;
		static DbusUnregisterNativeDelegate DbusUnregisterVMCallback {
			get {
				if (DbusUnregister_cb_delegate == null)
					DbusUnregister_cb_delegate = new DbusUnregisterNativeDelegate (DbusUnregister_cb);
				return DbusUnregister_cb_delegate;
			}
		}

		static void OverrideDbusUnregister (GLib.GType gtype)
		{
			OverrideDbusUnregister (gtype, DbusUnregisterVMCallback);
		}

		static void OverrideDbusUnregister (GLib.GType gtype, DbusUnregisterNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("dbus_unregister"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DbusUnregisterNativeDelegate (IntPtr inst, IntPtr connection, IntPtr object_path);

		static void DbusUnregister_cb (IntPtr inst, IntPtr connection, IntPtr object_path)
		{
			try {
				Application __obj = GLib.Object.GetObject (inst, false) as Application;
				__obj.OnDbusUnregister (connection == IntPtr.Zero ? null : (GLib.DBusConnection) GLib.Opaque.GetOpaque (connection, typeof (GLib.DBusConnection), false), GLib.Marshaller.Utf8PtrToString (object_path));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideDbusUnregister")]
		protected virtual void OnDbusUnregister (GLib.DBusConnection connection, string object_path)
		{
			InternalDbusUnregister (connection, object_path);
		}

		private void InternalDbusUnregister (GLib.DBusConnection connection, string object_path)
		{
			DbusUnregisterNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("dbus_unregister"));
				unmanaged = (DbusUnregisterNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DbusUnregisterNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_object_path = GLib.Marshaller.StringToPtrGStrdup (object_path);
			unmanaged (this.Handle, connection == null ? IntPtr.Zero : connection.Handle, native_object_path);
			GLib.Marshaller.Free (native_object_path);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("startup"
							, GLib.Object.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // startup
							, null
							, "activate"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("activate"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // activate
							, "startup"
							, "open"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("open"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // open
							, "activate"
							, "command_line"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("command_line"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // command_line
							, "open"
							, "local_command_line"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("local_command_line"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // local_command_line
							, "command_line"
							, "before_emit"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("before_emit"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // before_emit
							, "local_command_line"
							, "after_emit"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("after_emit"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // after_emit
							, "before_emit"
							, "add_platform_data"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("add_platform_data"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // add_platform_data
							, "after_emit"
							, "quit_mainloop"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("quit_mainloop"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // quit_mainloop
							, "add_platform_data"
							, "run_mainloop"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("run_mainloop"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // run_mainloop
							, "quit_mainloop"
							, "shutdown"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("shutdown"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // shutdown
							, "run_mainloop"
							, "dbus_register"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("dbus_register"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // dbus_register
							, "shutdown"
							, "dbus_unregister"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("dbus_unregister"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // dbus_unregister
							, "dbus_register"
							, "handle_local_options"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("handle_local_options"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // handle_local_options
							, "dbus_unregister"
							, "padding"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("padding"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) * 8 // padding
							, "handle_local_options"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_activate(IntPtr raw);

		public void Activate() {
			g_application_activate(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_bind_busy_property(IntPtr raw, IntPtr objekt, IntPtr property);

		public void BindBusyProperty(IntPtr objekt, string property) {
			IntPtr native_property = GLib.Marshaller.StringToPtrGStrdup (property);
			g_application_bind_busy_property(Handle, objekt, native_property);
			GLib.Marshaller.Free (native_property);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_get_dbus_connection(IntPtr raw);

		public GLib.DBusConnection DbusConnection { 
			get {
				IntPtr raw_ret = g_application_get_dbus_connection(Handle);
				GLib.DBusConnection ret = raw_ret == IntPtr.Zero ? null : (GLib.DBusConnection) GLib.Opaque.GetOpaque (raw_ret, typeof (GLib.DBusConnection), false);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_get_dbus_object_path(IntPtr raw);

		public string DbusObjectPath { 
			get {
				IntPtr raw_ret = g_application_get_dbus_object_path(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_get_default();

		public static GLib.Application Default { 
			get {
				IntPtr raw_ret = g_application_get_default();
				GLib.Application ret = GLib.Object.GetObject(raw_ret) as GLib.Application;
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_application_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = g_application_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_hold(IntPtr raw);

		public void Hold() {
			g_application_hold(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_application_id_is_valid(IntPtr application_id);

		public static bool IdIsValid(string application_id) {
			IntPtr native_application_id = GLib.Marshaller.StringToPtrGStrdup (application_id);
			bool raw_ret = g_application_id_is_valid(native_application_id);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_application_id);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_mark_busy(IntPtr raw);

		public void MarkBusy() {
			g_application_mark_busy(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_open(IntPtr raw, IntPtr files, int n_files, IntPtr hint);

		public void Open(GLib.IFile files, int n_files, string hint) {
			IntPtr native_hint = GLib.Marshaller.StringToPtrGStrdup (hint);
			g_application_open(Handle, files == null ? IntPtr.Zero : ((files is GLib.Object) ? (files as GLib.Object).Handle : (files as GLib.FileAdapter).Handle), n_files, native_hint);
			GLib.Marshaller.Free (native_hint);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_quit(IntPtr raw);

		public void Quit() {
			g_application_quit(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool g_application_register(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public unsafe bool Register(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_application_register(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_release(IntPtr raw);

		public void Release() {
			g_application_release(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_send_notification(IntPtr raw, IntPtr id, IntPtr notification);

		public void SendNotification(string id, GLib.Notification notification) {
			IntPtr native_id = GLib.Marshaller.StringToPtrGStrdup (id);
			g_application_send_notification(Handle, native_id, notification == null ? IntPtr.Zero : notification.Handle);
			GLib.Marshaller.Free (native_id);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_set_default(IntPtr raw);

		public void SetDefault() {
			g_application_set_default(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_unbind_busy_property(IntPtr raw, IntPtr objekt, IntPtr property);

		public void UnbindBusyProperty(IntPtr objekt, string property) {
			IntPtr native_property = GLib.Marshaller.StringToPtrGStrdup (property);
			g_application_unbind_busy_property(Handle, objekt, native_property);
			GLib.Marshaller.Free (native_property);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_unmark_busy(IntPtr raw);

		public void UnmarkBusy() {
			g_application_unmark_busy(Handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_application_withdraw_notification(IntPtr raw, IntPtr id);

		public void WithdrawNotification(string id) {
			IntPtr native_id = GLib.Marshaller.StringToPtrGStrdup (id);
			g_application_withdraw_notification(Handle, native_id);
			GLib.Marshaller.Free (native_id);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_group_action_added(IntPtr raw, IntPtr action_name);

		public void EmitActionAdded(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_group_action_added(Handle, native_action_name);
			GLib.Marshaller.Free (native_action_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_group_action_enabled_changed(IntPtr raw, IntPtr action_name, bool enabled);

		public void EmitActionEnabledChanged(string action_name, bool enabled) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_group_action_enabled_changed(Handle, native_action_name, enabled);
			GLib.Marshaller.Free (native_action_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_group_action_removed(IntPtr raw, IntPtr action_name);

		public void EmitActionRemoved(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_group_action_removed(Handle, native_action_name);
			GLib.Marshaller.Free (native_action_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_group_action_state_changed(IntPtr raw, IntPtr action_name, IntPtr state);

		public void EmitActionStateChanged(string action_name, GLib.Variant state) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_group_action_state_changed(Handle, native_action_name, state == null ? IntPtr.Zero : state.Handle);
			GLib.Marshaller.Free (native_action_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_group_activate_action(IntPtr raw, IntPtr action_name, IntPtr parameter);

		public void ActivateAction(string action_name, GLib.Variant parameter) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_group_activate_action(Handle, native_action_name, parameter == null ? IntPtr.Zero : parameter.Handle);
			GLib.Marshaller.Free (native_action_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_group_change_action_state(IntPtr raw, IntPtr action_name, IntPtr value);

		public void ChangeActionState(string action_name, GLib.Variant value) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_group_change_action_state(Handle, native_action_name, value == null ? IntPtr.Zero : value.Handle);
			GLib.Marshaller.Free (native_action_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_action_group_get_action_enabled(IntPtr raw, IntPtr action_name);

		public bool GetActionEnabled(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			bool raw_ret = g_action_group_get_action_enabled(Handle, native_action_name);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_action_group_get_action_parameter_type(IntPtr raw, IntPtr action_name);

		public GLib.VariantType GetActionParameterType(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			IntPtr raw_ret = g_action_group_get_action_parameter_type(Handle, native_action_name);
			GLib.VariantType ret = new GLib.VariantType(raw_ret);
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_action_group_get_action_state(IntPtr raw, IntPtr action_name);

		public GLib.Variant GetActionState(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			IntPtr raw_ret = g_action_group_get_action_state(Handle, native_action_name);
			GLib.Variant ret = new GLib.Variant(raw_ret);
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_action_group_get_action_state_hint(IntPtr raw, IntPtr action_name);

		public GLib.Variant GetActionStateHint(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			IntPtr raw_ret = g_action_group_get_action_state_hint(Handle, native_action_name);
			GLib.Variant ret = new GLib.Variant(raw_ret);
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_action_group_get_action_state_type(IntPtr raw, IntPtr action_name);

		public GLib.VariantType GetActionStateType(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			IntPtr raw_ret = g_action_group_get_action_state_type(Handle, native_action_name);
			GLib.VariantType ret = new GLib.VariantType(raw_ret);
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_action_group_has_action(IntPtr raw, IntPtr action_name);

		public bool HasAction(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			bool raw_ret = g_action_group_has_action(Handle, native_action_name);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_action_group_list_actions(IntPtr raw);

		public string ListActions() {
			IntPtr raw_ret = g_action_group_list_actions(Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_action_group_query_action(IntPtr raw, IntPtr action_name, out bool enabled, IntPtr parameter_type, IntPtr state_type, IntPtr state_hint, IntPtr state);

		public bool QueryAction(string action_name, out bool enabled, GLib.VariantType parameter_type, GLib.VariantType state_type, GLib.Variant state_hint, GLib.Variant state) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			bool raw_ret = g_action_group_query_action(Handle, native_action_name, out enabled, parameter_type == null ? IntPtr.Zero : parameter_type.Handle, state_type == null ? IntPtr.Zero : state_type.Handle, state_hint == null ? IntPtr.Zero : state_hint.Handle, state == null ? IntPtr.Zero : state.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[GLib.Signal("action-added")]
		public event GLib.ActionAddedHandler ActionAdded {
			add {
				this.AddSignalHandler ("action-added", value, typeof (GLib.ActionAddedArgs));
			}
			remove {
				this.RemoveSignalHandler ("action-added", value);
			}
		}

		[GLib.Signal("action-state-changed")]
		public event GLib.ActionStateChangedHandler ActionStateChanged {
			add {
				this.AddSignalHandler ("action-state-changed", value, typeof (GLib.ActionStateChangedArgs));
			}
			remove {
				this.RemoveSignalHandler ("action-state-changed", value);
			}
		}

		[GLib.Signal("action-enabled-changed")]
		public event GLib.ActionEnabledChangedHandler ActionEnabledChanged {
			add {
				this.AddSignalHandler ("action-enabled-changed", value, typeof (GLib.ActionEnabledChangedArgs));
			}
			remove {
				this.RemoveSignalHandler ("action-enabled-changed", value);
			}
		}

		[GLib.Signal("action-removed")]
		public event GLib.ActionRemovedHandler ActionRemoved {
			add {
				this.AddSignalHandler ("action-removed", value, typeof (GLib.ActionRemovedArgs));
			}
			remove {
				this.RemoveSignalHandler ("action-removed", value);
			}
		}

		static ActionAddedNativeDelegate ActionAdded_cb_delegate;
		static ActionAddedNativeDelegate ActionAddedVMCallback {
			get {
				if (ActionAdded_cb_delegate == null)
					ActionAdded_cb_delegate = new ActionAddedNativeDelegate (ActionAdded_cb);
				return ActionAdded_cb_delegate;
			}
		}

		static void OverrideActionAdded (GLib.GType gtype)
		{
			OverrideActionAdded (gtype, ActionAddedVMCallback);
		}

		static void OverrideActionAdded (GLib.GType gtype, ActionAddedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "action-added", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ActionAddedNativeDelegate (IntPtr inst, IntPtr action_name);

		static void ActionAdded_cb (IntPtr inst, IntPtr action_name)
		{
			try {
				GLib.Application __obj = GLib.Object.GetObject (inst, false) as GLib.Application;
				__obj.OnActionAdded (GLib.Marshaller.Utf8PtrToString (action_name));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideActionAdded")]
		protected virtual void OnActionAdded (string action_name)
		{
			InternalActionAdded (action_name);
		}

		private void InternalActionAdded (string action_name)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (action_name);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static ActionRemovedNativeDelegate ActionRemoved_cb_delegate;
		static ActionRemovedNativeDelegate ActionRemovedVMCallback {
			get {
				if (ActionRemoved_cb_delegate == null)
					ActionRemoved_cb_delegate = new ActionRemovedNativeDelegate (ActionRemoved_cb);
				return ActionRemoved_cb_delegate;
			}
		}

		static void OverrideActionRemoved (GLib.GType gtype)
		{
			OverrideActionRemoved (gtype, ActionRemovedVMCallback);
		}

		static void OverrideActionRemoved (GLib.GType gtype, ActionRemovedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "action-removed", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ActionRemovedNativeDelegate (IntPtr inst, IntPtr action_name);

		static void ActionRemoved_cb (IntPtr inst, IntPtr action_name)
		{
			try {
				GLib.Application __obj = GLib.Object.GetObject (inst, false) as GLib.Application;
				__obj.OnActionRemoved (GLib.Marshaller.Utf8PtrToString (action_name));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideActionRemoved")]
		protected virtual void OnActionRemoved (string action_name)
		{
			InternalActionRemoved (action_name);
		}

		private void InternalActionRemoved (string action_name)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (action_name);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static ActionEnabledChangedNativeDelegate ActionEnabledChanged_cb_delegate;
		static ActionEnabledChangedNativeDelegate ActionEnabledChangedVMCallback {
			get {
				if (ActionEnabledChanged_cb_delegate == null)
					ActionEnabledChanged_cb_delegate = new ActionEnabledChangedNativeDelegate (ActionEnabledChanged_cb);
				return ActionEnabledChanged_cb_delegate;
			}
		}

		static void OverrideActionEnabledChanged (GLib.GType gtype)
		{
			OverrideActionEnabledChanged (gtype, ActionEnabledChangedVMCallback);
		}

		static void OverrideActionEnabledChanged (GLib.GType gtype, ActionEnabledChangedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "action-enabled-changed", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ActionEnabledChangedNativeDelegate (IntPtr inst, IntPtr action_name, bool enabled);

		static void ActionEnabledChanged_cb (IntPtr inst, IntPtr action_name, bool enabled)
		{
			try {
				GLib.Application __obj = GLib.Object.GetObject (inst, false) as GLib.Application;
				__obj.OnActionEnabledChanged (GLib.Marshaller.Utf8PtrToString (action_name), enabled);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideActionEnabledChanged")]
		protected virtual void OnActionEnabledChanged (string action_name, bool enabled)
		{
			InternalActionEnabledChanged (action_name, enabled);
		}

		private void InternalActionEnabledChanged (string action_name, bool enabled)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (3);
			GLib.Value[] vals = new GLib.Value [3];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (action_name);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (enabled);
			inst_and_params.Append (vals [2]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static ActionStateChangedNativeDelegate ActionStateChanged_cb_delegate;
		static ActionStateChangedNativeDelegate ActionStateChangedVMCallback {
			get {
				if (ActionStateChanged_cb_delegate == null)
					ActionStateChanged_cb_delegate = new ActionStateChangedNativeDelegate (ActionStateChanged_cb);
				return ActionStateChanged_cb_delegate;
			}
		}

		static void OverrideActionStateChanged (GLib.GType gtype)
		{
			OverrideActionStateChanged (gtype, ActionStateChangedVMCallback);
		}

		static void OverrideActionStateChanged (GLib.GType gtype, ActionStateChangedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "action-state-changed", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ActionStateChangedNativeDelegate (IntPtr inst, IntPtr action_name, IntPtr state);

		static void ActionStateChanged_cb (IntPtr inst, IntPtr action_name, IntPtr state)
		{
			try {
				GLib.Application __obj = GLib.Object.GetObject (inst, false) as GLib.Application;
				__obj.OnActionStateChanged (GLib.Marshaller.Utf8PtrToString (action_name), new GLib.Variant(state));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GLib.Application), ConnectionMethod="OverrideActionStateChanged")]
		protected virtual void OnActionStateChanged (string action_name, GLib.Variant state)
		{
			InternalActionStateChanged (action_name, state);
		}

		private void InternalActionStateChanged (string action_name, GLib.Variant state)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (3);
			GLib.Value[] vals = new GLib.Value [3];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (action_name);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (state);
			inst_and_params.Append (vals [2]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_map_add_action(IntPtr raw, IntPtr action);

		public void AddAction(GLib.IAction action) {
			g_action_map_add_action(Handle, action == null ? IntPtr.Zero : ((action is GLib.Object) ? (action as GLib.Object).Handle : (action as GLib.ActionAdapter).Handle));
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_map_add_action_entries(IntPtr raw, IntPtr entries, int n_entries, IntPtr user_data);

		public void AddActionEntries(GLib.ActionEntry entries, int n_entries, IntPtr user_data) {
			IntPtr native_entries = GLib.Marshaller.StructureToPtrAlloc (entries);
			g_action_map_add_action_entries(Handle, native_entries, n_entries, user_data);
			Marshal.FreeHGlobal (native_entries);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_action_map_lookup_action(IntPtr raw, IntPtr action_name);

		public GLib.IAction LookupAction(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			IntPtr raw_ret = g_action_map_lookup_action(Handle, native_action_name);
			GLib.IAction ret = GLib.ActionAdapter.GetObject (raw_ret, false);
			GLib.Marshaller.Free (native_action_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_action_map_remove_action(IntPtr raw, IntPtr action_name);

		public void RemoveAction(string action_name) {
			IntPtr native_action_name = GLib.Marshaller.StringToPtrGStrdup (action_name);
			g_action_map_remove_action(Handle, native_action_name);
			GLib.Marshaller.Free (native_action_name);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("priv"
							, GLib.Object.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, null
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
