// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"time"
)

type Release struct {
	Common
	TagName         string        `json:"tag_name"`
	TargetCommitish string        `json:"target_commitish"`
	Name            string        `json:"name"`
	Body            string        `json:"body"`
	Draft           bool          `json:"draft"`
	Prerelease      bool          `json:"prerelease"`
	PublisherID     *Reference    `json:"publisher_id"`
	Attachments     []*Attachment `json:"attachments"`
	Created         time.Time     `json:"created"`
}

func (o Release) Equal(other Release) bool {
	return o.Common.Equal(other.Common) &&
		o.TagName == other.TagName &&
		o.TargetCommitish == other.TargetCommitish &&
		o.Name == other.Name &&
		o.Body == other.Body &&
		o.Draft == other.Draft &&
		o.Prerelease == other.Prerelease &&
		nilOrEqual(o.PublisherID, other.PublisherID) &&
		arrayEqual(o.Attachments, other.Attachments)
}

func (o *Release) GetReferences() References {
	references := o.Common.GetReferences()
	if !o.PublisherID.IsNil() {
		references = append(references, o.PublisherID)
	}
	return references
}

func (o *Release) Clone() Interface {
	clone := &Release{}
	*clone = *o
	return clone
}
