// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package repository

import (
	"context"
	"strings"
	"testing"

	"code.forgejo.org/f3/gof3/v3/logger"
	"code.forgejo.org/f3/gof3/v3/util"

	"github.com/stretchr/testify/require"
)

func Test_disableHooks(t *testing.T) {
	dir := t.TempDir()
	ctx := context.Background()
	log := logger.NewLogger()
	util.Command(ctx, log, "git", "-C", dir, "init")
	unset := "unset"
	get := func() string {
		out := util.Command(ctx, log, "git", "-C", dir, "config", "--get", "--default", unset, "core.hooksPath")
		return strings.TrimSuffix(out, "\n")
	}
	require.Equal(t, unset, get())
	enable := disableHooks(ctx, log, dir)
	require.NotEqual(t, unset, get())
	enable()
	require.Equal(t, unset, get())
}
