//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// PlansServer is a fake server for instances of the armappservice.PlansClient type.
type PlansServer struct {
	// BeginCreateOrUpdate is the fake for method PlansClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, name string, appServicePlan armappservice.Plan, options *armappservice.PlansClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappservice.PlansClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateVnetRoute is the fake for method PlansClient.CreateOrUpdateVnetRoute
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateVnetRoute func(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route armappservice.VnetRoute, options *armappservice.PlansClientCreateOrUpdateVnetRouteOptions) (resp azfake.Responder[armappservice.PlansClientCreateOrUpdateVnetRouteResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PlansClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientDeleteOptions) (resp azfake.Responder[armappservice.PlansClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteHybridConnection is the fake for method PlansClient.DeleteHybridConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteHybridConnection func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *armappservice.PlansClientDeleteHybridConnectionOptions) (resp azfake.Responder[armappservice.PlansClientDeleteHybridConnectionResponse], errResp azfake.ErrorResponder)

	// DeleteVnetRoute is the fake for method PlansClient.DeleteVnetRoute
	// HTTP status codes to indicate success: http.StatusOK
	DeleteVnetRoute func(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, options *armappservice.PlansClientDeleteVnetRouteOptions) (resp azfake.Responder[armappservice.PlansClientDeleteVnetRouteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PlansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientGetOptions) (resp azfake.Responder[armappservice.PlansClientGetResponse], errResp azfake.ErrorResponder)

	// GetHybridConnection is the fake for method PlansClient.GetHybridConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetHybridConnection func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *armappservice.PlansClientGetHybridConnectionOptions) (resp azfake.Responder[armappservice.PlansClientGetHybridConnectionResponse], errResp azfake.ErrorResponder)

	// GetHybridConnectionPlanLimit is the fake for method PlansClient.GetHybridConnectionPlanLimit
	// HTTP status codes to indicate success: http.StatusOK
	GetHybridConnectionPlanLimit func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientGetHybridConnectionPlanLimitOptions) (resp azfake.Responder[armappservice.PlansClientGetHybridConnectionPlanLimitResponse], errResp azfake.ErrorResponder)

	// GetRouteForVnet is the fake for method PlansClient.GetRouteForVnet
	// HTTP status codes to indicate success: http.StatusOK
	GetRouteForVnet func(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, options *armappservice.PlansClientGetRouteForVnetOptions) (resp azfake.Responder[armappservice.PlansClientGetRouteForVnetResponse], errResp azfake.ErrorResponder)

	// GetServerFarmSKUs is the fake for method PlansClient.GetServerFarmSKUs
	// HTTP status codes to indicate success: http.StatusOK
	GetServerFarmSKUs func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientGetServerFarmSKUsOptions) (resp azfake.Responder[armappservice.PlansClientGetServerFarmSKUsResponse], errResp azfake.ErrorResponder)

	// GetVnetFromServerFarm is the fake for method PlansClient.GetVnetFromServerFarm
	// HTTP status codes to indicate success: http.StatusOK
	GetVnetFromServerFarm func(ctx context.Context, resourceGroupName string, name string, vnetName string, options *armappservice.PlansClientGetVnetFromServerFarmOptions) (resp azfake.Responder[armappservice.PlansClientGetVnetFromServerFarmResponse], errResp azfake.ErrorResponder)

	// GetVnetGateway is the fake for method PlansClient.GetVnetGateway
	// HTTP status codes to indicate success: http.StatusOK
	GetVnetGateway func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, options *armappservice.PlansClientGetVnetGatewayOptions) (resp azfake.Responder[armappservice.PlansClientGetVnetGatewayResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PlansClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.PlansClientListOptions) (resp azfake.PagerResponder[armappservice.PlansClientListResponse])

	// NewListByResourceGroupPager is the fake for method PlansClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armappservice.PlansClientListByResourceGroupOptions) (resp azfake.PagerResponder[armappservice.PlansClientListByResourceGroupResponse])

	// ListCapabilities is the fake for method PlansClient.ListCapabilities
	// HTTP status codes to indicate success: http.StatusOK
	ListCapabilities func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientListCapabilitiesOptions) (resp azfake.Responder[armappservice.PlansClientListCapabilitiesResponse], errResp azfake.ErrorResponder)

	// ListHybridConnectionKeys is the fake for method PlansClient.ListHybridConnectionKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListHybridConnectionKeys func(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *armappservice.PlansClientListHybridConnectionKeysOptions) (resp azfake.Responder[armappservice.PlansClientListHybridConnectionKeysResponse], errResp azfake.ErrorResponder)

	// NewListHybridConnectionsPager is the fake for method PlansClient.NewListHybridConnectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHybridConnectionsPager func(resourceGroupName string, name string, options *armappservice.PlansClientListHybridConnectionsOptions) (resp azfake.PagerResponder[armappservice.PlansClientListHybridConnectionsResponse])

	// ListRoutesForVnet is the fake for method PlansClient.ListRoutesForVnet
	// HTTP status codes to indicate success: http.StatusOK
	ListRoutesForVnet func(ctx context.Context, resourceGroupName string, name string, vnetName string, options *armappservice.PlansClientListRoutesForVnetOptions) (resp azfake.Responder[armappservice.PlansClientListRoutesForVnetResponse], errResp azfake.ErrorResponder)

	// NewListUsagesPager is the fake for method PlansClient.NewListUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagesPager func(resourceGroupName string, name string, options *armappservice.PlansClientListUsagesOptions) (resp azfake.PagerResponder[armappservice.PlansClientListUsagesResponse])

	// ListVnets is the fake for method PlansClient.ListVnets
	// HTTP status codes to indicate success: http.StatusOK
	ListVnets func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientListVnetsOptions) (resp azfake.Responder[armappservice.PlansClientListVnetsResponse], errResp azfake.ErrorResponder)

	// NewListWebAppsPager is the fake for method PlansClient.NewListWebAppsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebAppsPager func(resourceGroupName string, name string, options *armappservice.PlansClientListWebAppsOptions) (resp azfake.PagerResponder[armappservice.PlansClientListWebAppsResponse])

	// NewListWebAppsByHybridConnectionPager is the fake for method PlansClient.NewListWebAppsByHybridConnectionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListWebAppsByHybridConnectionPager func(resourceGroupName string, name string, namespaceName string, relayName string, options *armappservice.PlansClientListWebAppsByHybridConnectionOptions) (resp azfake.PagerResponder[armappservice.PlansClientListWebAppsByHybridConnectionResponse])

	// RebootWorker is the fake for method PlansClient.RebootWorker
	// HTTP status codes to indicate success: http.StatusNoContent
	RebootWorker func(ctx context.Context, resourceGroupName string, name string, workerName string, options *armappservice.PlansClientRebootWorkerOptions) (resp azfake.Responder[armappservice.PlansClientRebootWorkerResponse], errResp azfake.ErrorResponder)

	// RestartWebApps is the fake for method PlansClient.RestartWebApps
	// HTTP status codes to indicate success: http.StatusNoContent
	RestartWebApps func(ctx context.Context, resourceGroupName string, name string, options *armappservice.PlansClientRestartWebAppsOptions) (resp azfake.Responder[armappservice.PlansClientRestartWebAppsResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method PlansClient.Update
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	Update func(ctx context.Context, resourceGroupName string, name string, appServicePlan armappservice.PlanPatchResource, options *armappservice.PlansClientUpdateOptions) (resp azfake.Responder[armappservice.PlansClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateVnetGateway is the fake for method PlansClient.UpdateVnetGateway
	// HTTP status codes to indicate success: http.StatusOK
	UpdateVnetGateway func(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope armappservice.VnetGateway, options *armappservice.PlansClientUpdateVnetGatewayOptions) (resp azfake.Responder[armappservice.PlansClientUpdateVnetGatewayResponse], errResp azfake.ErrorResponder)

	// UpdateVnetRoute is the fake for method PlansClient.UpdateVnetRoute
	// HTTP status codes to indicate success: http.StatusOK
	UpdateVnetRoute func(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route armappservice.VnetRoute, options *armappservice.PlansClientUpdateVnetRouteOptions) (resp azfake.Responder[armappservice.PlansClientUpdateVnetRouteResponse], errResp azfake.ErrorResponder)
}

// NewPlansServerTransport creates a new instance of PlansServerTransport with the provided implementation.
// The returned PlansServerTransport instance is connected to an instance of armappservice.PlansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPlansServerTransport(srv *PlansServer) *PlansServerTransport {
	return &PlansServerTransport{
		srv:                                   srv,
		beginCreateOrUpdate:                   newTracker[azfake.PollerResponder[armappservice.PlansClientCreateOrUpdateResponse]](),
		newListPager:                          newTracker[azfake.PagerResponder[armappservice.PlansClientListResponse]](),
		newListByResourceGroupPager:           newTracker[azfake.PagerResponder[armappservice.PlansClientListByResourceGroupResponse]](),
		newListHybridConnectionsPager:         newTracker[azfake.PagerResponder[armappservice.PlansClientListHybridConnectionsResponse]](),
		newListUsagesPager:                    newTracker[azfake.PagerResponder[armappservice.PlansClientListUsagesResponse]](),
		newListWebAppsPager:                   newTracker[azfake.PagerResponder[armappservice.PlansClientListWebAppsResponse]](),
		newListWebAppsByHybridConnectionPager: newTracker[azfake.PagerResponder[armappservice.PlansClientListWebAppsByHybridConnectionResponse]](),
	}
}

// PlansServerTransport connects instances of armappservice.PlansClient to instances of PlansServer.
// Don't use this type directly, use NewPlansServerTransport instead.
type PlansServerTransport struct {
	srv                                   *PlansServer
	beginCreateOrUpdate                   *tracker[azfake.PollerResponder[armappservice.PlansClientCreateOrUpdateResponse]]
	newListPager                          *tracker[azfake.PagerResponder[armappservice.PlansClientListResponse]]
	newListByResourceGroupPager           *tracker[azfake.PagerResponder[armappservice.PlansClientListByResourceGroupResponse]]
	newListHybridConnectionsPager         *tracker[azfake.PagerResponder[armappservice.PlansClientListHybridConnectionsResponse]]
	newListUsagesPager                    *tracker[azfake.PagerResponder[armappservice.PlansClientListUsagesResponse]]
	newListWebAppsPager                   *tracker[azfake.PagerResponder[armappservice.PlansClientListWebAppsResponse]]
	newListWebAppsByHybridConnectionPager *tracker[azfake.PagerResponder[armappservice.PlansClientListWebAppsByHybridConnectionResponse]]
}

// Do implements the policy.Transporter interface for PlansServerTransport.
func (p *PlansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PlansClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PlansClient.CreateOrUpdateVnetRoute":
		resp, err = p.dispatchCreateOrUpdateVnetRoute(req)
	case "PlansClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PlansClient.DeleteHybridConnection":
		resp, err = p.dispatchDeleteHybridConnection(req)
	case "PlansClient.DeleteVnetRoute":
		resp, err = p.dispatchDeleteVnetRoute(req)
	case "PlansClient.Get":
		resp, err = p.dispatchGet(req)
	case "PlansClient.GetHybridConnection":
		resp, err = p.dispatchGetHybridConnection(req)
	case "PlansClient.GetHybridConnectionPlanLimit":
		resp, err = p.dispatchGetHybridConnectionPlanLimit(req)
	case "PlansClient.GetRouteForVnet":
		resp, err = p.dispatchGetRouteForVnet(req)
	case "PlansClient.GetServerFarmSKUs":
		resp, err = p.dispatchGetServerFarmSKUs(req)
	case "PlansClient.GetVnetFromServerFarm":
		resp, err = p.dispatchGetVnetFromServerFarm(req)
	case "PlansClient.GetVnetGateway":
		resp, err = p.dispatchGetVnetGateway(req)
	case "PlansClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "PlansClient.NewListByResourceGroupPager":
		resp, err = p.dispatchNewListByResourceGroupPager(req)
	case "PlansClient.ListCapabilities":
		resp, err = p.dispatchListCapabilities(req)
	case "PlansClient.ListHybridConnectionKeys":
		resp, err = p.dispatchListHybridConnectionKeys(req)
	case "PlansClient.NewListHybridConnectionsPager":
		resp, err = p.dispatchNewListHybridConnectionsPager(req)
	case "PlansClient.ListRoutesForVnet":
		resp, err = p.dispatchListRoutesForVnet(req)
	case "PlansClient.NewListUsagesPager":
		resp, err = p.dispatchNewListUsagesPager(req)
	case "PlansClient.ListVnets":
		resp, err = p.dispatchListVnets(req)
	case "PlansClient.NewListWebAppsPager":
		resp, err = p.dispatchNewListWebAppsPager(req)
	case "PlansClient.NewListWebAppsByHybridConnectionPager":
		resp, err = p.dispatchNewListWebAppsByHybridConnectionPager(req)
	case "PlansClient.RebootWorker":
		resp, err = p.dispatchRebootWorker(req)
	case "PlansClient.RestartWebApps":
		resp, err = p.dispatchRestartWebApps(req)
	case "PlansClient.Update":
		resp, err = p.dispatchUpdate(req)
	case "PlansClient.UpdateVnetGateway":
		resp, err = p.dispatchUpdateVnetGateway(req)
	case "PlansClient.UpdateVnetRoute":
		resp, err = p.dispatchUpdateVnetRoute(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PlansServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.Plan](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PlansServerTransport) dispatchCreateOrUpdateVnetRoute(req *http.Request) (*http.Response, error) {
	if p.srv.CreateOrUpdateVnetRoute == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateVnetRoute not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routes/(?P<routeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetRoute](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	routeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CreateOrUpdateVnetRoute(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, routeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetRoute, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchDeleteHybridConnection(req *http.Request) (*http.Response, error) {
	if p.srv.DeleteHybridConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteHybridConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.DeleteHybridConnection(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchDeleteVnetRoute(req *http.Request) (*http.Response, error) {
	if p.srv.DeleteVnetRoute == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteVnetRoute not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routes/(?P<routeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	routeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.DeleteVnetRoute(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, routeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Plan, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGetHybridConnection(req *http.Request) (*http.Response, error) {
	if p.srv.GetHybridConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHybridConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetHybridConnection(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGetHybridConnectionPlanLimit(req *http.Request) (*http.Response, error) {
	if p.srv.GetHybridConnectionPlanLimit == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetHybridConnectionPlanLimit not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionPlanLimits/limit`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetHybridConnectionPlanLimit(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnectionLimits, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGetRouteForVnet(req *http.Request) (*http.Response, error) {
	if p.srv.GetRouteForVnet == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRouteForVnet not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routes/(?P<routeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	routeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetRouteForVnet(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, routeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetRouteArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGetServerFarmSKUs(req *http.Request) (*http.Response, error) {
	if p.srv.GetServerFarmSKUs == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetServerFarmSKUs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetServerFarmSKUs(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGetVnetFromServerFarm(req *http.Request) (*http.Response, error) {
	if p.srv.GetVnetFromServerFarm == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVnetFromServerFarm not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetVnetFromServerFarm(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchGetVnetGateway(req *http.Request) (*http.Response, error) {
	if p.srv.GetVnetGateway == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVnetGateway not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gateways/(?P<gatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	gatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetVnetGateway(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, gatewayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		detailedUnescaped, err := url.QueryUnescape(qp.Get("detailed"))
		if err != nil {
			return nil, err
		}
		detailedParam, err := parseOptional(detailedUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armappservice.PlansClientListOptions
		if detailedParam != nil {
			options = &armappservice.PlansClientListOptions{
				Detailed: detailedParam,
			}
		}
		resp := p.srv.NewListPager(options)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.PlansClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := p.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		p.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armappservice.PlansClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		p.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchListCapabilities(req *http.Request) (*http.Response, error) {
	if p.srv.ListCapabilities == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListCapabilities not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListCapabilities(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CapabilityArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchListHybridConnectionKeys(req *http.Request) (*http.Response, error) {
	if p.srv.ListHybridConnectionKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListHybridConnectionKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListHybridConnectionKeys(req.Context(), resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridConnectionKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListHybridConnectionsPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListHybridConnectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHybridConnectionsPager not implemented")}
	}
	newListHybridConnectionsPager := p.newListHybridConnectionsPager.get(req)
	if newListHybridConnectionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionRelays`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListHybridConnectionsPager(resourceGroupNameParam, nameParam, nil)
		newListHybridConnectionsPager = &resp
		p.newListHybridConnectionsPager.add(req, newListHybridConnectionsPager)
		server.PagerResponderInjectNextLinks(newListHybridConnectionsPager, req, func(page *armappservice.PlansClientListHybridConnectionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHybridConnectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListHybridConnectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHybridConnectionsPager) {
		p.newListHybridConnectionsPager.remove(req)
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchListRoutesForVnet(req *http.Request) (*http.Response, error) {
	if p.srv.ListRoutesForVnet == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRoutesForVnet not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routes`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListRoutesForVnet(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetRouteArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListUsagesPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagesPager not implemented")}
	}
	newListUsagesPager := p.newListUsagesPager.get(req)
	if newListUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.PlansClientListUsagesOptions
		if filterParam != nil {
			options = &armappservice.PlansClientListUsagesOptions{
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListUsagesPager(resourceGroupNameParam, nameParam, options)
		newListUsagesPager = &resp
		p.newListUsagesPager.add(req, newListUsagesPager)
		server.PagerResponderInjectNextLinks(newListUsagesPager, req, func(page *armappservice.PlansClientListUsagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagesPager) {
		p.newListUsagesPager.remove(req)
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchListVnets(req *http.Request) (*http.Response, error) {
	if p.srv.ListVnets == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListVnets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListVnets(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetInfoResourceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListWebAppsPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListWebAppsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebAppsPager not implemented")}
	}
	newListWebAppsPager := p.newListWebAppsPager.get(req)
	if newListWebAppsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam := getOptional(topUnescaped)
		var options *armappservice.PlansClientListWebAppsOptions
		if skipTokenParam != nil || filterParam != nil || topParam != nil {
			options = &armappservice.PlansClientListWebAppsOptions{
				SkipToken: skipTokenParam,
				Filter:    filterParam,
				Top:       topParam,
			}
		}
		resp := p.srv.NewListWebAppsPager(resourceGroupNameParam, nameParam, options)
		newListWebAppsPager = &resp
		p.newListWebAppsPager.add(req, newListWebAppsPager)
		server.PagerResponderInjectNextLinks(newListWebAppsPager, req, func(page *armappservice.PlansClientListWebAppsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebAppsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListWebAppsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebAppsPager) {
		p.newListWebAppsPager.remove(req)
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListWebAppsByHybridConnectionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListWebAppsByHybridConnectionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListWebAppsByHybridConnectionPager not implemented")}
	}
	newListWebAppsByHybridConnectionPager := p.newListWebAppsByHybridConnectionPager.get(req)
	if newListWebAppsByHybridConnectionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridConnectionNamespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relays/(?P<relayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
		if err != nil {
			return nil, err
		}
		relayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relayName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListWebAppsByHybridConnectionPager(resourceGroupNameParam, nameParam, namespaceNameParam, relayNameParam, nil)
		newListWebAppsByHybridConnectionPager = &resp
		p.newListWebAppsByHybridConnectionPager.add(req, newListWebAppsByHybridConnectionPager)
		server.PagerResponderInjectNextLinks(newListWebAppsByHybridConnectionPager, req, func(page *armappservice.PlansClientListWebAppsByHybridConnectionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListWebAppsByHybridConnectionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListWebAppsByHybridConnectionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListWebAppsByHybridConnectionPager) {
		p.newListWebAppsByHybridConnectionPager.remove(req)
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchRebootWorker(req *http.Request) (*http.Response, error) {
	if p.srv.RebootWorker == nil {
		return nil, &nonRetriableError{errors.New("fake for method RebootWorker not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workers/(?P<workerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reboot`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	workerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.RebootWorker(req.Context(), resourceGroupNameParam, nameParam, workerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchRestartWebApps(req *http.Request) (*http.Response, error) {
	if p.srv.RestartWebApps == nil {
		return nil, &nonRetriableError{errors.New("fake for method RestartWebApps not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restartSites`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	softRestartUnescaped, err := url.QueryUnescape(qp.Get("softRestart"))
	if err != nil {
		return nil, err
	}
	softRestartParam, err := parseOptional(softRestartUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armappservice.PlansClientRestartWebAppsOptions
	if softRestartParam != nil {
		options = &armappservice.PlansClientRestartWebAppsOptions{
			SoftRestart: softRestartParam,
		}
	}
	respr, errRespr := p.srv.RestartWebApps(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.PlanPatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Plan, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchUpdateVnetGateway(req *http.Request) (*http.Response, error) {
	if p.srv.UpdateVnetGateway == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateVnetGateway not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gateways/(?P<gatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetGateway](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	gatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.UpdateVnetGateway(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, gatewayNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PlansServerTransport) dispatchUpdateVnetRoute(req *http.Request) (*http.Response, error) {
	if p.srv.UpdateVnetRoute == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateVnetRoute not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/serverfarms/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkConnections/(?P<vnetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routes/(?P<routeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetRoute](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	vnetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vnetName")])
	if err != nil {
		return nil, err
	}
	routeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.UpdateVnetRoute(req.Context(), resourceGroupNameParam, nameParam, vnetNameParam, routeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetRoute, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
