//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armautomation

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
//     forms part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAccountClient creates a new instance of AccountClient.
func (c *ClientFactory) NewAccountClient() *AccountClient {
	subClient, _ := NewAccountClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewActivityClient creates a new instance of ActivityClient.
func (c *ClientFactory) NewActivityClient() *ActivityClient {
	subClient, _ := NewActivityClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAgentRegistrationInformationClient creates a new instance of AgentRegistrationInformationClient.
func (c *ClientFactory) NewAgentRegistrationInformationClient() *AgentRegistrationInformationClient {
	subClient, _ := NewAgentRegistrationInformationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCertificateClient creates a new instance of CertificateClient.
func (c *ClientFactory) NewCertificateClient() *CertificateClient {
	subClient, _ := NewCertificateClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClient creates a new instance of Client.
func (c *ClientFactory) NewClient() *Client {
	subClient, _ := NewClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConnectionClient creates a new instance of ConnectionClient.
func (c *ClientFactory) NewConnectionClient() *ConnectionClient {
	subClient, _ := NewConnectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConnectionTypeClient creates a new instance of ConnectionTypeClient.
func (c *ClientFactory) NewConnectionTypeClient() *ConnectionTypeClient {
	subClient, _ := NewConnectionTypeClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCredentialClient creates a new instance of CredentialClient.
func (c *ClientFactory) NewCredentialClient() *CredentialClient {
	subClient, _ := NewCredentialClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeletedAutomationAccountsClient creates a new instance of DeletedAutomationAccountsClient.
func (c *ClientFactory) NewDeletedAutomationAccountsClient() *DeletedAutomationAccountsClient {
	subClient, _ := NewDeletedAutomationAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDscCompilationJobClient creates a new instance of DscCompilationJobClient.
func (c *ClientFactory) NewDscCompilationJobClient() *DscCompilationJobClient {
	subClient, _ := NewDscCompilationJobClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDscCompilationJobStreamClient creates a new instance of DscCompilationJobStreamClient.
func (c *ClientFactory) NewDscCompilationJobStreamClient() *DscCompilationJobStreamClient {
	subClient, _ := NewDscCompilationJobStreamClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDscConfigurationClient creates a new instance of DscConfigurationClient.
func (c *ClientFactory) NewDscConfigurationClient() *DscConfigurationClient {
	subClient, _ := NewDscConfigurationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDscNodeClient creates a new instance of DscNodeClient.
func (c *ClientFactory) NewDscNodeClient() *DscNodeClient {
	subClient, _ := NewDscNodeClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDscNodeConfigurationClient creates a new instance of DscNodeConfigurationClient.
func (c *ClientFactory) NewDscNodeConfigurationClient() *DscNodeConfigurationClient {
	subClient, _ := NewDscNodeConfigurationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFieldsClient creates a new instance of FieldsClient.
func (c *ClientFactory) NewFieldsClient() *FieldsClient {
	subClient, _ := NewFieldsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHybridRunbookWorkerGroupClient creates a new instance of HybridRunbookWorkerGroupClient.
func (c *ClientFactory) NewHybridRunbookWorkerGroupClient() *HybridRunbookWorkerGroupClient {
	subClient, _ := NewHybridRunbookWorkerGroupClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHybridRunbookWorkersClient creates a new instance of HybridRunbookWorkersClient.
func (c *ClientFactory) NewHybridRunbookWorkersClient() *HybridRunbookWorkersClient {
	subClient, _ := NewHybridRunbookWorkersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobClient creates a new instance of JobClient.
func (c *ClientFactory) NewJobClient() *JobClient {
	subClient, _ := NewJobClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobScheduleClient creates a new instance of JobScheduleClient.
func (c *ClientFactory) NewJobScheduleClient() *JobScheduleClient {
	subClient, _ := NewJobScheduleClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobStreamClient creates a new instance of JobStreamClient.
func (c *ClientFactory) NewJobStreamClient() *JobStreamClient {
	subClient, _ := NewJobStreamClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKeysClient creates a new instance of KeysClient.
func (c *ClientFactory) NewKeysClient() *KeysClient {
	subClient, _ := NewKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLinkedWorkspaceClient creates a new instance of LinkedWorkspaceClient.
func (c *ClientFactory) NewLinkedWorkspaceClient() *LinkedWorkspaceClient {
	subClient, _ := NewLinkedWorkspaceClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewModuleClient creates a new instance of ModuleClient.
func (c *ClientFactory) NewModuleClient() *ModuleClient {
	subClient, _ := NewModuleClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNodeCountInformationClient creates a new instance of NodeCountInformationClient.
func (c *ClientFactory) NewNodeCountInformationClient() *NodeCountInformationClient {
	subClient, _ := NewNodeCountInformationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNodeReportsClient creates a new instance of NodeReportsClient.
func (c *ClientFactory) NewNodeReportsClient() *NodeReportsClient {
	subClient, _ := NewNodeReportsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewObjectDataTypesClient creates a new instance of ObjectDataTypesClient.
func (c *ClientFactory) NewObjectDataTypesClient() *ObjectDataTypesClient {
	subClient, _ := NewObjectDataTypesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPython2PackageClient creates a new instance of Python2PackageClient.
func (c *ClientFactory) NewPython2PackageClient() *Python2PackageClient {
	subClient, _ := NewPython2PackageClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRunbookClient creates a new instance of RunbookClient.
func (c *ClientFactory) NewRunbookClient() *RunbookClient {
	subClient, _ := NewRunbookClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRunbookDraftClient creates a new instance of RunbookDraftClient.
func (c *ClientFactory) NewRunbookDraftClient() *RunbookDraftClient {
	subClient, _ := NewRunbookDraftClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewScheduleClient creates a new instance of ScheduleClient.
func (c *ClientFactory) NewScheduleClient() *ScheduleClient {
	subClient, _ := NewScheduleClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSoftwareUpdateConfigurationMachineRunsClient creates a new instance of SoftwareUpdateConfigurationMachineRunsClient.
func (c *ClientFactory) NewSoftwareUpdateConfigurationMachineRunsClient() *SoftwareUpdateConfigurationMachineRunsClient {
	subClient, _ := NewSoftwareUpdateConfigurationMachineRunsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSoftwareUpdateConfigurationRunsClient creates a new instance of SoftwareUpdateConfigurationRunsClient.
func (c *ClientFactory) NewSoftwareUpdateConfigurationRunsClient() *SoftwareUpdateConfigurationRunsClient {
	subClient, _ := NewSoftwareUpdateConfigurationRunsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSoftwareUpdateConfigurationsClient creates a new instance of SoftwareUpdateConfigurationsClient.
func (c *ClientFactory) NewSoftwareUpdateConfigurationsClient() *SoftwareUpdateConfigurationsClient {
	subClient, _ := NewSoftwareUpdateConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSourceControlClient creates a new instance of SourceControlClient.
func (c *ClientFactory) NewSourceControlClient() *SourceControlClient {
	subClient, _ := NewSourceControlClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSourceControlSyncJobClient creates a new instance of SourceControlSyncJobClient.
func (c *ClientFactory) NewSourceControlSyncJobClient() *SourceControlSyncJobClient {
	subClient, _ := NewSourceControlSyncJobClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSourceControlSyncJobStreamsClient creates a new instance of SourceControlSyncJobStreamsClient.
func (c *ClientFactory) NewSourceControlSyncJobStreamsClient() *SourceControlSyncJobStreamsClient {
	subClient, _ := NewSourceControlSyncJobStreamsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStatisticsClient creates a new instance of StatisticsClient.
func (c *ClientFactory) NewStatisticsClient() *StatisticsClient {
	subClient, _ := NewStatisticsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTestJobClient creates a new instance of TestJobClient.
func (c *ClientFactory) NewTestJobClient() *TestJobClient {
	subClient, _ := NewTestJobClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTestJobStreamsClient creates a new instance of TestJobStreamsClient.
func (c *ClientFactory) NewTestJobStreamsClient() *TestJobStreamsClient {
	subClient, _ := NewTestJobStreamsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	subClient, _ := NewUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVariableClient creates a new instance of VariableClient.
func (c *ClientFactory) NewVariableClient() *VariableClient {
	subClient, _ := NewVariableClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWatcherClient creates a new instance of WatcherClient.
func (c *ClientFactory) NewWatcherClient() *WatcherClient {
	subClient, _ := NewWatcherClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWebhookClient creates a new instance of WebhookClient.
func (c *ClientFactory) NewWebhookClient() *WebhookClient {
	subClient, _ := NewWebhookClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
