//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesdatareplication

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservicesdatareplication/armrecoveryservicesdatareplication"
	moduleVersion = "v0.2.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// HealthStatus - Gets or sets the fabric health.
type HealthStatus string

const (
	HealthStatusCritical HealthStatus = "Critical"
	HealthStatusNormal   HealthStatus = "Normal"
	HealthStatusWarning  HealthStatus = "Warning"
)

// PossibleHealthStatusValues returns the possible values for the HealthStatus const type.
func PossibleHealthStatusValues() []HealthStatus {
	return []HealthStatus{
		HealthStatusCritical,
		HealthStatusNormal,
		HealthStatusWarning,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// ProtectedItemActiveLocation - Gets or sets the location of the protected item.
type ProtectedItemActiveLocation string

const (
	ProtectedItemActiveLocationPrimary  ProtectedItemActiveLocation = "Primary"
	ProtectedItemActiveLocationRecovery ProtectedItemActiveLocation = "Recovery"
)

// PossibleProtectedItemActiveLocationValues returns the possible values for the ProtectedItemActiveLocation const type.
func PossibleProtectedItemActiveLocationValues() []ProtectedItemActiveLocation {
	return []ProtectedItemActiveLocation{
		ProtectedItemActiveLocationPrimary,
		ProtectedItemActiveLocationRecovery,
	}
}

// ProtectionState - Gets or sets the protection state.
type ProtectionState string

const (
	ProtectionStateCancelFailoverFailedOnPrimary          ProtectionState = "CancelFailoverFailedOnPrimary"
	ProtectionStateCancelFailoverFailedOnRecovery         ProtectionState = "CancelFailoverFailedOnRecovery"
	ProtectionStateCancelFailoverInProgressOnPrimary      ProtectionState = "CancelFailoverInProgressOnPrimary"
	ProtectionStateCancelFailoverInProgressOnRecovery     ProtectionState = "CancelFailoverInProgressOnRecovery"
	ProtectionStateCancelFailoverStatesBegin              ProtectionState = "CancelFailoverStatesBegin"
	ProtectionStateCancelFailoverStatesEnd                ProtectionState = "CancelFailoverStatesEnd"
	ProtectionStateChangeRecoveryPointCompleted           ProtectionState = "ChangeRecoveryPointCompleted"
	ProtectionStateChangeRecoveryPointFailed              ProtectionState = "ChangeRecoveryPointFailed"
	ProtectionStateChangeRecoveryPointInitiated           ProtectionState = "ChangeRecoveryPointInitiated"
	ProtectionStateChangeRecoveryPointStatesBegin         ProtectionState = "ChangeRecoveryPointStatesBegin"
	ProtectionStateChangeRecoveryPointStatesEnd           ProtectionState = "ChangeRecoveryPointStatesEnd"
	ProtectionStateCommitFailoverCompleted                ProtectionState = "CommitFailoverCompleted"
	ProtectionStateCommitFailoverFailedOnPrimary          ProtectionState = "CommitFailoverFailedOnPrimary"
	ProtectionStateCommitFailoverFailedOnRecovery         ProtectionState = "CommitFailoverFailedOnRecovery"
	ProtectionStateCommitFailoverInProgressOnPrimary      ProtectionState = "CommitFailoverInProgressOnPrimary"
	ProtectionStateCommitFailoverInProgressOnRecovery     ProtectionState = "CommitFailoverInProgressOnRecovery"
	ProtectionStateCommitFailoverStatesBegin              ProtectionState = "CommitFailoverStatesBegin"
	ProtectionStateCommitFailoverStatesEnd                ProtectionState = "CommitFailoverStatesEnd"
	ProtectionStateDisablingFailed                        ProtectionState = "DisablingFailed"
	ProtectionStateDisablingProtection                    ProtectionState = "DisablingProtection"
	ProtectionStateEnablingFailed                         ProtectionState = "EnablingFailed"
	ProtectionStateEnablingProtection                     ProtectionState = "EnablingProtection"
	ProtectionStateInitialReplicationCompletedOnPrimary   ProtectionState = "InitialReplicationCompletedOnPrimary"
	ProtectionStateInitialReplicationCompletedOnRecovery  ProtectionState = "InitialReplicationCompletedOnRecovery"
	ProtectionStateInitialReplicationFailed               ProtectionState = "InitialReplicationFailed"
	ProtectionStateInitialReplicationInProgress           ProtectionState = "InitialReplicationInProgress"
	ProtectionStateInitialReplicationStatesBegin          ProtectionState = "InitialReplicationStatesBegin"
	ProtectionStateInitialReplicationStatesEnd            ProtectionState = "InitialReplicationStatesEnd"
	ProtectionStateMarkedForDeletion                      ProtectionState = "MarkedForDeletion"
	ProtectionStatePlannedFailoverCompleted               ProtectionState = "PlannedFailoverCompleted"
	ProtectionStatePlannedFailoverCompleting              ProtectionState = "PlannedFailoverCompleting"
	ProtectionStatePlannedFailoverCompletionFailed        ProtectionState = "PlannedFailoverCompletionFailed"
	ProtectionStatePlannedFailoverFailed                  ProtectionState = "PlannedFailoverFailed"
	ProtectionStatePlannedFailoverInitiated               ProtectionState = "PlannedFailoverInitiated"
	ProtectionStatePlannedFailoverTransitionStatesBegin   ProtectionState = "PlannedFailoverTransitionStatesBegin"
	ProtectionStatePlannedFailoverTransitionStatesEnd     ProtectionState = "PlannedFailoverTransitionStatesEnd"
	ProtectionStateProtected                              ProtectionState = "Protected"
	ProtectionStateProtectedStatesBegin                   ProtectionState = "ProtectedStatesBegin"
	ProtectionStateProtectedStatesEnd                     ProtectionState = "ProtectedStatesEnd"
	ProtectionStateReprotectFailed                        ProtectionState = "ReprotectFailed"
	ProtectionStateReprotectInitiated                     ProtectionState = "ReprotectInitiated"
	ProtectionStateReprotectStatesBegin                   ProtectionState = "ReprotectStatesBegin"
	ProtectionStateReprotectStatesEnd                     ProtectionState = "ReprotectStatesEnd"
	ProtectionStateUnplannedFailoverCompleted             ProtectionState = "UnplannedFailoverCompleted"
	ProtectionStateUnplannedFailoverCompleting            ProtectionState = "UnplannedFailoverCompleting"
	ProtectionStateUnplannedFailoverCompletionFailed      ProtectionState = "UnplannedFailoverCompletionFailed"
	ProtectionStateUnplannedFailoverFailed                ProtectionState = "UnplannedFailoverFailed"
	ProtectionStateUnplannedFailoverInitiated             ProtectionState = "UnplannedFailoverInitiated"
	ProtectionStateUnplannedFailoverTransitionStatesBegin ProtectionState = "UnplannedFailoverTransitionStatesBegin"
	ProtectionStateUnplannedFailoverTransitionStatesEnd   ProtectionState = "UnplannedFailoverTransitionStatesEnd"
	ProtectionStateUnprotectedStatesBegin                 ProtectionState = "UnprotectedStatesBegin"
	ProtectionStateUnprotectedStatesEnd                   ProtectionState = "UnprotectedStatesEnd"
)

// PossibleProtectionStateValues returns the possible values for the ProtectionState const type.
func PossibleProtectionStateValues() []ProtectionState {
	return []ProtectionState{
		ProtectionStateCancelFailoverFailedOnPrimary,
		ProtectionStateCancelFailoverFailedOnRecovery,
		ProtectionStateCancelFailoverInProgressOnPrimary,
		ProtectionStateCancelFailoverInProgressOnRecovery,
		ProtectionStateCancelFailoverStatesBegin,
		ProtectionStateCancelFailoverStatesEnd,
		ProtectionStateChangeRecoveryPointCompleted,
		ProtectionStateChangeRecoveryPointFailed,
		ProtectionStateChangeRecoveryPointInitiated,
		ProtectionStateChangeRecoveryPointStatesBegin,
		ProtectionStateChangeRecoveryPointStatesEnd,
		ProtectionStateCommitFailoverCompleted,
		ProtectionStateCommitFailoverFailedOnPrimary,
		ProtectionStateCommitFailoverFailedOnRecovery,
		ProtectionStateCommitFailoverInProgressOnPrimary,
		ProtectionStateCommitFailoverInProgressOnRecovery,
		ProtectionStateCommitFailoverStatesBegin,
		ProtectionStateCommitFailoverStatesEnd,
		ProtectionStateDisablingFailed,
		ProtectionStateDisablingProtection,
		ProtectionStateEnablingFailed,
		ProtectionStateEnablingProtection,
		ProtectionStateInitialReplicationCompletedOnPrimary,
		ProtectionStateInitialReplicationCompletedOnRecovery,
		ProtectionStateInitialReplicationFailed,
		ProtectionStateInitialReplicationInProgress,
		ProtectionStateInitialReplicationStatesBegin,
		ProtectionStateInitialReplicationStatesEnd,
		ProtectionStateMarkedForDeletion,
		ProtectionStatePlannedFailoverCompleted,
		ProtectionStatePlannedFailoverCompleting,
		ProtectionStatePlannedFailoverCompletionFailed,
		ProtectionStatePlannedFailoverFailed,
		ProtectionStatePlannedFailoverInitiated,
		ProtectionStatePlannedFailoverTransitionStatesBegin,
		ProtectionStatePlannedFailoverTransitionStatesEnd,
		ProtectionStateProtected,
		ProtectionStateProtectedStatesBegin,
		ProtectionStateProtectedStatesEnd,
		ProtectionStateReprotectFailed,
		ProtectionStateReprotectInitiated,
		ProtectionStateReprotectStatesBegin,
		ProtectionStateReprotectStatesEnd,
		ProtectionStateUnplannedFailoverCompleted,
		ProtectionStateUnplannedFailoverCompleting,
		ProtectionStateUnplannedFailoverCompletionFailed,
		ProtectionStateUnplannedFailoverFailed,
		ProtectionStateUnplannedFailoverInitiated,
		ProtectionStateUnplannedFailoverTransitionStatesBegin,
		ProtectionStateUnplannedFailoverTransitionStatesEnd,
		ProtectionStateUnprotectedStatesBegin,
		ProtectionStateUnprotectedStatesEnd,
	}
}

// ProvisioningState - Gets or sets the provisioning state of the Dra.
type ProvisioningState string

const (
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateDeleted   ProvisioningState = "Deleted"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUpdating  ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleted,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// RecoveryPointType - Gets or sets the recovery point type.
type RecoveryPointType string

const (
	RecoveryPointTypeApplicationConsistent RecoveryPointType = "ApplicationConsistent"
	RecoveryPointTypeCrashConsistent       RecoveryPointType = "CrashConsistent"
)

// PossibleRecoveryPointTypeValues returns the possible values for the RecoveryPointType const type.
func PossibleRecoveryPointTypeValues() []RecoveryPointType {
	return []RecoveryPointType{
		RecoveryPointTypeApplicationConsistent,
		RecoveryPointTypeCrashConsistent,
	}
}

// ReplicationVaultType - Gets or sets the type of vault.
type ReplicationVaultType string

const (
	ReplicationVaultTypeDisasterRecovery ReplicationVaultType = "DisasterRecovery"
	ReplicationVaultTypeMigrate          ReplicationVaultType = "Migrate"
)

// PossibleReplicationVaultTypeValues returns the possible values for the ReplicationVaultType const type.
func PossibleReplicationVaultTypeValues() []ReplicationVaultType {
	return []ReplicationVaultType{
		ReplicationVaultTypeDisasterRecovery,
		ReplicationVaultTypeMigrate,
	}
}

// ResynchronizationState - Gets or sets the resynchronization state.
type ResynchronizationState string

const (
	ResynchronizationStateNone                       ResynchronizationState = "None"
	ResynchronizationStateResynchronizationCompleted ResynchronizationState = "ResynchronizationCompleted"
	ResynchronizationStateResynchronizationFailed    ResynchronizationState = "ResynchronizationFailed"
	ResynchronizationStateResynchronizationInitiated ResynchronizationState = "ResynchronizationInitiated"
)

// PossibleResynchronizationStateValues returns the possible values for the ResynchronizationState const type.
func PossibleResynchronizationStateValues() []ResynchronizationState {
	return []ResynchronizationState{
		ResynchronizationStateNone,
		ResynchronizationStateResynchronizationCompleted,
		ResynchronizationStateResynchronizationFailed,
		ResynchronizationStateResynchronizationInitiated,
	}
}

// TaskState - Gets or sets the task state.
type TaskState string

const (
	TaskStateCancelled TaskState = "Cancelled"
	TaskStateFailed    TaskState = "Failed"
	TaskStatePending   TaskState = "Pending"
	TaskStateSkipped   TaskState = "Skipped"
	TaskStateStarted   TaskState = "Started"
	TaskStateSucceeded TaskState = "Succeeded"
)

// PossibleTaskStateValues returns the possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{
		TaskStateCancelled,
		TaskStateFailed,
		TaskStatePending,
		TaskStateSkipped,
		TaskStateStarted,
		TaskStateSucceeded,
	}
}

// TestFailoverState - Gets or sets the test failover state.
type TestFailoverState string

const (
	TestFailoverStateMarkedForDeletion             TestFailoverState = "MarkedForDeletion"
	TestFailoverStateNone                          TestFailoverState = "None"
	TestFailoverStateTestFailoverCleanupCompleting TestFailoverState = "TestFailoverCleanupCompleting"
	TestFailoverStateTestFailoverCleanupInitiated  TestFailoverState = "TestFailoverCleanupInitiated"
	TestFailoverStateTestFailoverCompleted         TestFailoverState = "TestFailoverCompleted"
	TestFailoverStateTestFailoverCompleting        TestFailoverState = "TestFailoverCompleting"
	TestFailoverStateTestFailoverCompletionFailed  TestFailoverState = "TestFailoverCompletionFailed"
	TestFailoverStateTestFailoverFailed            TestFailoverState = "TestFailoverFailed"
	TestFailoverStateTestFailoverInitiated         TestFailoverState = "TestFailoverInitiated"
)

// PossibleTestFailoverStateValues returns the possible values for the TestFailoverState const type.
func PossibleTestFailoverStateValues() []TestFailoverState {
	return []TestFailoverState{
		TestFailoverStateMarkedForDeletion,
		TestFailoverStateNone,
		TestFailoverStateTestFailoverCleanupCompleting,
		TestFailoverStateTestFailoverCleanupInitiated,
		TestFailoverStateTestFailoverCompleted,
		TestFailoverStateTestFailoverCompleting,
		TestFailoverStateTestFailoverCompletionFailed,
		TestFailoverStateTestFailoverFailed,
		TestFailoverStateTestFailoverInitiated,
	}
}

// VMNicSelection - Gets or sets the selection type of the NIC.
type VMNicSelection string

const (
	VMNicSelectionNotSelected            VMNicSelection = "NotSelected"
	VMNicSelectionSelectedByDefault      VMNicSelection = "SelectedByDefault"
	VMNicSelectionSelectedByUser         VMNicSelection = "SelectedByUser"
	VMNicSelectionSelectedByUserOverride VMNicSelection = "SelectedByUserOverride"
)

// PossibleVMNicSelectionValues returns the possible values for the VMNicSelection const type.
func PossibleVMNicSelectionValues() []VMNicSelection {
	return []VMNicSelection{
		VMNicSelectionNotSelected,
		VMNicSelectionSelectedByDefault,
		VMNicSelectionSelectedByUser,
		VMNicSelectionSelectedByUserOverride,
	}
}

// VMwareToAzureMigrateResyncState - Gets or sets the resync state.
type VMwareToAzureMigrateResyncState string

const (
	VMwareToAzureMigrateResyncStateNone                         VMwareToAzureMigrateResyncState = "None"
	VMwareToAzureMigrateResyncStatePreparedForResynchronization VMwareToAzureMigrateResyncState = "PreparedForResynchronization"
	VMwareToAzureMigrateResyncStateStartedResynchronization     VMwareToAzureMigrateResyncState = "StartedResynchronization"
)

// PossibleVMwareToAzureMigrateResyncStateValues returns the possible values for the VMwareToAzureMigrateResyncState const type.
func PossibleVMwareToAzureMigrateResyncStateValues() []VMwareToAzureMigrateResyncState {
	return []VMwareToAzureMigrateResyncState{
		VMwareToAzureMigrateResyncStateNone,
		VMwareToAzureMigrateResyncStatePreparedForResynchronization,
		VMwareToAzureMigrateResyncStateStartedResynchronization,
	}
}

// WorkflowObjectType - Gets or sets the object type.
type WorkflowObjectType string

const (
	WorkflowObjectTypeAvsDiskPool          WorkflowObjectType = "AvsDiskPool"
	WorkflowObjectTypeDra                  WorkflowObjectType = "Dra"
	WorkflowObjectTypeFabric               WorkflowObjectType = "Fabric"
	WorkflowObjectTypePolicy               WorkflowObjectType = "Policy"
	WorkflowObjectTypeProtectedItem        WorkflowObjectType = "ProtectedItem"
	WorkflowObjectTypeRecoveryPlan         WorkflowObjectType = "RecoveryPlan"
	WorkflowObjectTypeReplicationExtension WorkflowObjectType = "ReplicationExtension"
	WorkflowObjectTypeVault                WorkflowObjectType = "Vault"
)

// PossibleWorkflowObjectTypeValues returns the possible values for the WorkflowObjectType const type.
func PossibleWorkflowObjectTypeValues() []WorkflowObjectType {
	return []WorkflowObjectType{
		WorkflowObjectTypeAvsDiskPool,
		WorkflowObjectTypeDra,
		WorkflowObjectTypeFabric,
		WorkflowObjectTypePolicy,
		WorkflowObjectTypeProtectedItem,
		WorkflowObjectTypeRecoveryPlan,
		WorkflowObjectTypeReplicationExtension,
		WorkflowObjectTypeVault,
	}
}

// WorkflowState - Gets or sets the workflow state.
type WorkflowState string

const (
	WorkflowStateCancelled                WorkflowState = "Cancelled"
	WorkflowStateCancelling               WorkflowState = "Cancelling"
	WorkflowStateCompletedWithErrors      WorkflowState = "CompletedWithErrors"
	WorkflowStateCompletedWithInformation WorkflowState = "CompletedWithInformation"
	WorkflowStateCompletedWithWarnings    WorkflowState = "CompletedWithWarnings"
	WorkflowStateFailed                   WorkflowState = "Failed"
	WorkflowStatePending                  WorkflowState = "Pending"
	WorkflowStateStarted                  WorkflowState = "Started"
	WorkflowStateSucceeded                WorkflowState = "Succeeded"
)

// PossibleWorkflowStateValues returns the possible values for the WorkflowState const type.
func PossibleWorkflowStateValues() []WorkflowState {
	return []WorkflowState{
		WorkflowStateCancelled,
		WorkflowStateCancelling,
		WorkflowStateCompletedWithErrors,
		WorkflowStateCompletedWithInformation,
		WorkflowStateCompletedWithWarnings,
		WorkflowStateFailed,
		WorkflowStatePending,
		WorkflowStateStarted,
		WorkflowStateSucceeded,
	}
}
