package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// EligibleChildResourcesClient is the client for the EligibleChildResources methods of the Authorization service.
type EligibleChildResourcesClient struct {
	BaseClient
}

// NewEligibleChildResourcesClient creates an instance of the EligibleChildResourcesClient client.
func NewEligibleChildResourcesClient(subscriptionID string) EligibleChildResourcesClient {
	return NewEligibleChildResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewEligibleChildResourcesClientWithBaseURI creates an instance of the EligibleChildResourcesClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewEligibleChildResourcesClientWithBaseURI(baseURI string, subscriptionID string) EligibleChildResourcesClient {
	return EligibleChildResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get the child resources of a resource on which user has eligible access
// Parameters:
// scope - the scope of the role management policy.
// filter - the filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
// resource of type = 'Subscription'. Use
// $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
// 'Subscription' or 'ResourceGroup'
func (client EligibleChildResourcesClient) Get(ctx context.Context, scope string, filter string) (result EligibleChildResourcesListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EligibleChildResourcesClient.Get")
		defer func() {
			sc := -1
			if result.ecrlr.Response.Response != nil {
				sc = result.ecrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getNextResults
	req, err := client.GetPreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.EligibleChildResourcesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.ecrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.EligibleChildResourcesClient", "Get", resp, "Failure sending request")
		return
	}

	result.ecrlr, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.EligibleChildResourcesClient", "Get", resp, "Failure responding to request")
		return
	}
	if result.ecrlr.hasNextLink() && result.ecrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client EligibleChildResourcesClient) GetPreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/eligibleChildResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client EligibleChildResourcesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client EligibleChildResourcesClient) GetResponder(resp *http.Response) (result EligibleChildResourcesListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getNextResults retrieves the next set of results, if any.
func (client EligibleChildResourcesClient) getNextResults(ctx context.Context, lastResults EligibleChildResourcesListResult) (result EligibleChildResourcesListResult, err error) {
	req, err := lastResults.eligibleChildResourcesListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.EligibleChildResourcesClient", "getNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.EligibleChildResourcesClient", "getNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.EligibleChildResourcesClient", "getNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetComplete enumerates all values, automatically crossing page boundaries as required.
func (client EligibleChildResourcesClient) GetComplete(ctx context.Context, scope string, filter string) (result EligibleChildResourcesListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EligibleChildResourcesClient.Get")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.Get(ctx, scope, filter)
	return
}
